/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.rest.mappers;

import com.thoughtworks.xstream.XStream;
import com.xebialabs.deployit.ClosingExceptionMapper;
import com.xebialabs.deployit.Exceptions;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.core.rest.resteasy.PathInterceptor;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.engine.spi.exception.HttpResponseCodeResult;
import com.xebialabs.deployit.engine.spi.exception.SuppressStackTrace;
import com.xebialabs.deployit.rest.mappers.DeployitExceptionHandler;
import com.xebialabs.xltype.serialization.xstream.XStreamReaderWriter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Provider
@Component
public class DeployitExceptionMapper
extends ClosingExceptionMapper<DeployitException>
implements ExceptionMapper<DeployitException> {
    @Context
    private HttpServletRequest request;
    private XStream xStream;
    private static ThreadLocal<Boolean> doCDataWrapping = new ThreadLocal();
    private static String logMsg = "Intercepting DeployitException";

    public static void doCDataWrapping(boolean wrap) {
        doCDataWrapping.set(wrap);
    }

    @Autowired
    public DeployitExceptionMapper(ServerConfiguration config) {
        this(XStreamReaderWriter.getConfiguredXStream(), config);
    }

    public DeployitExceptionMapper(XStream xStream, ServerConfiguration config) {
        super(config.isHideInternals());
        this.xStream = xStream;
    }

    @Override
    public Response handleException(DeployitException exception) {
        this.handleLogging(exception);
        int status = this.getResponseStatus(exception);
        String content = this.getContent(exception);
        Response resp = this.checkWhetherWeHideInternals(status, (RuntimeException)exception, content);
        if (resp != null) {
            return resp;
        }
        Response.ResponseBuilder response = Response.status((int)status);
        response.header("X-Deployit-Exception", (Object)"true");
        response.header("X-Exception-Type", (Object)exception.getClass().getName());
        response.header("X-Path", PathInterceptor.PATH.get());
        List<MediaType> acceptHeaders = this.determineAcceptMediaType();
        if (acceptHeaders.stream().anyMatch(h -> "binary".equals(h.getParameters().get("xl-exception")))) {
            response.entity((Object)new ByteArrayInputStream(this.toBytes(exception)));
            response.type("application/octet-stream");
        } else if (exception.hasEntity()) {
            if (acceptHeaders.stream().anyMatch(arg_0 -> ((MediaType)MediaType.APPLICATION_JSON_TYPE).isCompatible(arg_0))) {
                response.entity(DeployitExceptionHandler.getJsonEntity(exception));
            } else {
                response.entity((Object)content);
                response.type("application/xml");
            }
            response.header("X-Entity", (Object)"true");
        } else {
            response.entity((Object)content);
            response.type("text/plain");
        }
        return response.build();
    }

    private byte[] toBytes(DeployitException exception) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            new ObjectOutputStream(out).writeObject(exception);
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected List<MediaType> determineAcceptMediaType() {
        if (this.request.getHeader("Accept-Type") != null) {
            return Collections.singletonList(MediaType.valueOf((String)this.request.getHeader("Accept-Type")));
        }
        if (this.request.getHeaders("Accept") != null) {
            return Collections.list(this.request.getHeaders("Accept")).stream().flatMap(h -> Arrays.stream(h.split(","))).map(val -> MediaType.valueOf((String)val.trim())).collect(Collectors.toList());
        }
        return Collections.singletonList(MediaType.APPLICATION_XML_TYPE);
    }

    private String getContent(DeployitException exception) {
        Object content;
        if (exception.hasEntity()) {
            content = this.xStream.toXML(exception.getEntity());
        } else {
            content = Exceptions.getAllMessages((Exception)exception);
            Boolean wrap = doCDataWrapping.get();
            if (wrap != null && wrap.booleanValue()) {
                content = "<![CDATA[" + ((String)content).replace("]]>", "___") + "]]>";
            }
        }
        return content;
    }

    private void handleLogging(DeployitException exception) {
        SuppressStackTrace annotation = exception.getClass().getAnnotation(SuppressStackTrace.class);
        this.logger.info(exception.getMessage());
        if (annotation.suppressStackTrace()) {
            this.logger.trace(logMsg, (Throwable)exception);
        } else {
            this.logger.info(logMsg, (Throwable)exception);
        }
    }

    private int getResponseStatus(DeployitException exception) {
        HttpResponseCodeResult annotation = exception.getClass().getAnnotation(HttpResponseCodeResult.class);
        int status = 500;
        if (annotation != null) {
            status = annotation.statusCode();
        }
        return status;
    }
}

