/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.stitch.service;

import com.xebialabs.deployit.core.rest.view.RuleListItemView;
import com.xebialabs.deployit.core.rest.view.RuleWithSourceContentView;
import com.xebialabs.deployit.core.rest.view.RuleWithSourceContentView$;
import com.xebialabs.deployit.engine.api.dto.SaveFileDto;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.stitch.dao.BaseSpecificationRepository;
import com.xebialabs.deployit.plugin.stitch.dao.SourceSyncStateRepository;
import com.xebialabs.deployit.plugin.stitch.dao.jpa.RuleRepository;
import com.xebialabs.deployit.plugin.stitch.dao.jpa.configuration.TransactionalStitchService;
import com.xebialabs.deployit.plugin.stitch.model.SourceSyncState;
import com.xebialabs.deployit.plugin.stitch.model.ci.GitSource;
import com.xebialabs.deployit.plugin.stitch.model.specification.Rule;
import com.xebialabs.deployit.plugin.stitch.service.GitOpsService;
import com.xebialabs.deployit.plugin.stitch.service.GitService;
import com.xebialabs.deployit.plugin.stitch.service.RuleGitOpsService;
import com.xebialabs.deployit.plugin.stitch.service.StitchRulesConverter;
import com.xebialabs.deployit.plugin.stitch.service.ValidationServiceImpl;
import com.xebialabs.deployit.plugin.stitch.service.engine.index.BranchSyncStarter$;
import com.xebialabs.deployit.plugin.stitch.service.engine.index.crawler.RepositoryCrawler;
import com.xebialabs.deployit.plugin.stitch.service.engine.index.crawler.RepositoryCrawler$StitchRepositoryLoadException$;
import com.xebialabs.deployit.plugin.stitch.service.engine.index.crawler.StitchDefinitionsWithContent;
import com.xebialabs.deployit.plugin.stitch.service.package$;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.sql.CiResolver;
import com.xebialabs.deployit.service.controltask.ControlTaskService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.UUID;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Service
@TransactionalStitchService
@Autowired
@ScalaSignature(bytes="\u0006\u0005\u0005mf\u0001\u0002\b\u0010\u0001qA\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tq\u0001\u0011\t\u0011)A\u0005s!A\u0011\t\u0001B\u0001B\u0003%!\t\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003H\u0011!Q\u0005A!A!\u0002\u0013Y\u0005\u0002\u0003(\u0001\u0005\u0003\u0005\u000b\u0011B(\t\u0011I\u0003!\u0011!Q\u0001\nMC\u0001B\u0016\u0001\u0003\u0002\u0003\u0006Ia\u0016\u0005\u0006=\u0002!\ta\u0018\u0005\u0006S\u0002!IA\u001b\u0005\u0006w\u0002!\t\u0005 \u0005\b\u0003\u0013\u0002A\u0011IA&\u0011\u001d\tY\u0007\u0001C!\u0003[\u0012\u0001\u0004R3gCVdGOU;mK\u001eKGo\u00149t'\u0016\u0014h/[2f\u0015\t\u0001\u0012#A\u0004tKJ4\u0018nY3\u000b\u0005I\u0019\u0012AB:uSR\u001c\u0007N\u0003\u0002\u0015+\u00051\u0001\u000f\\;hS:T!AF\f\u0002\u0011\u0011,\u0007\u000f\\8zSRT!\u0001G\r\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\u000e\u0002\u0007\r|Wn\u0001\u0001\u0014\t\u0001i2e\n\t\u0003=\u0005j\u0011a\b\u0006\u0002A\u0005)1oY1mC&\u0011!e\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0011*S\"A\b\n\u0005\u0019z!!\u0005*vY\u0016<\u0015\u000e^(qgN+'O^5dKB\u0011\u0001&L\u0007\u0002S)\u0011!fK\u0001\u0006g24GG\u001b\u0006\u0002Y\u0005AqM]5{u2,G-\u0003\u0002/S\t9Aj\\4hS:<\u0017A\u0003:fa>\u001c\u0018\u000e^8ssB\u0011\u0011GN\u0007\u0002e)\u00111\u0007N\u0001\u0004UB\f'BA\u001b\u0012\u0003\r!\u0017m\\\u0005\u0003oI\u0012aBU;mKJ+\u0007o\\:ji>\u0014\u00180\u0001\u0006dSJ+7o\u001c7wKJ\u0004\"AO \u000e\u0003mR!\u0001P\u001f\u0002\u0007M\fHN\u0003\u0002?+\u0005A1/Z2ve&$\u00180\u0003\u0002Aw\tQ1)\u001b*fg>dg/\u001a:\u00023M|WO]2f'ft7m\u0015;bi\u0016\u0014V\r]8tSR|'/\u001f\t\u0003\u0007\u0012k\u0011\u0001N\u0005\u0003\u000bR\u0012\u0011dU8ve\u000e,7+\u001f8d'R\fG/\u001a*fa>\u001c\u0018\u000e^8ss\u0006Qq-\u001b;TKJ4\u0018nY3\u0011\u0005\u0011B\u0015BA%\u0010\u0005)9\u0015\u000e^*feZL7-Z\u0001\u000eO&$x\n]:TKJ4\u0018nY3\u0011\u0005\u0011b\u0015BA'\u0010\u000559\u0015\u000e^(qgN+'O^5dK\u0006Qa/\u00197jI\u0006$\u0018n\u001c8\u0011\u0005\u0011\u0002\u0016BA)\u0010\u0005U1\u0016\r\\5eCRLwN\\*feZL7-Z%na2\fAc\u001d;ji\u000eD'+\u001e7fg\u000e{gN^3si\u0016\u0014\bC\u0001\u0013U\u0013\t)vB\u0001\u000bTi&$8\r\u001b*vY\u0016\u001c8i\u001c8wKJ$XM]\u0001\u0013G>tGO]8m)\u0006\u001c8nU3sm&\u001cW\r\u0005\u0002Y96\t\u0011L\u0003\u0002[7\u0006Y1m\u001c8ue>dG/Y:l\u0015\t\u0001R#\u0003\u0002^3\n\u00112i\u001c8ue>dG+Y:l'\u0016\u0014h/[2f\u0003\u0019a\u0014N\\5u}QI\u0001-\u00192dI\u00164w\r\u001b\t\u0003I\u0001AQaL\u0005A\u0002ABQ\u0001O\u0005A\u0002eBQ!Q\u0005A\u0002\tCQAR\u0005A\u0002\u001dCQAS\u0005A\u0002-CQAT\u0005A\u0002=CQAU\u0005A\u0002MCQAV\u0005A\u0002]\u000ba!\u001b3U_B[ECA6w!\ta7O\u0004\u0002ncB\u0011anH\u0007\u0002_*\u0011\u0001oG\u0001\u0007yI|w\u000e\u001e \n\u0005I|\u0012A\u0002)sK\u0012,g-\u0003\u0002uk\n11\u000b\u001e:j]\u001eT!A]\u0010\t\u000b]T\u0001\u0019\u0001=\u0002\u0005%$\u0007C\u0001\u0010z\u0013\tQxDA\u0002J]R\fA\u0001\\5tiRIQ0!\t\u0002<\u0005\u0005\u0013Q\t\t\u0006}\u0006\u001d\u0011Q\u0002\b\u0004\u007f\u0006\rab\u00018\u0002\u0002%\t\u0001%C\u0002\u0002\u0006}\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002\n\u0005-!\u0001\u0002'jgRT1!!\u0002 !\u0011\ty!!\b\u000e\u0005\u0005E!\u0002BA\n\u0003+\tAA^5fo*!\u0011qCA\r\u0003\u0011\u0011Xm\u001d;\u000b\u0007\u0005mQ#\u0001\u0003d_J,\u0017\u0002BA\u0010\u0003#\u0011\u0001CU;mK2K7\u000f^%uK64\u0016.Z<\t\u000f\u0005\r2\u00021\u0001\u0002&\u0005Ya.Y7fgB\f7-Z%e!\u0015q\u0012qEA\u0016\u0013\r\tIc\b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u00055\u0012qG\u0007\u0003\u0003_QA!!\r\u00024\u0005!Q\u000f^5m\u0015\t\t)$\u0001\u0003kCZ\f\u0017\u0002BA\u001d\u0003_\u0011A!V+J\t\"9\u0011QH\u0006A\u0002\u0005}\u0012a\u00038b[\u0016\u0004\u0016\r\u001e;fe:\u0004BAHA\u0014W\"1\u00111I\u0006A\u0002-\f\u0001b]8ve\u000e,\u0017\n\u001a\u0005\u0007\u0003\u000fZ\u0001\u0019A6\u0002\u0015\t\u0014\u0018M\\2i\u001d\u0006lW-\u0001\u0003tCZ,G\u0003BA'\u0003'\u00022AHA(\u0013\r\t\tf\b\u0002\u0005+:LG\u000fC\u0004\u0002V1\u0001\r!a\u0016\u0002\u0017M\fg/\u001a$jY\u0016$Eo\u001c\t\u0005\u00033\n9'\u0004\u0002\u0002\\)!\u0011QLA0\u0003\r!Go\u001c\u0006\u0005\u0003C\n\u0019'A\u0002ba&T1!!\u001a\u0016\u0003\u0019)gnZ5oK&!\u0011\u0011NA.\u0005-\u0019\u0016M^3GS2,G\t^8\u00025\u001d,GOU;mK\nKh)\u001e7m\u001d\u0006lW-\u00118e\u0005J\fgn\u00195\u0015\u0015\u0005=\u0014QOA=\u0003{\ny\b\u0005\u0003\u0002\u0010\u0005E\u0014\u0002BA:\u0003#\u0011\u0011DU;mK^KG\u000f[*pkJ\u001cWmQ8oi\u0016tGOV5fo\"1\u0011qO\u0007A\u0002-\f\u0011B\\1nKN\u0004\u0018mY3\t\r\u0005mT\u00021\u0001l\u0003\u0011q\u0017-\\3\t\r\u0005\u001dS\u00021\u0001l\u0011\u0019\t\u0019%\u0004a\u0001W\"\u001a\u0001!a!\u0011\t\u0005\u0015\u00151S\u0007\u0003\u0003\u000fSA!!#\u0002\f\u0006Q1\u000f^3sK>$\u0018\u0010]3\u000b\t\u00055\u0015qR\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\u0011\u0011\u0011S\u0001\u0004_J<\u0017\u0002BAK\u0003\u000f\u0013qaU3sm&\u001cW\rK\u0002\u0001\u00033\u0003B!a'\u0002\"6\u0011\u0011Q\u0014\u0006\u0004\u0003?\u0013\u0014!D2p]\u001aLw-\u001e:bi&|g.\u0003\u0003\u0002$\u0006u%A\u0007+sC:\u001c\u0018m\u0019;j_:\fGn\u0015;ji\u000eD7+\u001a:wS\u000e,\u0007f\u0001\u0001\u0002(B!\u0011\u0011VA\\\u001b\t\tYK\u0003\u0003\u0002.\u0006=\u0016AC1o]>$\u0018\r^5p]*!\u0011\u0011WAZ\u0003\u001d1\u0017m\u0019;pefTA!!.\u0002\f\u0006)!-Z1og&!\u0011\u0011XAV\u0005%\tU\u000f^8xSJ,G\r")
public class DefaultRuleGitOpsService
implements RuleGitOpsService,
Logging {
    private final RuleRepository repository;
    private final CiResolver ciResolver;
    private final SourceSyncStateRepository sourceSyncStateRepository;
    private final GitService gitService;
    private final GitOpsService gitOpsService;
    private final ValidationServiceImpl validation;
    private final StitchRulesConverter stitchRulesConverter;
    private final ControlTaskService controlTaskService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DefaultRuleGitOpsService defaultRuleGitOpsService = this;
        synchronized (defaultRuleGitOpsService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private String idToPK(int id) {
        return this.ciResolver.getIdFromPk((Number)BoxesRunTime.boxToInteger((int)id));
    }

    @Override
    public List<RuleListItemView> list(Option<UUID> namespaceId, Option<String> namePattern, String sourceId, String branchName) {
        GitSource source = this.gitService.fetchGitSourceCi(sourceId);
        Buffer rules = CollectionConverters$.MODULE$.ListHasAsScala(this.repository.listByFilter(new BaseSpecificationRepository.SpecificationFilter(namespaceId, namePattern, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(source.get$internalId()))), (Option<String>)Option$.MODULE$.apply((Object)branchName)))).asScala();
        Option<SourceSyncState> syncState = this.sourceSyncStateRepository.getBySourceIdAndBranchName(Predef$.MODULE$.Integer2int(source.get$internalId()), (Option<String>)new Some((Object)branchName));
        return ((IterableOnceOps)rules.map((Function1 & Serializable)rule -> package$.MODULE$.createRuleListItemView((Rule)rule, this.idToPK(rule.sourceId()), syncState))).toList();
    }

    @Override
    public void save(SaveFileDto saveFileDto) {
        GitSource gitSource = this.gitService.fetchGitSourceCi(saveFileDto.sourceId());
        try {
            StitchDefinitionsWithContent stitchDefinitions = this.stitchRulesConverter.convert(saveFileDto.stitchRule());
            this.validation.validateRuleExist(stitchDefinitions);
        }
        catch (RepositoryCrawler.StitchRepositoryLoadException e) {
            throw e;
        }
        catch (Throwable e) {
            this.warn((Function0<Object>)(Function0 & Serializable)() -> "Error parsing rule", (Function0<Throwable>)(Function0 & Serializable)() -> e);
            throw RepositoryCrawler$StitchRepositoryLoadException$.MODULE$.apply("Stitch rule file can not be parsed. Please check the file formatting.");
        }
        this.gitService.save(saveFileDto.directory(), saveFileDto.fileName(), saveFileDto.stitchRule(), saveFileDto.branch(), gitSource);
        BranchSyncStarter$.MODULE$.scanBranchesSource(this.controlTaskService, gitSource, saveFileDto.branch(), Permissions.getAuthentication());
    }

    @Override
    public RuleWithSourceContentView getRuleByFullNameAndBranch(String namespace, String name, String branchName, String sourceId) {
        Rule rule;
        Option option = this.repository.getByNamespaceAndNameAndBranchName(namespace, name, branchName);
        if (option instanceof Some) {
            Rule rule2;
            Some some = (Some)option;
            rule = rule2 = (Rule)some.value();
        } else {
            GitSource source = this.gitService.fetchGitSourceCi(sourceId);
            if (this.gitOpsService.branchExists(source, branchName)) {
                throw new NotFoundException("Rule with name [" + name + "] under namespace [" + namespace + "] not found on branch [" + branchName + "]. Selected rule should first be created on selected branch.", new Object[0]);
            }
            rule = (Rule)this.repository.getByNamespaceAndName(namespace, name).getOrElse((Function0 & Serializable)() -> {
                throw new NotFoundException("Rule with name [" + name + "] under namespace [" + namespace + "] not found on branches [" + source.masterBranchName() + ", " + branchName + "] ", new Object[0]);
            });
        }
        Rule spec = rule;
        return RuleWithSourceContentView$.MODULE$.rule2RuleWithContentView((Rule)this.repository.get(spec.id()).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Rule with id [" + spec + ".id] not found", new Object[0]);
        }));
    }

    public DefaultRuleGitOpsService(RuleRepository repository, CiResolver ciResolver, SourceSyncStateRepository sourceSyncStateRepository, GitService gitService, GitOpsService gitOpsService, ValidationServiceImpl validation, StitchRulesConverter stitchRulesConverter, ControlTaskService controlTaskService) {
        this.repository = repository;
        this.ciResolver = ciResolver;
        this.sourceSyncStateRepository = sourceSyncStateRepository;
        this.gitService = gitService;
        this.gitOpsService = gitOpsService;
        this.validation = validation;
        this.stitchRulesConverter = stitchRulesConverter;
        this.controlTaskService = controlTaskService;
        Logging.$init$((Logging)this);
    }
}

