/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.impl.number;

import java.util.ArrayList;
import java.util.List;
import org.python.icu.impl.number.DecimalQuantity;
import org.python.icu.impl.number.LongNameHandler;
import org.python.icu.impl.number.MicroProps;
import org.python.icu.impl.number.MicroPropsGenerator;
import org.python.icu.impl.number.MixedUnitLongNameHandler;
import org.python.icu.number.NumberFormatter;
import org.python.icu.text.PluralRules;
import org.python.icu.util.MeasureUnit;
import org.python.icu.util.ULocale;

public class LongNameMultiplexer
implements MicroPropsGenerator {
    private final MicroPropsGenerator fParent;
    private List<ParentlessMicroPropsGenerator> fHandlers;
    private List<MeasureUnit> fMeasureUnits;

    public LongNameMultiplexer(MicroPropsGenerator fParent) {
        this.fParent = fParent;
    }

    public static LongNameMultiplexer forMeasureUnits(ULocale locale2, List<MeasureUnit> units, NumberFormatter.UnitWidth width, String unitDisplayCase, PluralRules rules, MicroPropsGenerator parent) {
        LongNameMultiplexer result2 = new LongNameMultiplexer(parent);
        assert (units.size() > 0);
        result2.fMeasureUnits = new ArrayList<MeasureUnit>();
        result2.fHandlers = new ArrayList<ParentlessMicroPropsGenerator>();
        for (int i = 0; i < units.size(); ++i) {
            MeasureUnit unit = units.get(i);
            result2.fMeasureUnits.add(unit);
            if (unit.getComplexity() == MeasureUnit.Complexity.MIXED) {
                MixedUnitLongNameHandler mlnh = MixedUnitLongNameHandler.forMeasureUnit(locale2, unit, width, unitDisplayCase, rules, null);
                result2.fHandlers.add(mlnh);
                continue;
            }
            LongNameHandler lnh = LongNameHandler.forMeasureUnit(locale2, unit, width, unitDisplayCase, rules, null);
            result2.fHandlers.add(lnh);
        }
        return result2;
    }

    @Override
    public MicroProps processQuantity(DecimalQuantity quantity) {
        MicroProps micros = this.fParent.processQuantity(quantity);
        for (int i = 0; i < this.fHandlers.size(); ++i) {
            if (!this.fMeasureUnits.get(i).equals(micros.outputUnit)) continue;
            ParentlessMicroPropsGenerator handler2 = this.fHandlers.get(i);
            return handler2.processQuantityWithMicros(quantity, micros);
        }
        throw new AssertionError((Object)" We shouldn't receive any outputUnit for which we haven't already got a LongNameHandler");
    }

    public static interface ParentlessMicroPropsGenerator {
        public MicroProps processQuantityWithMicros(DecimalQuantity var1, MicroProps var2);
    }
}

