/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.env;

import com.xebialabs.deployit.resolver.XLPluginAwareResourcePatternResolver;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class SpringPoweredScanner {
    private final ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);

    public SpringPoweredScanner() {
        this.provider.setResourceLoader((ResourceLoader)new XLPluginAwareResourcePatternResolver());
    }

    public <T> Set<Class<? extends T>> getSubTypesOf(Class<T> clazz) {
        this.provider.addIncludeFilter((TypeFilter)new AssignableTypeFilter(clazz));
        Set<Class<T>> aiDigital = this.findSubClassesIn("ai/digital", clazz);
        Set<Class<T>> comXebialabs = this.findSubClassesIn("com/xebialabs", clazz);
        Set<Class<T>> extDeployit = this.findSubClassesIn("ext/deployit", clazz);
        aiDigital.addAll(comXebialabs);
        aiDigital.addAll(extDeployit);
        return aiDigital;
    }

    private <T> Set<Class<? extends T>> findSubClassesIn(String packageName, Class<T> subclass) {
        return this.provider.findCandidateComponents(packageName).stream().map(beanDefinition -> this.getClassAsSubclassOf(subclass, beanDefinition.getBeanClassName())).collect(Collectors.toSet());
    }

    private <T> Class<? extends T> getClassAsSubclassOf(Class<T> clazz, String className) {
        try {
            return Class.forName(className).asSubclass(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

