/*
 * Decompiled with CFR 0.152.
 */
package com.github.drapostolos.typeparser;

import com.github.drapostolos.typeparser.GenericType;
import com.github.drapostolos.typeparser.InputPreprocessor;
import com.github.drapostolos.typeparser.InputPreprocessorHelper;
import com.github.drapostolos.typeparser.ParserInvoker;
import com.github.drapostolos.typeparser.Parsers;
import com.github.drapostolos.typeparser.SplitStrategy;
import com.github.drapostolos.typeparser.TargetTypeChecker;
import com.github.drapostolos.typeparser.TypeParserBuilder;
import com.github.drapostolos.typeparser.TypeParserUtility;
import java.lang.reflect.Type;

public final class TypeParser {
    final Parsers parsers;
    final SplitStrategy splitStrategy;
    final SplitStrategy keyValueSplitStrategy;
    final InputPreprocessor inputPreprocessor;

    public static TypeParserBuilder newBuilder() {
        return new TypeParserBuilder();
    }

    TypeParser(TypeParserBuilder builder) {
        this.parsers = Parsers.unmodifiableCopy(builder.parsers);
        this.splitStrategy = builder.splitStrategy;
        this.keyValueSplitStrategy = builder.keyValueSplitStrategy;
        this.inputPreprocessor = builder.inputPreprocessor;
    }

    public <T> T parse(String input, Class<T> targetType) {
        if (input == null) {
            throw new NullPointerException(TypeParserUtility.makeNullArgumentErrorMsg("input"));
        }
        if (targetType == null) {
            throw new NullPointerException(TypeParserUtility.makeNullArgumentErrorMsg("targetType"));
        }
        Object temp = this.parseType2(input, targetType);
        return (T)temp;
    }

    public <T> T parse(String input, GenericType<T> genericType) {
        if (input == null) {
            throw new NullPointerException(TypeParserUtility.makeNullArgumentErrorMsg("input"));
        }
        if (genericType == null) {
            throw new NullPointerException(TypeParserUtility.makeNullArgumentErrorMsg("genericType"));
        }
        Object temp = this.parseType2(input, genericType.getType());
        return (T)temp;
    }

    public Object parseType(String input, Type targetType) {
        if (input == null) {
            throw new NullPointerException(TypeParserUtility.makeNullArgumentErrorMsg("input"));
        }
        if (targetType == null) {
            throw new NullPointerException(TypeParserUtility.makeNullArgumentErrorMsg("targetType"));
        }
        return this.parseType2(input, targetType);
    }

    public boolean isTargetTypeParsable(GenericType<?> genericType) {
        return this.isTargetTypeParsable(genericType.getType());
    }

    public boolean isTargetTypeParsable(Type targetType) {
        TargetTypeChecker isTargetTypeParsable = new TargetTypeChecker(this, targetType);
        return (Boolean)isTargetTypeParsable.execute();
    }

    private Object parseType2(String input, Type targetType) {
        String preprocessedInput = this.preProcessInputString(input, targetType);
        if (preprocessedInput == null && this.isPrimitive(targetType)) {
            String message = "'%s' primitive can not be set to null. Input: \"%s\"; Preprocessed input: \"%s\"";
            throw new IllegalArgumentException(String.format(message, targetType, input, preprocessedInput));
        }
        ParserInvoker invoker = new ParserInvoker(this, targetType, preprocessedInput);
        return invoker.execute();
    }

    private String preProcessInputString(String input, Type targetType) {
        try {
            return this.inputPreprocessor.prepare(input, new InputPreprocessorHelper(targetType));
        }
        catch (Exception e) {
            String message = "Exception thrown from InputPreprocessor: %s [%s] with message:  %s. See underlying exception for more information.";
            message = String.format(message, this.inputPreprocessor, this.inputPreprocessor.getClass(), e.getMessage());
            message = TypeParserUtility.makeParseErrorMsg(input, targetType, message);
            throw new IllegalArgumentException(message, e);
        }
    }

    private boolean isPrimitive(Type targetType) {
        if (targetType instanceof Class) {
            Class c = (Class)targetType;
            return c.isPrimitive();
        }
        return false;
    }
}

