/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.uri.schemas.clusterConnection;

import java.net.URI;
import java.util.Map;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.uri.schemas.clusterConnection.ClusterConnectionStaticSchema;
import org.apache.activemq.artemis.utils.uri.BeanSupport;
import org.apache.activemq.artemis.utils.uri.URISupport;

public class ClusterConnectionMulticastSchema
extends ClusterConnectionStaticSchema {
    @Override
    public String getSchemaName() {
        return "multicast";
    }

    @Override
    public void populateObject(URI uri, ClusterConnectionConfiguration bean) throws Exception {
        if (URISupport.isCompositeURI((URI)uri)) {
            super.populateObject(uri, bean);
        } else {
            bean.setDiscoveryGroupName(uri.getHost());
            Map parameters = URISupport.parseParameters((URI)uri);
            BeanSupport.setData((URI)uri, (Object)bean, (Map)parameters);
        }
    }
}

