/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftp;

import java.net.Proxy;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.Range;
import org.apache.commons.net.ftp.parser.FTPFileEntryParserFactory;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.ftp.FtpFileSystem;
import org.apache.commons.vfs2.provider.ftp.FtpFileType;

public class FtpFileSystemConfigBuilder
extends FileSystemConfigBuilder {
    private static final String PREFIX = FtpFileSystemConfigBuilder.class.getName();
    private static final FtpFileSystemConfigBuilder BUILDER = new FtpFileSystemConfigBuilder();
    private static final String AUTODETECT_UTF8 = PREFIX + ".AUTODETECT_UTF8";
    private static final String CONNECT_TIMEOUT = PREFIX + ".CONNECT_TIMEOUT";
    private static final String DATA_TIMEOUT = PREFIX + ".DATA_TIMEOUT";
    private static final String DEFAULT_DATE_FORMAT = PREFIX + ".DEFAULT_DATE_FORMAT";
    private static final String ENCODING = PREFIX + ".ENCODING";
    private static final String FACTORY_KEY = FTPFileEntryParserFactory.class.getName() + ".KEY";
    private static final String FILE_TYPE = PREFIX + ".FILE_TYPE";
    private static final String PASSIVE_MODE = PREFIX + ".PASSIVE";
    private static final String ACTIVE_PORT_RANGE = PREFIX + ".ACTIVE_PORT_RANGE";
    private static final String PROXY = PREFIX + ".PROXY";
    private static final String RECENT_DATE_FORMAT = PREFIX + ".RECENT_DATE_FORMAT";
    private static final String REMOTE_VERIFICATION = PREFIX + ".REMOTE_VERIFICATION";
    private static final String SERVER_LANGUAGE_CODE = PREFIX + ".SERVER_LANGUAGE_CODE";
    private static final String SERVER_TIME_ZONE_ID = PREFIX + ".SERVER_TIME_ZONE_ID";
    private static final String SHORT_MONTH_NAMES = PREFIX + ".SHORT_MONTH_NAMES";
    private static final String SO_TIMEOUT = PREFIX + ".SO_TIMEOUT";
    private static final String CONTROL_KEEP_ALIVE_TIMEOUT = PREFIX + ".CONTROL_KEEP_ALIVE_TIMEOUT";
    private static final String CONTROL_KEEP_ALIVE_REPLY_TIMEOUT = PREFIX + ".CONTROL_KEEP_ALIVE_REPLY_TIMEOUT";
    private static final String USER_DIR_IS_ROOT = PREFIX + ".USER_DIR_IS_ROOT";
    private static final String TRANSFER_ABORTED_OK_REPLY_CODES = PREFIX + ".TRANSFER_ABORTED_OK_REPLY_CODES";
    private static final String MDTM_LAST_MODIFED_TIME = PREFIX + ".MDTM_LAST_MODIFED_TIME";

    public static FtpFileSystemConfigBuilder getInstance() {
        return BUILDER;
    }

    public static List<Integer> getSaneTransferAbortedOkReplyCodes() {
        return new ArrayList<Integer>(Arrays.asList(426, 550));
    }

    private FtpFileSystemConfigBuilder() {
        super("ftp.");
    }

    protected FtpFileSystemConfigBuilder(String prefix) {
        super(prefix);
    }

    public Range<Integer> getActivePortRange(FileSystemOptions options) {
        return (Range)this.getParam(options, ACTIVE_PORT_RANGE);
    }

    public Boolean getAutodetectUtf8(FileSystemOptions options) {
        return this.getBoolean(options, AUTODETECT_UTF8);
    }

    @Override
    protected Class<? extends FileSystem> getConfigClass() {
        return FtpFileSystem.class;
    }

    @Deprecated
    public Integer getConnectTimeout(FileSystemOptions options) {
        return this.getDurationInteger(options, CONNECT_TIMEOUT);
    }

    public Duration getConnectTimeoutDuration(FileSystemOptions options) {
        return this.getDuration(options, CONNECT_TIMEOUT);
    }

    public String getControlEncoding(FileSystemOptions options) {
        return this.getString(options, ENCODING);
    }

    public Duration getControlKeepAliveReplyTimeout(FileSystemOptions options) {
        return this.getDuration(options, CONTROL_KEEP_ALIVE_REPLY_TIMEOUT);
    }

    public Duration getControlKeepAliveTimeout(FileSystemOptions options) {
        return this.getDuration(options, CONTROL_KEEP_ALIVE_TIMEOUT);
    }

    @Deprecated
    public Integer getDataTimeout(FileSystemOptions options) {
        return this.getDurationInteger(options, DATA_TIMEOUT);
    }

    public Duration getDataTimeoutDuration(FileSystemOptions options) {
        return this.getDuration(options, DATA_TIMEOUT);
    }

    public String getDefaultDateFormat(FileSystemOptions options) {
        return this.getString(options, DEFAULT_DATE_FORMAT);
    }

    public String getEntryParser(FileSystemOptions options) {
        return this.getString(options, FACTORY_KEY);
    }

    public FTPFileEntryParserFactory getEntryParserFactory(FileSystemOptions options) {
        return (FTPFileEntryParserFactory)this.getParam(options, FTPFileEntryParserFactory.class.getName());
    }

    public FtpFileType getFileType(FileSystemOptions options) {
        return this.getEnum(FtpFileType.class, options, FILE_TYPE);
    }

    public Boolean getMdtmLastModifiedTime(FileSystemOptions options) {
        return this.getBoolean(options, MDTM_LAST_MODIFED_TIME);
    }

    public Boolean getPassiveMode(FileSystemOptions options) {
        return this.getBoolean(options, PASSIVE_MODE);
    }

    public Proxy getProxy(FileSystemOptions options) {
        return (Proxy)this.getParam(options, PROXY);
    }

    public String getRecentDateFormat(FileSystemOptions options) {
        return this.getString(options, RECENT_DATE_FORMAT);
    }

    public Boolean getRemoteVerification(FileSystemOptions options) {
        return this.getBoolean(options, REMOTE_VERIFICATION);
    }

    public String getServerLanguageCode(FileSystemOptions options) {
        return this.getString(options, SERVER_LANGUAGE_CODE);
    }

    public String getServerTimeZoneId(FileSystemOptions options) {
        return this.getString(options, SERVER_TIME_ZONE_ID);
    }

    public String[] getShortMonthNames(FileSystemOptions options) {
        return (String[])this.getParam(options, SHORT_MONTH_NAMES);
    }

    @Deprecated
    public Integer getSoTimeout(FileSystemOptions options) {
        return this.getDurationInteger(options, SO_TIMEOUT);
    }

    public Duration getSoTimeoutDuration(FileSystemOptions options) {
        return this.getDuration(options, SO_TIMEOUT);
    }

    public List<Integer> getTransferAbortedOkReplyCodes(FileSystemOptions options) {
        return (List)this.getParam(options, TRANSFER_ABORTED_OK_REPLY_CODES);
    }

    public Boolean getUserDirIsRoot(FileSystemOptions options) {
        return this.getBoolean(options, USER_DIR_IS_ROOT, Boolean.TRUE);
    }

    public void setActivePortRange(FileSystemOptions options, Range<Integer> portRange) {
        this.setParam(options, ACTIVE_PORT_RANGE, portRange);
    }

    public void setAutodetectUtf8(FileSystemOptions options, Boolean autodetectUTF8) {
        this.setParam(options, AUTODETECT_UTF8, autodetectUTF8);
    }

    public void setConnectTimeout(FileSystemOptions options, Duration duration) {
        this.setParam(options, CONNECT_TIMEOUT, duration);
    }

    @Deprecated
    public void setConnectTimeout(FileSystemOptions options, Integer duration) {
        this.setConnectTimeout(options, Duration.ofMillis(duration.intValue()));
    }

    public void setControlEncoding(FileSystemOptions options, String encoding) {
        this.setParam(options, ENCODING, encoding);
    }

    public void setControlKeepAliveReplyTimeout(FileSystemOptions options, Duration duration) {
        this.setParam(options, CONTROL_KEEP_ALIVE_REPLY_TIMEOUT, duration);
    }

    public void setControlKeepAliveTimeout(FileSystemOptions options, Duration duration) {
        this.setParam(options, CONTROL_KEEP_ALIVE_TIMEOUT, duration);
    }

    public void setDataTimeout(FileSystemOptions options, Duration duration) {
        this.setParam(options, DATA_TIMEOUT, duration);
    }

    @Deprecated
    public void setDataTimeout(FileSystemOptions options, Integer duration) {
        this.setDataTimeout(options, Duration.ofMillis(duration.intValue()));
    }

    public void setDefaultDateFormat(FileSystemOptions options, String defaultDateFormat) {
        this.setParam(options, DEFAULT_DATE_FORMAT, defaultDateFormat);
    }

    public void setEntryParser(FileSystemOptions options, String key) {
        this.setParam(options, FACTORY_KEY, key);
    }

    public void setEntryParserFactory(FileSystemOptions options, FTPFileEntryParserFactory factory) {
        this.setParam(options, FTPFileEntryParserFactory.class.getName(), factory);
    }

    public void setFileType(FileSystemOptions options, FtpFileType ftpFileType) {
        this.setParam(options, FILE_TYPE, (Object)ftpFileType);
    }

    public void setMdtmLastModifiedTime(FileSystemOptions options, boolean mdtm) {
        this.setParam(options, MDTM_LAST_MODIFED_TIME, this.toBooleanObject(mdtm));
    }

    public void setPassiveMode(FileSystemOptions options, boolean passiveMode) {
        this.setParam(options, PASSIVE_MODE, this.toBooleanObject(passiveMode));
    }

    public void setProxy(FileSystemOptions options, Proxy proxy) {
        this.setParam(options, PROXY, proxy);
    }

    public void setRecentDateFormat(FileSystemOptions options, String recentDateFormat) {
        this.setParam(options, RECENT_DATE_FORMAT, recentDateFormat);
    }

    public void setRemoteVerification(FileSystemOptions options, boolean remoteVerification) {
        this.setParam(options, REMOTE_VERIFICATION, remoteVerification);
    }

    public void setServerLanguageCode(FileSystemOptions options, String serverLanguageCode) {
        this.setParam(options, SERVER_LANGUAGE_CODE, serverLanguageCode);
    }

    public void setServerTimeZoneId(FileSystemOptions options, String serverTimeZoneId) {
        this.setParam(options, SERVER_TIME_ZONE_ID, serverTimeZoneId);
    }

    public void setShortMonthNames(FileSystemOptions options, String[] shortMonthNames) {
        String[] clone = null;
        if (shortMonthNames != null) {
            clone = Arrays.copyOf(shortMonthNames, shortMonthNames.length);
        }
        this.setParam(options, SHORT_MONTH_NAMES, clone);
    }

    public void setSoTimeout(FileSystemOptions options, Duration timeout) {
        this.setParam(options, SO_TIMEOUT, timeout);
    }

    @Deprecated
    public void setSoTimeout(FileSystemOptions options, Integer timeout) {
        this.setSoTimeout(options, Duration.ofMillis(timeout.intValue()));
    }

    public void setTransferAbortedOkReplyCodes(FileSystemOptions options, List<Integer> replyCodes) {
        this.setParam(options, TRANSFER_ABORTED_OK_REPLY_CODES, replyCodes);
    }

    public void setUserDirIsRoot(FileSystemOptions options, boolean userDirIsRoot) {
        this.setParam(options, USER_DIR_IS_ROOT, this.toBooleanObject(userDirIsRoot));
    }
}

