/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.ui;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.util.StringUtils;
import org.springframework.web.util.HtmlUtils;

final class HtmlTemplates {
    private HtmlTemplates() {
    }

    static Builder fromTemplate(String template) {
        return new Builder(template);
    }

    static final class Builder {
        private final String template;
        private final Map<String, String> values = new HashMap<String, String>();

        private Builder(String template) {
            this.template = template;
        }

        Builder withValue(String key, String value) {
            this.values.put(key, HtmlUtils.htmlEscape((String)value));
            return this;
        }

        Builder withRawHtml(String key, String value) {
            if (!value.isEmpty() && value.charAt(value.length() - 1) == '\n') {
                value = value.substring(0, value.length() - 1);
            }
            this.values.put(key, value);
            return this;
        }

        String render() {
            String template = this.template;
            for (String key : this.values.keySet()) {
                String pattern = Pattern.quote("{{" + key + "}}");
                template = template.replaceAll(pattern, this.values.get(key));
            }
            String unusedPlaceholders = Pattern.compile("\\{\\{([a-zA-Z0-9]+)}}").matcher(template).results().map(result -> result.group(1)).collect(Collectors.joining(", "));
            if (StringUtils.hasLength((String)unusedPlaceholders)) {
                throw new IllegalStateException("Unused placeholders in template: [%s]".formatted(unusedPlaceholders));
            }
            return template;
        }
    }
}

