/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.util.Tuple;
import com.xebialabs.xlplatform.coc.dto.SCMTraceabilityData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class ChangeSet {
    private SCMTraceabilityData scmTraceabilityData;
    private List<ConfigurationItem> createCis = new ArrayList<ConfigurationItem>();
    private List<ConfigurationItem> updateCis = new ArrayList<ConfigurationItem>();
    private List<Tuple<Integer, String>> deleteCiIds = new ArrayList<Tuple<Integer, String>>();
    private List<ConfigurationItem> createOrUpdateCis = new ArrayList<ConfigurationItem>();
    private List<Tuple<String, String>> renameCis = new ArrayList<Tuple<String, String>>();
    private List<Tuple<String, String>> moveCis = new ArrayList<Tuple<String, String>>();
    private List<Tuple<String, String>> copyCis = new ArrayList<Tuple<String, String>>();
    private boolean disableVersionHistory = false;
    private List<ConfigurationItem> createOrUpdateActualUpdatedCis = new ArrayList<ConfigurationItem>();
    private List<ConfigurationItem> createOrUpdateActualCreatedCis = new ArrayList<ConfigurationItem>();
    private boolean forceRedeploy;

    public void create(ConfigurationItem ci) {
        this.createCis.add(ci);
    }

    public void create(List<? extends ConfigurationItem> entities) {
        this.createCis.addAll(entities);
    }

    public void update(ConfigurationItem ci) {
        this.updateCis.add(ci);
    }

    public void update(List<? extends ConfigurationItem> entities) {
        this.updateCis.addAll(entities);
    }

    public void createOrUpdate(ConfigurationItem entity) {
        this.createOrUpdateCis.add(entity);
    }

    public void createOrUpdate(List<? extends ConfigurationItem> entities) {
        this.createOrUpdateCis.addAll(entities);
    }

    public void delete(ConfigurationItem ci) {
        this.deleteCiIds.add((Tuple<Integer, String>)new Tuple((Object)ci.get$internalId(), (Object)ci.getId()));
    }

    public void delete(List<Tuple<Integer, String>> ids) {
        this.deleteCiIds.addAll(ids);
    }

    public void delete(Collection<? extends ConfigurationItem> cis) {
        this.delete(cis.stream().map(ci -> new Tuple((Object)ci.get$internalId(), (Object)ci.getId())).collect(Collectors.toList()));
    }

    public void deleteByIds(List<String> ids) {
        this.delete(ids.stream().map(id -> new Tuple(null, id)).collect(Collectors.toList()));
    }

    public void deleteById(String id) {
        this.deleteCiIds.add((Tuple<Integer, String>)new Tuple(null, (Object)id));
    }

    public void rename(String id, String newName) {
        this.renameCis.add((Tuple<String, String>)Tuple.of((Object)id, (Object)newName));
    }

    public void rename(ConfigurationItem ci, String newName) {
        this.renameCis.add((Tuple<String, String>)Tuple.of((Object)ci.getId(), (Object)newName));
    }

    public void move(String ci, String newId) {
        this.moveCis.add((Tuple<String, String>)Tuple.of((Object)ci, (Object)newId));
    }

    public void copy(String ci, String newId) {
        this.copyCis.add((Tuple<String, String>)Tuple.of((Object)ci, (Object)newId));
    }

    public void setDisableVersionHistory(boolean checkPointRequested) {
        this.disableVersionHistory = checkPointRequested;
    }

    public SCMTraceabilityData getSCMTraceabilityData() {
        return this.scmTraceabilityData;
    }

    public void setSCMTraceabilityData(SCMTraceabilityData scmTraceabilityData) {
        this.scmTraceabilityData = scmTraceabilityData;
    }

    public List<ConfigurationItem> getCreateCis() {
        return this.createCis;
    }

    public List<ConfigurationItem> getUpdateCis() {
        return this.updateCis;
    }

    public List<ConfigurationItem> getCreateOrUpdateCis() {
        return this.createOrUpdateCis;
    }

    public List<String> getDeleteCiIds() {
        return this.deleteCiIds.stream().map(Tuple::getB).collect(Collectors.toList());
    }

    public List<Tuple<Integer, String>> getDeleteCiIdsWithInternalIds() {
        return this.deleteCiIds;
    }

    public List<Tuple<String, String>> getRenameCis() {
        return this.renameCis;
    }

    public List<Tuple<String, String>> getMoveCis() {
        return this.moveCis;
    }

    public List<Tuple<String, String>> getCopyCis() {
        return this.copyCis;
    }

    public List<ConfigurationItem> getCreateOrUpdateActualUpdatedCis() {
        return this.createOrUpdateActualUpdatedCis;
    }

    public List<ConfigurationItem> getCreateOrUpdateActualCreatedCis() {
        return this.createOrUpdateActualCreatedCis;
    }

    public boolean isDisableVersionHistory() {
        return this.disableVersionHistory;
    }

    public boolean isForceRedeploy() {
        return this.forceRedeploy;
    }

    public void setForceRedeploy(boolean forceRedeploy) {
        this.forceRedeploy = forceRedeploy;
    }
}

