/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.util.List;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.DB2iSqlAstTranslator;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.identity.DB2IdentityColumnSupport;
import org.hibernate.dialect.identity.DB2zIdentityColumnSupport;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.pagination.FetchLimitHandler;
import org.hibernate.dialect.pagination.LegacyDB2LimitHandler;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.sequence.DB2iSequenceSupport;
import org.hibernate.dialect.sequence.NoSequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.mapping.Column;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class DB2iDialect
extends DB2Dialect {
    private static final DatabaseVersion MINIMUM_VERSION = DatabaseVersion.make(7, 1);
    static final DatabaseVersion DB2_LUW_VERSION = DB2Dialect.MINIMUM_VERSION;

    public DB2iDialect(DialectResolutionInfo info) {
        this(info.makeCopyOrDefault(MINIMUM_VERSION));
        this.registerKeywords(info);
    }

    public DB2iDialect() {
        this(MINIMUM_VERSION);
    }

    public DB2iDialect(DatabaseVersion version) {
        super(version);
    }

    @Override
    protected DatabaseVersion getMinimumSupportedVersion() {
        return MINIMUM_VERSION;
    }

    @Override
    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        if (this.getVersion().isSameOrAfter(7, 2)) {
            CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
            functionFactory.listagg(null);
            functionFactory.inverseDistributionOrderedSetAggregates();
            functionFactory.hypotheticalOrderedSetAggregates_windowEmulation();
        }
    }

    @Override
    public DatabaseVersion getDB2Version() {
        return DB2_LUW_VERSION;
    }

    @Override
    public String getCreateIndexString(boolean unique) {
        return unique ? "create unique where not null index" : "create index";
    }

    @Override
    public String getCreateIndexTail(boolean unique, List<Column> columns) {
        return "";
    }

    @Override
    public boolean supportsDistinctFromPredicate() {
        return true;
    }

    @Override
    public boolean supportsUpdateReturning() {
        return false;
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return this.getVersion().isSameOrAfter(7, 3) ? DB2iSequenceSupport.INSTANCE : NoSequenceSupport.INSTANCE;
    }

    @Override
    public String getQuerySequencesString() {
        if (this.getVersion().isSameOrAfter(7, 3)) {
            return "select distinct sequence_name from qsys2.syssequences where current_schema='*LIBL' and sequence_schema in (select schema_name from qsys2.library_list_info) or sequence_schema=current_schema";
        }
        return null;
    }

    @Override
    public LimitHandler getLimitHandler() {
        return this.getVersion().isSameOrAfter(7, 3) ? FetchLimitHandler.INSTANCE : LegacyDB2LimitHandler.INSTANCE;
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return this.getVersion().isSameOrAfter(7, 3) ? DB2IdentityColumnSupport.INSTANCE : DB2zIdentityColumnSupport.INSTANCE;
    }

    @Override
    public boolean supportsSkipLocked() {
        return true;
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            @Override
            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new DB2iSqlAstTranslator(sessionFactory, statement, DB2iDialect.this.getVersion());
            }
        };
    }

    @Override
    public String rowId(String rowId) {
        return rowId == null || rowId.isEmpty() ? "rowid_" : rowId;
    }

    @Override
    public int rowIdSqlType() {
        return -8;
    }

    @Override
    public String getRowIdColumnString(String rowId) {
        return this.rowId(rowId) + " rowid not null generated always";
    }
}

