/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.lang.reflect.Type;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.dialect.StructHelper;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.UnknownBasicJavaType;
import org.hibernate.type.descriptor.jdbc.AggregateJdbcType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.spi.TypeConfiguration;

public class StructJdbcType
implements AggregateJdbcType {
    public static final AggregateJdbcType INSTANCE = new StructJdbcType();
    private final String typeName;
    private final int[] orderMapping;
    private final int[] inverseOrderMapping;
    private final EmbeddableMappingType embeddableMappingType;
    private final ValueExtractor<Object[]> objectArrayExtractor;

    private StructJdbcType() {
        this(null, null, null);
    }

    public StructJdbcType(EmbeddableMappingType embeddableMappingType, String typeName, int[] orderMapping) {
        this.embeddableMappingType = embeddableMappingType;
        this.typeName = typeName;
        this.orderMapping = orderMapping;
        if (orderMapping == null) {
            this.inverseOrderMapping = null;
        } else {
            int[] inverseOrderMapping = new int[orderMapping.length];
            for (int i = 0; i < orderMapping.length; ++i) {
                inverseOrderMapping[orderMapping[i]] = i;
            }
            this.inverseOrderMapping = inverseOrderMapping;
        }
        this.objectArrayExtractor = this.createBasicExtractor(new UnknownBasicJavaType<Object[]>(Object[].class));
    }

    @Override
    public int getJdbcTypeCode() {
        return 2002;
    }

    @Override
    public AggregateJdbcType resolveAggregateJdbcType(EmbeddableMappingType mappingType, String sqlType, RuntimeModelCreationContext creationContext) {
        return new StructJdbcType(mappingType, sqlType, creationContext.getBootModel().getDatabase().getDefaultNamespace().locateUserDefinedType(Identifier.toIdentifier(sqlType)).getOrderMapping());
    }

    @Override
    public EmbeddableMappingType getEmbeddableMappingType() {
        return this.embeddableMappingType;
    }

    @Override
    public <T> JavaType<T> getJdbcRecommendedJavaTypeMapping(Integer precision, Integer scale, TypeConfiguration typeConfiguration) {
        if (this.embeddableMappingType == null) {
            return typeConfiguration.getJavaTypeRegistry().getDescriptor((Type)((Object)Object[].class));
        }
        return this.embeddableMappingType.getMappedJavaType();
    }

    @Override
    public void registerOutParameter(CallableStatement callableStatement, String name) throws SQLException {
        callableStatement.registerOutParameter(name, this.getJdbcTypeCode(), this.typeName);
    }

    @Override
    public void registerOutParameter(CallableStatement callableStatement, int index) throws SQLException {
        callableStatement.registerOutParameter(index, this.getJdbcTypeCode(), this.typeName);
    }

    @Override
    public Object createJdbcValue(Object domainValue, WrapperOptions options) throws SQLException {
        Object[] jdbcValues = StructHelper.getJdbcValues(this.embeddableMappingType, this.orderMapping, this.embeddableMappingType.getValues(domainValue), options);
        return options.getSession().getJdbcCoordinator().getLogicalConnection().getPhysicalConnection().createStruct(this.typeName, jdbcValues);
    }

    @Override
    public Object[] extractJdbcValues(Object rawJdbcValue, WrapperOptions options) throws SQLException {
        Object[] attributes = ((Struct)rawJdbcValue).getAttributes();
        this.wrapRawJdbcValues(this.embeddableMappingType, this.orderMapping, this.inverseOrderMapping, attributes, 0, options);
        return attributes;
    }

    @Override
    public <X> ValueBinder<X> getBinder(JavaType<X> javaType) {
        return new BasicBinder<X>(javaType, this){

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                st.setObject(index, StructJdbcType.this.createJdbcValue(value, options));
            }

            @Override
            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                st.setObject(name, StructJdbcType.this.createJdbcValue(value, options));
            }
        };
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
        if (javaType.getJavaTypeClass() == Object[].class) {
            return this.objectArrayExtractor;
        }
        return this.createBasicExtractor(javaType);
    }

    private <X> BasicExtractor<X> createBasicExtractor(JavaType<X> javaType) {
        return new BasicExtractor<X>(javaType, this){

            @Override
            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return this.getValue(rs.getObject(paramIndex), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return this.getValue(statement.getObject(index), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return this.getValue(statement.getObject(name), options);
            }

            private X getValue(Object object, WrapperOptions options) throws SQLException {
                boolean jdbcRepresentation;
                if (object == null) {
                    return null;
                }
                Struct struct = (Struct)object;
                Object[] values = struct.getAttributes();
                boolean bl = jdbcRepresentation = this.getJavaType().getJavaTypeClass() == Object[].class;
                if (jdbcRepresentation) {
                    StructJdbcType.this.wrapRawJdbcValues(StructJdbcType.this.embeddableMappingType, StructJdbcType.this.orderMapping, StructJdbcType.this.inverseOrderMapping, values, 0, options);
                    return values;
                }
                assert (StructJdbcType.this.embeddableMappingType != null && StructJdbcType.this.embeddableMappingType.getJavaType() == this.getJavaType());
                Object[] attributeValues = StructJdbcType.this.getAttributeValues(StructJdbcType.this.embeddableMappingType, StructJdbcType.this.orderMapping, values, options);
                return StructJdbcType.this.embeddableMappingType.getRepresentationStrategy().getInstantiator().instantiate(() -> attributeValues, options.getSessionFactory());
            }
        };
    }

    private Object[] getAttributeValues(EmbeddableMappingType embeddableMappingType, int[] orderMapping, Object[] rawJdbcValues, WrapperOptions options) throws SQLException {
        int numberOfAttributeMappings = embeddableMappingType.getNumberOfAttributeMappings();
        Object[] attributeValues = numberOfAttributeMappings != rawJdbcValues.length || orderMapping != null ? new Object[numberOfAttributeMappings] : rawJdbcValues;
        int jdbcIndex = 0;
        for (int i = 0; i < numberOfAttributeMappings; ++i) {
            int attributeIndex = orderMapping == null ? i : orderMapping[i];
            AttributeMapping attributeMapping = embeddableMappingType.getAttributeMapping(attributeIndex);
            jdbcIndex += this.injectAttributeValue(attributeMapping, attributeValues, attributeIndex, rawJdbcValues, jdbcIndex, options);
        }
        return attributeValues;
    }

    private int injectAttributeValue(AttributeMapping attributeMapping, Object[] attributeValues, int attributeIndex, Object[] rawJdbcValues, int jdbcIndex, WrapperOptions options) throws SQLException {
        int jdbcValueCount;
        MappingType mappedType = attributeMapping.getMappedType();
        Object rawJdbcValue = rawJdbcValues[jdbcIndex];
        if (mappedType instanceof EmbeddableMappingType) {
            EmbeddableMappingType embeddableMappingType = (EmbeddableMappingType)mappedType;
            if (embeddableMappingType.getAggregateMapping() != null) {
                jdbcValueCount = 1;
                if (rawJdbcValue == null) {
                    attributeValues[attributeIndex] = null;
                } else {
                    AggregateJdbcType aggregateJdbcType = (AggregateJdbcType)embeddableMappingType.getAggregateMapping().getJdbcMapping().getJdbcType();
                    Object[] subValues = aggregateJdbcType instanceof StructJdbcType ? this.getAttributeValues(embeddableMappingType, ((StructJdbcType)aggregateJdbcType).orderMapping, ((Struct)rawJdbcValue).getAttributes(), options) : aggregateJdbcType.extractJdbcValues(rawJdbcValue, options);
                    attributeValues[attributeIndex] = embeddableMappingType.getRepresentationStrategy().getInstantiator().instantiate(() -> subValues, embeddableMappingType.findContainingEntityMapping().getEntityPersister().getFactory());
                }
            } else {
                jdbcValueCount = embeddableMappingType.getJdbcValueCount();
                Object[] jdbcValues = new Object[jdbcValueCount];
                System.arraycopy(rawJdbcValues, jdbcIndex, jdbcValues, 0, jdbcValues.length);
                Object[] subValues = this.getAttributeValues(embeddableMappingType, null, jdbcValues, options);
                attributeValues[attributeIndex] = embeddableMappingType.getRepresentationStrategy().getInstantiator().instantiate(() -> subValues, embeddableMappingType.findContainingEntityMapping().getEntityPersister().getFactory());
            }
        } else {
            Object jdbcValue;
            assert (attributeMapping.getJdbcTypeCount() == 1);
            jdbcValueCount = 1;
            JdbcMapping jdbcMapping = attributeMapping.getSingleJdbcMapping();
            if (rawJdbcValue == null) {
                jdbcValue = null;
            } else {
                switch (jdbcMapping.getJdbcType().getDefaultSqlTypeCode()) {
                    case 2014: 
                    case 3003: {
                        jdbcValue = jdbcMapping.getJdbcJavaType().wrap(this.transformRawJdbcValue(rawJdbcValue, options), options);
                        break;
                    }
                    default: {
                        jdbcValue = jdbcMapping.getJdbcJavaType().wrap(rawJdbcValue, options);
                    }
                }
            }
            attributeValues[attributeIndex] = jdbcMapping.convertToDomainValue(jdbcValue);
        }
        return jdbcValueCount;
    }

    private int wrapRawJdbcValues(EmbeddableMappingType embeddableMappingType, int[] orderMapping, int[] inverseOrderMapping, Object[] jdbcValues, int jdbcIndex, WrapperOptions options) throws SQLException {
        Object[] targetJdbcValues = orderMapping == null ? jdbcValues : (Object[])jdbcValues.clone();
        int numberOfAttributeMappings = embeddableMappingType.getNumberOfAttributeMappings();
        for (int i = 0; i < numberOfAttributeMappings; ++i) {
            AttributeMapping attributeMapping = orderMapping == null ? embeddableMappingType.getAttributeMapping(i) : embeddableMappingType.getAttributeMapping(orderMapping[i]);
            MappingType mappedType = attributeMapping.getMappedType();
            if (mappedType instanceof EmbeddableMappingType) {
                EmbeddableMappingType embeddableType = (EmbeddableMappingType)mappedType;
                if (embeddableType.getAggregateMapping() != null) {
                    AggregateJdbcType aggregateJdbcType = (AggregateJdbcType)embeddableType.getAggregateMapping().getJdbcMapping().getJdbcType();
                    Object rawJdbcValue = targetJdbcValues[jdbcIndex];
                    targetJdbcValues[jdbcIndex] = aggregateJdbcType.extractJdbcValues(rawJdbcValue, options);
                    ++jdbcIndex;
                    continue;
                }
                jdbcIndex = this.wrapRawJdbcValues(embeddableType, null, null, targetJdbcValues, jdbcIndex, options);
                continue;
            }
            assert (attributeMapping.getJdbcTypeCount() == 1);
            Object rawJdbcValue = targetJdbcValues[jdbcIndex];
            if (rawJdbcValue != null) {
                JdbcMapping jdbcMapping = attributeMapping.getSingleJdbcMapping();
                switch (jdbcMapping.getJdbcType().getDefaultSqlTypeCode()) {
                    case 2013: 
                    case 2014: 
                    case 3003: 
                    case 3007: {
                        targetJdbcValues[jdbcIndex] = jdbcMapping.getJdbcJavaType().wrap(this.transformRawJdbcValue(rawJdbcValue, options), options);
                        break;
                    }
                    default: {
                        targetJdbcValues[jdbcIndex] = jdbcMapping.getJdbcJavaType().wrap(rawJdbcValue, options);
                    }
                }
            }
            ++jdbcIndex;
        }
        if (orderMapping != null) {
            StructHelper.orderJdbcValues(embeddableMappingType, inverseOrderMapping, targetJdbcValues, jdbcValues);
        }
        return jdbcIndex;
    }

    protected Object transformRawJdbcValue(Object rawJdbcValue, WrapperOptions options) {
        return rawJdbcValue;
    }
}

