/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.expression;

import org.hibernate.cache.MutableCacheKeyBuilder;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.IndexedConsumer;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.model.domain.EmbeddableDomainType;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaType;

public class EmbeddableTypeLiteral
implements Expression,
DomainResultProducer<Object>,
BasicValuedMapping {
    private final Class<?> embeddableClass;
    private final BasicType<?> basicType;

    public EmbeddableTypeLiteral(EmbeddableDomainType<?> embeddableDomainType, BasicType<?> basicType) {
        this.embeddableClass = embeddableDomainType.getJavaType();
        this.basicType = basicType;
    }

    public Object getEmbeddableClass() {
        return this.embeddableClass;
    }

    @Override
    public MappingModelExpressible<?> getExpressionType() {
        return this;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.basicType;
    }

    @Override
    public MappingType getMappedType() {
        return this.basicType;
    }

    @Override
    public int getJdbcTypeCount() {
        return this.basicType.getJdbcTypeCount();
    }

    @Override
    public JdbcMapping getJdbcMapping(int index) {
        return this.basicType.getJdbcMapping(index);
    }

    @Override
    public JdbcMapping getSingleJdbcMapping() {
        return this.basicType.getSingleJdbcMapping();
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        return this.basicType.forEachJdbcType(offset, action);
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        return this.basicType.disassemble(value, session);
    }

    @Override
    public void addToCacheKey(MutableCacheKeyBuilder cacheKey, Object value, SharedSessionContractImplementor session) {
        this.basicType.addToCacheKey(cacheKey, value, session);
    }

    @Override
    public <X, Y> int forEachDisassembledJdbcValue(Object value, int offset, X x, Y y, Bindable.JdbcValuesBiConsumer<X, Y> valuesConsumer, SharedSessionContractImplementor session) {
        return this.basicType.forEachDisassembledJdbcValue(value, offset, x, y, valuesConsumer, session);
    }

    @Override
    public <X, Y> int forEachJdbcValue(Object value, int offset, X x, Y y, Bindable.JdbcValuesBiConsumer<X, Y> valuesConsumer, SharedSessionContractImplementor session) {
        return this.basicType.forEachJdbcValue(value, offset, x, y, valuesConsumer, session);
    }

    @Override
    public void applySqlSelections(DomainResultCreationState creationState) {
        this.createSqlSelection(creationState);
    }

    @Override
    public DomainResult<Object> createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        return new BasicResult<Object>(this.createSqlSelection(creationState).getValuesArrayPosition(), resultVariable, this.basicType);
    }

    private SqlSelection createSqlSelection(DomainResultCreationState creationState) {
        return creationState.getSqlAstCreationState().getSqlExpressionResolver().resolveSqlSelection(this, this.basicType.getJdbcJavaType(), null, creationState.getSqlAstCreationState().getCreationContext().getMappingMetamodel().getTypeConfiguration());
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        sqlTreeWalker.visitEmbeddableTypeLiteral(this);
    }

    public JavaType getExpressibleJavaType() {
        return this.basicType.getExpressibleJavaType();
    }
}

