/*
 * Decompiled with CFR 0.152.
 */
package org.kamranzafar.jtar;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.kamranzafar.jtar.TarEntry;

public class TarInputStream
extends FilterInputStream {
    private static final int SKIP_BUFFER_SIZE = 2048;
    private TarEntry currentEntry;
    private long currentFileSize = 0L;
    private long bytesRead = 0L;
    private boolean defaultSkip = false;

    public TarInputStream(InputStream in) {
        super(in);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public int read() throws IOException {
        byte[] buf = new byte[1];
        int res = this.read(buf, 0, 1);
        if (res != -1) {
            return 0xFF & buf[0];
        }
        return res;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int br;
        if (this.currentEntry != null) {
            if (this.currentFileSize == this.currentEntry.getSize()) {
                return -1;
            }
            if (this.currentEntry.getSize() - this.currentFileSize < (long)len) {
                len = (int)(this.currentEntry.getSize() - this.currentFileSize);
            }
        }
        if ((br = super.read(b, off, len)) != -1) {
            if (this.currentEntry != null) {
                this.currentFileSize += (long)br;
            }
            this.bytesRead += (long)br;
        }
        return br;
    }

    public TarEntry getNextEntry() throws IOException {
        int res;
        this.closeCurrentEntry();
        byte[] header = new byte[512];
        byte[] theader = new byte[512];
        for (int tr = 0; tr < 512 && (res = this.read(theader, 0, 512 - tr)) >= 0; tr += res) {
            System.arraycopy(theader, 0, header, tr, res);
        }
        boolean eof = true;
        for (byte b : header) {
            if (b == 0) continue;
            eof = false;
            break;
        }
        if (!eof) {
            this.currentEntry = new TarEntry(header);
        }
        return this.currentEntry;
    }

    public long getCurrentOffset() {
        return this.bytesRead;
    }

    protected void closeCurrentEntry() throws IOException {
        if (this.currentEntry != null) {
            if (this.currentEntry.getSize() > this.currentFileSize) {
                long res;
                for (long bs = 0L; bs < this.currentEntry.getSize() - this.currentFileSize; bs += res) {
                    res = this.skip(this.currentEntry.getSize() - this.currentFileSize - bs);
                    if (res != 0L || this.currentEntry.getSize() - this.currentFileSize <= 0L) continue;
                    throw new IOException("Possible tar file corruption");
                }
            }
            this.currentEntry = null;
            this.currentFileSize = 0L;
            this.skipPad();
        }
    }

    protected void skipPad() throws IOException {
        int extra;
        if (this.bytesRead > 0L && (extra = (int)(this.bytesRead % 512L)) > 0) {
            long res;
            for (long bs = 0L; bs < (long)(512 - extra); bs += res) {
                res = this.skip((long)(512 - extra) - bs);
            }
        }
    }

    @Override
    public long skip(long n) throws IOException {
        long left;
        int res;
        if (this.defaultSkip) {
            long bs = super.skip(n);
            this.bytesRead += bs;
            return bs;
        }
        if (n <= 0L) {
            return 0L;
        }
        byte[] sBuff = new byte[2048];
        for (left = n; left > 0L && (res = this.read(sBuff, 0, (int)(left < 2048L ? left : 2048L))) >= 0; left -= (long)res) {
        }
        return n - left;
    }

    public boolean isDefaultSkip() {
        return this.defaultSkip;
    }

    public void setDefaultSkip(boolean defaultSkip) {
        this.defaultSkip = defaultSkip;
    }
}

