/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.classfile;

import java.io.IOException;
import org.apache.derby.iapi.services.classfile.ClassFormatOutput;
import org.apache.derby.iapi.services.classfile.ClassHolder;
import org.apache.derby.iapi.services.classfile.ConstantPoolEntry;

public final class CONSTANT_Utf8_info
extends ConstantPoolEntry {
    private final String value;
    private int asString;
    private int asCode;

    CONSTANT_Utf8_info(String string) {
        super(1);
        this.value = string;
    }

    @Override
    Object getKey() {
        return this.value;
    }

    @Override
    int classFileSize() {
        return 3 + this.value.length();
    }

    public String toString() {
        return this.value;
    }

    int setAsCode() {
        if (ClassHolder.isExternalClassName(this.value)) {
            if (this.asString == 0) {
                this.asCode = this.getIndex();
            }
            return this.asCode;
        }
        return this.getIndex();
    }

    int setAsString() {
        if (ClassHolder.isExternalClassName(this.value)) {
            if (this.asCode == 0) {
                this.asString = this.getIndex();
            }
            return this.asString;
        }
        return this.getIndex();
    }

    void setAlternative(int n) {
        if (this.asCode == 0) {
            this.asCode = n;
        } else {
            this.asString = n;
        }
    }

    @Override
    void put(ClassFormatOutput classFormatOutput) throws IOException {
        super.put(classFormatOutput);
        if (this.getIndex() == this.asCode) {
            classFormatOutput.writeUTF(ClassHolder.convertToInternalClassName(this.value));
        } else {
            classFormatOutput.writeUTF(this.value);
        }
    }
}

