/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.util.NoSuchElementException;

public abstract class Either<A, B> {
    public static <A, B> Either<A, B> newLeft(A a) {
        return new Left(a);
    }

    public static <A, B> Either<A, B> newRight(B b) {
        return new Right(b);
    }

    public abstract Type type();

    public abstract A left();

    public abstract B right();

    private static class Left<A, B>
    extends Either<A, B> {
        private A leftValue;

        Left(A a) {
            this.leftValue = a;
        }

        @Override
        public Type type() {
            return Type.LEFT;
        }

        @Override
        public A left() {
            return this.leftValue;
        }

        @Override
        public B right() {
            throw new NoSuchElementException("Either.right() called on Left");
        }

        public String toString() {
            return "Left(" + String.valueOf(this.leftValue) + ")";
        }
    }

    private static class Right<A, B>
    extends Either<A, B> {
        private B rightValue;

        Right(B b) {
            this.rightValue = b;
        }

        @Override
        public Type type() {
            return Type.RIGHT;
        }

        @Override
        public A left() {
            throw new NoSuchElementException("Either.left() called on Right");
        }

        @Override
        public B right() {
            return this.rightValue;
        }

        public String toString() {
            return "Right(" + String.valueOf(this.rightValue) + ")";
        }
    }

    public static enum Type {
        LEFT,
        RIGHT;

    }
}

