/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.smi;

import java.io.IOException;
import java.io.OutputStream;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.smi.AbstractVariable;
import org.snmp4j.smi.AssignableFromByteArray;
import org.snmp4j.smi.AssignableFromInteger;
import org.snmp4j.smi.AssignableFromLong;
import org.snmp4j.smi.AssignableFromString;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariantVariableCallback;

public class VariantVariable
extends AbstractVariable
implements AssignableFromInteger,
AssignableFromLong,
AssignableFromString,
AssignableFromByteArray {
    private static final long serialVersionUID = -3678564678835871188L;
    private Variable variable;
    private VariantVariableCallback callback;

    public VariantVariable(Variable variable) {
        if (variable == null) {
            throw new NullPointerException();
        }
        this.variable = variable;
    }

    public VariantVariable(Variable variable, VariantVariableCallback variantVariableCallback) {
        this(variable);
        this.callback = variantVariableCallback;
    }

    public synchronized int compareTo(Object object) {
        this.updateVariable();
        return this.variable.compareTo(object);
    }

    protected void updateVariable() {
        if (this.callback != null) {
            this.callback.updateVariable(this);
        }
    }

    protected void variableUpdated() {
        if (this.callback != null) {
            this.callback.variableUpdated(this);
        }
    }

    public synchronized void decodeBER(BERInputStream bERInputStream) throws IOException {
        this.variable.decodeBER(bERInputStream);
        this.variableUpdated();
    }

    public synchronized void encodeBER(OutputStream outputStream) throws IOException {
        this.updateVariable();
        this.variable.encodeBER(outputStream);
    }

    public synchronized void fromSubIndex(OID oID, boolean bl) {
        this.variable.fromSubIndex(oID, bl);
        this.variableUpdated();
    }

    public synchronized int getBERLength() {
        this.updateVariable();
        return this.variable.getBERLength();
    }

    public int getSyntax() {
        return this.variable.getSyntax();
    }

    public synchronized int toInt() {
        this.updateVariable();
        return this.variable.toInt();
    }

    public synchronized long toLong() {
        this.updateVariable();
        return this.variable.toLong();
    }

    public synchronized byte[] toByteArray() {
        this.updateVariable();
        if (this.variable instanceof AssignableFromByteArray) {
            return ((AssignableFromByteArray)((Object)this.variable)).toByteArray();
        }
        throw new UnsupportedOperationException();
    }

    public synchronized OID toSubIndex(boolean bl) {
        this.updateVariable();
        return this.variable.toSubIndex(bl);
    }

    public synchronized boolean equals(Object object) {
        this.updateVariable();
        return ((Object)this.variable).equals(object);
    }

    public synchronized int hashCode() {
        this.updateVariable();
        return ((Object)this.variable).hashCode();
    }

    public synchronized String toString() {
        this.updateVariable();
        return ((Object)this.variable).toString();
    }

    public Object clone() {
        this.updateVariable();
        return new VariantVariable((Variable)this.variable.clone());
    }

    public synchronized void setValue(int n) {
        if (!(this.variable instanceof AssignableFromInteger)) {
            throw new ClassCastException("An integer value cannot be assigned to " + this.variable);
        }
        ((AssignableFromInteger)((Object)this.variable)).setValue(n);
    }

    public synchronized void setValue(long l) {
        if (!(this.variable instanceof AssignableFromLong)) {
            throw new ClassCastException("A long value cannot be assigned to " + this.variable);
        }
        ((AssignableFromLong)((Object)this.variable)).setValue(l);
    }

    public synchronized void setValue(OctetString octetString) {
        if (!(this.variable instanceof AssignableFromByteArray)) {
            throw new ClassCastException("An OctetString value cannot be assigned to " + this.variable);
        }
        ((AssignableFromByteArray)((Object)this.variable)).setValue(octetString.getValue());
    }

    public synchronized void setValue(byte[] byArray) {
        if (!(this.variable instanceof AssignableFromByteArray)) {
            throw new ClassCastException("A byte array value cannot be assigned to " + this.variable);
        }
        ((AssignableFromByteArray)((Object)this.variable)).setValue(byArray);
    }

    public synchronized void setValue(String string) {
        if (!(this.variable instanceof AssignableFromString)) {
            throw new ClassCastException("A string value cannot be assigned to " + this.variable);
        }
        ((AssignableFromString)((Object)this.variable)).setValue(string);
    }

    public Variable getVariable() {
        return this.variable;
    }

    public boolean isDynamic() {
        return true;
    }
}

