/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal.metadata;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.envers.boot.EnversMappingException;
import org.hibernate.envers.configuration.Configuration;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleComponentData;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleIdData;
import org.hibernate.envers.internal.entities.mapper.relation.query.OneEntityQueryGenerator;
import org.hibernate.envers.internal.entities.mapper.relation.query.RelationQueryGenerator;
import org.hibernate.envers.internal.entities.mapper.relation.query.ThreeEntityQueryGenerator;
import org.hibernate.envers.internal.entities.mapper.relation.query.TwoEntityOneAuditedQueryGenerator;
import org.hibernate.envers.internal.entities.mapper.relation.query.TwoEntityQueryGenerator;

public final class QueryGeneratorBuilder {
    private final Configuration configuration;
    private final MiddleIdData referencingIdData;
    private final String auditMiddleEntityName;
    private final List<MiddleIdData> idDatas;
    private final boolean revisionTypeInId;
    private final String orderByCollectionRole;

    QueryGeneratorBuilder(Configuration configuration, MiddleIdData referencingIdData, String auditMiddleEntityName, boolean revisionTypeInId, String orderByCollectionRole) {
        this.configuration = configuration;
        this.referencingIdData = referencingIdData;
        this.auditMiddleEntityName = auditMiddleEntityName;
        this.orderByCollectionRole = orderByCollectionRole;
        this.revisionTypeInId = revisionTypeInId;
        this.idDatas = new ArrayList<MiddleIdData>();
    }

    void addRelation(MiddleIdData idData) {
        this.idDatas.add(idData);
    }

    RelationQueryGenerator build(MiddleComponentData ... componentDatas) {
        if (this.idDatas.size() == 0) {
            return new OneEntityQueryGenerator(this.configuration, this.auditMiddleEntityName, this.referencingIdData, this.revisionTypeInId, componentDatas);
        }
        if (this.idDatas.size() == 1) {
            if (this.idDatas.get(0).isAudited()) {
                return new TwoEntityQueryGenerator(this.configuration, this.auditMiddleEntityName, this.referencingIdData, this.idDatas.get(0), this.revisionTypeInId, this.orderByCollectionRole, componentDatas);
            }
            return new TwoEntityOneAuditedQueryGenerator(this.configuration, this.auditMiddleEntityName, this.referencingIdData, this.idDatas.get(0), this.revisionTypeInId, this.orderByCollectionRole, componentDatas);
        }
        if (this.idDatas.size() == 2) {
            if (!this.idDatas.get(0).isAudited() || !this.idDatas.get(1).isAudited()) {
                throw new EnversMappingException("Ternary relations using @Audited(targetAuditMode = NOT_AUDITED) are not supported.");
            }
            return new ThreeEntityQueryGenerator(this.configuration, this.auditMiddleEntityName, this.referencingIdData, this.idDatas.get(0), this.idDatas.get(1), this.revisionTypeInId, this.orderByCollectionRole, componentDatas);
        }
        throw new IllegalStateException("Illegal number of related entities.");
    }

    int getCurrentIndex() {
        return this.idDatas.size();
    }
}

