/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.cluster.full.downing;

import com.xebialabs.xlplatform.cluster.NodeState$;
import com.xebialabs.xlplatform.cluster.full.downing.AutoDowning$;
import com.xebialabs.xlplatform.cluster.full.downing.LeaderAutoDowningActor;
import com.xebialabs.xlplatform.cluster.full.downing.LeaderAutoDowningActor$DownReachable$;
import com.xebialabs.xlplatform.cluster.full.downing.LeaderAutoDowningActor$DownUnreachable$;
import com.xebialabs.xlplatform.cluster.full.downing.MajorityLeaderAutoDowning$;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.Props;
import org.apache.pekko.cluster.Member;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u00055<Qa\u0003\u0007\t\u0002e1Qa\u0007\u0007\t\u0002qAQaI\u0001\u0005\u0002\u0011BQ!J\u0001\u0005\u0002\u00192Aa\u0007\u0007\u0001\u007f!IA\u0007\u0002B\u0001B\u0003%Qg\u0011\u0005\n}\u0011\u0011\t\u0011)A\u0005k\u0011CQa\t\u0003\u0005\u0002\u0015CQ!\u0013\u0003\u0005\u0002)CQ!\u0019\u0003\u0005B\tDQa\u001b\u0003\u0005B1\f\u0011$T1k_JLG/\u001f'fC\u0012,'/Q;u_\u0012{wO\\5oO*\u0011QBD\u0001\bI><h.\u001b8h\u0015\ty\u0001#\u0001\u0003gk2d'BA\t\u0013\u0003\u001d\u0019G.^:uKJT!a\u0005\u000b\u0002\u0015ad\u0007\u000f\\1uM>\u0014XN\u0003\u0002\u0016-\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002/\u0005\u00191m\\7\u0004\u0001A\u0011!$A\u0007\u0002\u0019\tIR*\u00196pe&$\u0018\u0010T3bI\u0016\u0014\u0018)\u001e;p\t><h.\u001b8h'\t\tQ\u0004\u0005\u0002\u001fC5\tqDC\u0001!\u0003\u0015\u00198-\u00197b\u0013\t\u0011sD\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\tQ\u0001\u001d:paN$2aJ\u001a>!\tA\u0013'D\u0001*\u0015\tQ3&A\u0003bGR|'O\u0003\u0002-[\u0005)\u0001/Z6l_*\u0011afL\u0001\u0007CB\f7\r[3\u000b\u0003A\n1a\u001c:h\u0013\t\u0011\u0014FA\u0003Qe>\u00048\u000fC\u00035\u0007\u0001\u0007Q'A\u0006ti\u0006\u0014G.Z!gi\u0016\u0014\bC\u0001\u001c<\u001b\u00059$B\u0001\u001d:\u0003!!WO]1uS>t'B\u0001\u001e \u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003y]\u0012aBR5oSR,G)\u001e:bi&|g\u000eC\u0003?\u0007\u0001\u0007Q'A\te_^t'+Z7pm\u0006dW*\u0019:hS:\u001c\"\u0001\u0002!\u0011\u0005i\t\u0015B\u0001\"\r\u0005YaU-\u00193fe\u0006+Ho\u001c#po:LgnZ!di>\u0014\u0018B\u0001\u001bB\u0013\tq\u0014\tF\u0002G\u000f\"\u0003\"A\u0007\u0003\t\u000bQ:\u0001\u0019A\u001b\t\u000by:\u0001\u0019A\u001b\u0002\r\u0011,7-\u001b3f)\u0005Y\u0005C\u0001'_\u001d\tiEL\u0004\u0002O7:\u0011qJ\u0017\b\u0003!fs!!\u0015-\u000f\u0005I;fBA*W\u001b\u0005!&BA+\u0019\u0003\u0019a$o\\8u}%\tq#\u0003\u0002\u0016-%\u00111\u0003F\u0005\u0003#II!a\u0004\t\n\u00055q\u0011BA/\r\u0003YaU-\u00193fe\u0006+Ho\u001c#po:LgnZ!di>\u0014\u0018BA0a\u0005)!un\u001e8BGRLwN\u001c\u0006\u0003;2\tA\u0001Z8x]R\u00111M\u001a\t\u0003=\u0011L!!Z\u0010\u0003\tUs\u0017\u000e\u001e\u0005\u0006O&\u0001\r\u0001[\u0001\u0005]>$W\r\u0005\u0002)S&\u0011!.\u000b\u0002\b\u0003\u0012$'/Z:t\u0003!!wn\u001e8TK24G#A2")
public class MajorityLeaderAutoDowning
extends LeaderAutoDowningActor {
    public static Props props(FiniteDuration stableAfter, FiniteDuration downRemovalMargin) {
        return MajorityLeaderAutoDowning$.MODULE$.props(stableAfter, downRemovalMargin);
    }

    @Override
    public LeaderAutoDowningActor.DownAction decide() {
        int unreachableSize = this.unreachableMembers().size();
        int membersSize = this.members().size();
        this.log().info("Deciding on current cluster state: " + unreachableSize + " of " + membersSize + " members unreachable.");
        if (unreachableSize * 2 == membersSize) {
            this.log().info("Both partitions are equal in size, break the tie by keeping the side with oldest member.");
            Address oldestMember = ((Member)this.members().head()).address();
            boolean oldestIsActive = this.isActiveMember(oldestMember);
            this.log().info("Oldest member [" + oldestMember + "] detected as being " + (oldestIsActive ? "active" : "inactive") + ".");
            if (this.unreachable().apply((Object)oldestMember) && oldestIsActive) {
                this.log().info("Downing my partition [" + this.reachable() + "] - other partition has active oldest.");
                return LeaderAutoDowningActor$DownReachable$.MODULE$;
            }
            if (this.reachable().apply((Object)oldestMember) && !oldestIsActive) {
                this.log().info("Downing my partition [" + this.reachable() + "] - my partition has invalid oldest.");
                return LeaderAutoDowningActor$DownReachable$.MODULE$;
            }
            this.log().info("Downing other partition [" + this.unreachable() + "] - my partition has the current active oldest.");
            return LeaderAutoDowningActor$DownUnreachable$.MODULE$;
        }
        if (unreachableSize * 2 < membersSize) {
            this.log().info("We are in majority, downing other partition [" + this.unreachable() + "].");
            return LeaderAutoDowningActor$DownUnreachable$.MODULE$;
        }
        this.log().info("We are in minority, downing my partition [" + this.reachable() + "].");
        return LeaderAutoDowningActor$DownReachable$.MODULE$;
    }

    @Override
    public void down(Address node) {
        this.log().info("Downing member [{}].", (Object)node);
        this.cluster().down(node);
    }

    @Override
    public void downSelf() {
        this.log().info("Deactivating myself.");
        NodeState$.MODULE$.setActive(false);
        AutoDowning$.MODULE$.setDowning(true);
        this.log().info("Downing myself.");
        this.shutdownMember();
    }

    public MajorityLeaderAutoDowning(FiniteDuration stableAfter, FiniteDuration downRemovalMargin) {
        super(stableAfter, downRemovalMargin);
    }
}

