/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import java.util.List;
import org.hibernate.AnnotationException;
import org.hibernate.annotations.JdbcTypeCode;
import org.hibernate.annotations.Struct;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.boot.model.internal.AggregateComponentSecondPass;
import org.hibernate.boot.model.internal.AnnotatedColumn;
import org.hibernate.boot.model.internal.AnnotatedColumns;
import org.hibernate.boot.model.internal.BasicValueBinder;
import org.hibernate.boot.model.internal.BinderHelper;
import org.hibernate.boot.model.internal.PropertyHolder;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.PropertyData;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.AggregateColumn;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Value;
import org.hibernate.type.descriptor.java.spi.EmbeddableAggregateJavaType;
import org.hibernate.type.spi.TypeConfiguration;

public final class AggregateComponentBinder {
    private AggregateComponentBinder() {
    }

    public static void processAggregate(Component component, PropertyHolder propertyHolder, PropertyData inferredData, XClass returnedClassOrElement, AnnotatedColumns columns, MetadataBuildingContext context) {
        if (AggregateComponentBinder.isAggregate(inferredData.getProperty(), inferredData.getClassOrElement())) {
            AggregateComponentBinder.validateComponent(component, BinderHelper.getPath(propertyHolder, inferredData));
            InFlightMetadataCollector metadataCollector = context.getMetadataCollector();
            TypeConfiguration typeConfiguration = metadataCollector.getTypeConfiguration();
            String structName = AggregateComponentBinder.determineStructName(columns, inferredData, returnedClassOrElement);
            typeConfiguration.getJavaTypeRegistry().resolveDescriptor(component.getComponentClass(), () -> new EmbeddableAggregateJavaType(component.getComponentClass(), structName));
            component.setStructName(structName);
            component.setStructColumnNames(AggregateComponentBinder.determineStructAttributeNames(inferredData, returnedClassOrElement));
            BasicValueBinder basicValueBinder = new BasicValueBinder(BasicValueBinder.Kind.ATTRIBUTE, component, context);
            basicValueBinder.setPropertyName(inferredData.getPropertyName());
            basicValueBinder.setReturnedClassName(inferredData.getClassOrElementName());
            basicValueBinder.setColumns(columns);
            basicValueBinder.setPersistentClassName(propertyHolder.getClassName());
            basicValueBinder.setType(inferredData.getProperty(), inferredData.getPropertyClass(), inferredData.getDeclaringClass().getName(), null);
            BasicValue propertyValue = basicValueBinder.make();
            AggregateColumn aggregateColumn = (AggregateColumn)propertyValue.getColumn();
            aggregateColumn.setSqlType(structName);
            if (structName != null) {
                aggregateColumn.setSqlTypeCode(2002);
            }
            component.setAggregateColumn(aggregateColumn);
            context.getMetadataCollector().addSecondPass(new AggregateComponentSecondPass(propertyHolder, component, returnedClassOrElement, context));
        }
    }

    private static void validateComponent(Component component, String basePath) {
        for (Property property : component.getProperties()) {
            Component c;
            Value value = property.getValue();
            if (!(value instanceof BasicValue) && !(value instanceof Component)) {
                throw new AnnotationException("Property '" + StringHelper.qualify(basePath, property.getName()) + "' uses not yet supported mapping type '" + value.getClass().getName() + "' in component class '" + component.getComponentClassName() + "'. Aggregate components currently may only contain basic values and components of basic values.");
            }
            if (!(value instanceof Component) || (c = (Component)value).getAggregateColumn() != null) continue;
            AggregateComponentBinder.validateComponent(c, StringHelper.qualify(basePath, property.getName()));
        }
    }

    private static String determineStructName(AnnotatedColumns columns, PropertyData inferredData, XClass returnedClassOrElement) {
        Struct struct;
        XProperty property = inferredData.getProperty();
        if (property != null) {
            List<AnnotatedColumn> columnList;
            struct = (Struct)property.getAnnotation(Struct.class);
            if (struct != null) {
                return struct.name();
            }
            JdbcTypeCode jdbcTypeCode = (JdbcTypeCode)property.getAnnotation(JdbcTypeCode.class);
            if (jdbcTypeCode != null && jdbcTypeCode.value() == 2002 && columns != null && (columnList = columns.getColumns()).size() == 1 && columnList.get(0).getSqlType() != null) {
                return columnList.get(0).getSqlType();
            }
        }
        if ((struct = (Struct)returnedClassOrElement.getAnnotation(Struct.class)) != null) {
            return struct.name();
        }
        return null;
    }

    private static String[] determineStructAttributeNames(PropertyData inferredData, XClass returnedClassOrElement) {
        Struct struct;
        XProperty property = inferredData.getProperty();
        if (property != null && (struct = (Struct)property.getAnnotation(Struct.class)) != null) {
            return struct.attributes();
        }
        struct = (Struct)returnedClassOrElement.getAnnotation(Struct.class);
        if (struct != null) {
            return struct.attributes();
        }
        return null;
    }

    private static boolean isAggregate(XProperty property, XClass returnedClass) {
        if (property != null) {
            Struct struct = (Struct)property.getAnnotation(Struct.class);
            if (struct != null) {
                return true;
            }
            JdbcTypeCode jdbcTypeCode = (JdbcTypeCode)property.getAnnotation(JdbcTypeCode.class);
            if (jdbcTypeCode != null) {
                switch (jdbcTypeCode.value()) {
                    case 2002: 
                    case 2009: 
                    case 3001: {
                        return true;
                    }
                }
            }
        }
        if (returnedClass != null) {
            return returnedClass.isAnnotationPresent(Struct.class);
        }
        return false;
    }
}

