/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.shared.common.error;

import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import org.apache.derby.shared.common.i18n.MessageService;
import org.apache.derby.shared.common.util.ArrayUtil;

public class StandardException
extends Exception {
    public static final int REPORT_DEFAULT = 0;
    public static final int REPORT_NEVER = 1;
    public static final int REPORT_ALWAYS = 2;
    private transient Object[] arguments;
    private int severity;
    private String textMessage;
    private String sqlState;
    private transient int report;
    private transient boolean isForPublicAPI;
    private transient SQLException next;

    protected StandardException(String string) {
        this(string, null, null);
    }

    protected StandardException(String string, Throwable throwable, Object[] objectArray) {
        super(string);
        this.severity = StandardException.getSeverityFromIdentifier(string);
        this.sqlState = StandardException.getSQLStateFromIdentifier(string);
        this.arguments = objectArray;
        if (throwable != null) {
            this.initCause(throwable);
        }
    }

    private StandardException(String string, String string2) {
        this(string);
        this.textMessage = string2;
    }

    public final Object[] getArguments() {
        return ArrayUtil.copy(this.arguments);
    }

    public final int report() {
        return this.report;
    }

    public final void setReport(int n) {
        this.report = n;
    }

    public final void setSeverity(int n) {
        this.severity = n;
    }

    public final int getSeverity() {
        return this.severity;
    }

    public final int getErrorCode() {
        return this.severity;
    }

    public final String getSQLState() {
        return this.sqlState;
    }

    public final SQLException getNextException() {
        return this.next;
    }

    final void markAsPublicAPI() {
        this.isForPublicAPI = true;
    }

    public static String getSQLStateFromIdentifier(String string) {
        if (string.length() == 5) {
            return string;
        }
        return string.substring(0, 5);
    }

    public static int getSeverityFromIdentifier(String string) {
        int n = 0;
        block0 : switch (string.length()) {
            case 5: {
                block3 : switch (string.charAt(0)) {
                    case '0': {
                        switch (string.charAt(1)) {
                            case '1': {
                                n = 10000;
                                break;
                            }
                            case '7': 
                            case 'A': {
                                n = 20000;
                                break;
                            }
                            case '8': {
                                n = 40000;
                            }
                        }
                        break;
                    }
                    case '2': 
                    case '3': {
                        n = 20000;
                        break;
                    }
                    case '4': {
                        switch (string.charAt(1)) {
                            case '0': {
                                n = 30000;
                                break block3;
                            }
                            case '2': {
                                n = 20000;
                            }
                        }
                    }
                }
                break;
            }
            default: {
                switch (string.charAt(6)) {
                    case 'M': {
                        n = 50000;
                        break block0;
                    }
                    case 'D': {
                        n = 45000;
                        break block0;
                    }
                    case 'C': {
                        n = 40000;
                        break block0;
                    }
                    case 'T': {
                        n = 30000;
                        break block0;
                    }
                    case 'S': {
                        n = 20000;
                        break block0;
                    }
                    case 'U': {
                        n = 0;
                    }
                }
            }
        }
        return n;
    }

    public static StandardException normalClose() {
        StandardException standardException = StandardException.newException("XXXXX.C.6", new Object[0]);
        standardException.report = 1;
        return standardException;
    }

    public static StandardException newException(String string, Object ... objectArray) {
        return StandardException.newException(string, null, objectArray);
    }

    public static StandardException newException(String string, Throwable throwable, Object ... objectArray) {
        return new StandardException(string, throwable, objectArray);
    }

    public static StandardException newException(String string, Object object, Throwable throwable) throws BadMessageArgumentException {
        throw new BadMessageArgumentException();
    }

    public static StandardException newException(String string, Object object, Object object2, Throwable throwable) throws BadMessageArgumentException {
        throw new BadMessageArgumentException();
    }

    public static StandardException newPreLocalizedException(String string, Throwable throwable, String string2) {
        StandardException standardException = new StandardException(string, string2);
        if (throwable != null) {
            standardException.initCause(throwable);
        }
        return standardException;
    }

    public static StandardException getArgumentFerry(SQLException sQLException) {
        Throwable throwable = sQLException.getCause();
        return throwable instanceof StandardException ? (StandardException)throwable : null;
    }

    private static boolean isVacuousWrapper(Throwable throwable) {
        if (throwable instanceof InvocationTargetException) {
            return throwable.getCause() != null;
        }
        return false;
    }

    public static StandardException unexpectedUserException(Throwable throwable) {
        String string;
        Object object;
        if (StandardException.isVacuousWrapper(throwable)) {
            return StandardException.unexpectedUserException(throwable.getCause());
        }
        StandardException standardException = null;
        if (throwable instanceof SQLException && (standardException = StandardException.getArgumentFerry((SQLException)(object = (SQLException)throwable))) != null && standardException.isForPublicAPI) {
            standardException.next = ((SQLException)object).getNextException();
            return standardException;
        }
        if (throwable instanceof SQLException && standardException == null && (string = ((SQLException)(object = (SQLException)throwable)).getSQLState()) != null && string.length() == 5 && string.startsWith("38") && !string.equals("38000")) {
            StandardException standardException2 = new StandardException(string, ((Throwable)object).getMessage());
            if (((SQLException)object).getNextException() != null) {
                standardException2.initCause(((SQLException)object).getNextException());
            }
            return standardException2;
        }
        if (throwable instanceof StandardException) {
            return (StandardException)throwable;
        }
        object = throwable.getMessage();
        object = object == null ? "" : ((String)object).trim();
        object = ((String)object).length() == 0 ? throwable.getClass().getName() : throwable.getClass().getName() + ": " + (String)object;
        return StandardException.newException("38000", throwable, object);
    }

    public static StandardException plainWrapException(Throwable throwable) {
        Object object;
        Object object2;
        if (StandardException.isVacuousWrapper(throwable)) {
            return StandardException.plainWrapException(throwable.getCause());
        }
        if (throwable instanceof StandardException) {
            return (StandardException)throwable;
        }
        if (throwable instanceof SQLException && (object2 = ((SQLException)(object = (SQLException)throwable)).getSQLState()) != null) {
            StandardException standardException = new StandardException((String)object2, "(" + ((SQLException)object).getErrorCode() + ") " + ((Throwable)object).getMessage());
            if ((object = ((SQLException)object).getNextException()) != null) {
                standardException.initCause(StandardException.plainWrapException((Throwable)object));
            }
            return standardException;
        }
        object = throwable.getMessage();
        object = object == null ? "" : ((String)object).trim();
        object2 = StandardException.newException("XJ001.U", throwable, object, throwable.getClass().getName());
        return object2;
    }

    public static StandardException closeException() {
        StandardException standardException = StandardException.newException("close.C.1", new Object[0]);
        standardException.setReport(1);
        return standardException;
    }

    @Override
    public String getMessage() {
        if (this.textMessage == null) {
            this.textMessage = MessageService.getTextMessage(this.getMessageId(), this.getArguments());
        }
        return this.textMessage;
    }

    public final String getMessageId() {
        return super.getMessage();
    }

    public String getErrorProperty(String string) {
        return StandardException.getErrorProperty(this.getMessageId(), string);
    }

    @Override
    public String toString() {
        String string = this.getMessage();
        return "ERROR " + this.getSQLState() + ": " + string;
    }

    private static String getErrorProperty(String string, String string2) {
        return MessageService.getProperty(string, string2);
    }

    public static StandardException interrupt(InterruptedException interruptedException) {
        StandardException standardException = StandardException.newException("08000", interruptedException, new Object[0]);
        return standardException;
    }

    public static SQLWarning newWarning(String string, Object ... objectArray) {
        String string2 = MessageService.getTextMessage(string, objectArray);
        String string3 = StandardException.getSQLStateFromIdentifier(string);
        SQLWarning sQLWarning = new SQLWarning(string2, string3, 10000);
        return sQLWarning;
    }

    public final boolean isLockTimeout() {
        return "40XL1".equals(this.getSQLState());
    }

    public final boolean isSelfDeadlock() {
        return "40XL2".equals(this.getSQLState());
    }

    public final boolean isLockTimeoutOrDeadlock() {
        return "40XL1".equals(this.getSQLState()) || "40001".equals(this.getSQLState());
    }

    public static class BadMessageArgumentException
    extends Throwable {
    }
}

