/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.Type;
import java.io.Serializable;
import java.lang.reflect.Member;
import org.hibernate.metamodel.AttributeClassification;
import org.hibernate.metamodel.internal.MetadataContext;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.model.domain.AnyMappingDomainType;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.IdentifiableDomainType;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.PluralPersistentAttribute;
import org.hibernate.metamodel.model.domain.SimpleDomainType;
import org.hibernate.metamodel.model.domain.SingularPersistentAttribute;
import org.hibernate.metamodel.model.domain.internal.AbstractAttribute;
import org.hibernate.metamodel.model.domain.spi.JpaMetamodelImplementor;
import org.hibernate.query.SemanticException;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.internal.SqmMappingModelHelper;
import org.hibernate.query.sqm.spi.SqmCreationHelper;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmSingularJoin;
import org.hibernate.query.sqm.tree.from.SqmAttributeJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.spi.EntityIdentifierNavigablePath;
import org.hibernate.spi.NavigablePath;
import org.hibernate.type.descriptor.java.JavaType;

public class SingularAttributeImpl<D, J>
extends AbstractAttribute<D, J, J>
implements SingularPersistentAttribute<D, J>,
Serializable {
    private final boolean isIdentifier;
    private final boolean isVersion;
    private final boolean isOptional;
    private final SqmPathSource<J> sqmPathSource;

    public SingularAttributeImpl(ManagedDomainType<D> declaringType, String name, AttributeClassification attributeClassification, DomainType<J> attributeType, JavaType<?> relationalJavaType, Member member, boolean isIdentifier, boolean isVersion, boolean isOptional, boolean isGeneric, MetadataContext metadataContext) {
        super(declaringType, name, attributeType.getExpressibleJavaType(), attributeClassification, attributeType, member, metadataContext);
        this.isIdentifier = isIdentifier;
        this.isVersion = isVersion;
        this.isOptional = isOptional;
        this.sqmPathSource = SqmMappingModelHelper.resolveSqmPathSource(name, this, attributeType, relationalJavaType, Bindable.BindableType.SINGULAR_ATTRIBUTE, isGeneric);
    }

    @Override
    public String getPathName() {
        return this.getName();
    }

    @Override
    public JavaType<J> getExpressibleJavaType() {
        return this.sqmPathSource.getExpressibleJavaType();
    }

    @Override
    public SimpleDomainType<J> getSqmPathType() {
        return (SimpleDomainType)this.sqmPathSource.getSqmPathType();
    }

    @Override
    public SimpleDomainType<J> getValueGraphType() {
        return this.getSqmPathType();
    }

    @Override
    public SimpleDomainType<?> getKeyGraphType() {
        Type attributeType = this.getType();
        return attributeType instanceof IdentifiableDomainType ? ((IdentifiableDomainType)attributeType).getIdType() : null;
    }

    @Override
    public SimpleDomainType<J> getType() {
        return this.getSqmPathType();
    }

    @Override
    public Class<J> getBindableJavaType() {
        return this.getJavaType();
    }

    @Override
    public SqmPathSource<?> findSubPathSource(String name) {
        return this.sqmPathSource.findSubPathSource(name);
    }

    @Override
    public SqmPathSource<?> findSubPathSource(String name, JpaMetamodelImplementor metamodel) {
        return this.sqmPathSource.findSubPathSource(name, metamodel);
    }

    @Override
    public SqmPathSource<J> getPathSource() {
        return this.sqmPathSource;
    }

    @Override
    public boolean isGeneric() {
        return this.sqmPathSource.isGeneric();
    }

    @Override
    public SqmAttributeJoin<D, J> createSqmJoin(SqmFrom<?, D> lhs, SqmJoinType joinType, String alias, boolean fetched, SqmCreationState creationState) {
        if (this.getType() instanceof AnyMappingDomainType) {
            throw new SemanticException("An @Any attribute cannot be join fetched");
        }
        return new SqmSingularJoin(lhs, this, alias, joinType, fetched, creationState.getCreationContext().getNodeBuilder());
    }

    @Override
    public NavigablePath createNavigablePath(SqmPath<?> parent, String alias) {
        DomainType<?> parentType;
        if (parent == null) {
            throw new IllegalArgumentException("LHS cannot be null for a sub-navigable reference - " + this.getName());
        }
        SqmPathSource<?> parentPathSource = parent.getResolvedModel();
        NavigablePath navigablePath = parent.getNavigablePath();
        if (parentPathSource instanceof PluralPersistentAttribute) {
            navigablePath = navigablePath.append(CollectionPart.Nature.ELEMENT.getName());
        }
        if ((parentType = parentPathSource.getSqmPathType()) != this.getDeclaringType() && parentType instanceof EntityDomainType && ((EntityDomainType)parentType).findSingularAttribute(this.getName()) == null) {
            navigablePath = navigablePath.treatAs(this.getDeclaringType().getTypeName());
        }
        return SqmCreationHelper.buildSubNavigablePath(navigablePath, this.getName(), alias);
    }

    public boolean isId() {
        return this.isIdentifier;
    }

    public boolean isVersion() {
        return this.isVersion;
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public boolean isAssociation() {
        return this.getPersistentAttributeType() == Attribute.PersistentAttributeType.MANY_TO_ONE || this.getPersistentAttributeType() == Attribute.PersistentAttributeType.ONE_TO_ONE;
    }

    public boolean isCollection() {
        return false;
    }

    public Bindable.BindableType getBindableType() {
        return Bindable.BindableType.SINGULAR_ATTRIBUTE;
    }

    @Override
    public SqmPath<J> createSqmPath(SqmPath<?> lhs, SqmPathSource<?> intermediatePathSource) {
        return this.sqmPathSource.createSqmPath(lhs, intermediatePathSource);
    }

    public static class Version<X, Y>
    extends SingularAttributeImpl<X, Y> {
        public Version(ManagedDomainType<X> declaringType, String name, AttributeClassification attributeClassification, SimpleDomainType<Y> attributeType, Member member, MetadataContext metadataContext) {
            super(declaringType, name, attributeClassification, attributeType, attributeType.getExpressibleJavaType(), member, false, true, false, false, metadataContext);
        }
    }

    public static class Identifier<D, J>
    extends SingularAttributeImpl<D, J> {
        public Identifier(ManagedDomainType<D> declaringType, String name, SimpleDomainType<J> attributeType, Member member, AttributeClassification attributeClassification, boolean isGeneric, MetadataContext metadataContext) {
            super(declaringType, name, attributeClassification, attributeType, attributeType.getExpressibleJavaType(), member, true, false, false, isGeneric, metadataContext);
        }

        @Override
        public NavigablePath createNavigablePath(SqmPath<?> parent, String alias) {
            IdentifiableDomainType declaringType;
            if (parent == null) {
                throw new IllegalArgumentException("LHS cannot be null for a sub-navigable reference - " + this.getName());
            }
            NavigablePath navigablePath = parent.getNavigablePath();
            if (parent.getResolvedModel() instanceof PluralPersistentAttribute) {
                navigablePath = navigablePath.append(CollectionPart.Nature.ELEMENT.getName());
            }
            if (this.getDeclaringType() instanceof IdentifiableDomainType && !(declaringType = (IdentifiableDomainType)this.getDeclaringType()).hasSingleIdAttribute()) {
                return new EntityIdentifierNavigablePath(navigablePath, null).append(this.getName(), SqmCreationHelper.determineAlias(alias));
            }
            return new EntityIdentifierNavigablePath(navigablePath, SqmCreationHelper.determineAlias(alias), this.getName());
        }
    }
}

