/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import org.jgroups.Address;
import org.jgroups.Constructable;
import org.jgroups.Header;
import org.jgroups.util.ByteArray;
import org.jgroups.util.SizeStreamable;

public interface Message
extends SizeStreamable,
Constructable<Message> {
    public static final short BYTES_MSG = 0;
    public static final short NIO_MSG = 1;
    public static final short EMPTY_MSG = 2;
    public static final short OBJ_MSG = 3;
    public static final short LONG_MSG = 4;
    public static final short COMPOSITE_MSG = 5;
    public static final short FRAG_MSG = 6;
    public static final short EARLYBATCH_MSG = 7;

    public short getType();

    public Address getDest();

    default public Address dest() {
        return this.getDest();
    }

    public Message setDest(Address var1);

    default public Message dest(Address new_dest) {
        return this.setDest(new_dest);
    }

    public Address getSrc();

    default public Address src() {
        return this.getSrc();
    }

    public Message setSrc(Address var1);

    default public Message src(Address new_src) {
        return this.setSrc(new_src);
    }

    public Message putHeader(short var1, Header var2);

    public <T extends Header> T getHeader(short var1);

    public Map<Short, Header> getHeaders();

    public int getNumHeaders();

    public String printHeaders();

    public Message clearHeaders();

    public Message setFlag(Flag ... var1);

    public Message setFlag(short var1, boolean var2);

    public Message setFlag(TransientFlag ... var1);

    public boolean setFlagIfAbsent(TransientFlag var1);

    public short getFlags(boolean var1);

    default public short getFlags() {
        return this.getFlags(false);
    }

    public Message clearFlag(Flag ... var1);

    public Message clearFlag(TransientFlag ... var1);

    public boolean isFlagSet(Flag var1);

    public boolean isFlagSet(TransientFlag var1);

    public Message copy(boolean var1, boolean var2);

    public boolean hasPayload();

    public boolean hasArray();

    public byte[] getArray();

    public int getOffset();

    public int getLength();

    public Message setArray(byte[] var1, int var2, int var3);

    default public Message setArray(byte[] b) {
        return this.setArray(b, 0, b.length);
    }

    public Message setArray(ByteArray var1);

    public <T> T getObject();

    public Message setObject(Object var1);

    public <T> T getPayload();

    public Message setPayload(Object var1);

    public int size();

    public void writeToNoAddrs(Address var1, DataOutput var2, short ... var3) throws IOException;

    public void writePayload(DataOutput var1) throws IOException;

    public void readPayload(DataInput var1) throws IOException, ClassNotFoundException;

    public static enum TransientFlag {
        OOB_DELIVERED(1),
        DONT_LOOPBACK(2);

        final short value;

        private TransientFlag(short flag) {
            this.value = flag;
        }

        public short value() {
            return this.value;
        }
    }

    public static enum Flag {
        OOB(1),
        DONT_BUNDLE(2),
        NO_FC(4),
        NO_RELIABILITY(16),
        NO_TOTAL_ORDER(32),
        NO_RELAY(64),
        RSVP(128),
        RSVP_NB(256),
        SKIP_BARRIER(1024),
        SERIALIZED(2048);

        final short value;

        private Flag(short value) {
            this.value = value;
        }

        public short value() {
            return this.value;
        }
    }
}

