/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.synthetic.xml;

import com.xebialabs.xlplatform.synthetic.TypeName;
import com.xebialabs.xlplatform.synthetic.xml.Closure;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Predicate;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

interface XmlOperations {
    default public String getRequiredStringAttribute(Element element, String attributeName) {
        if (element.hasAttribute(attributeName)) {
            return element.getAttribute(attributeName);
        }
        throw new IllegalArgumentException("Attribute " + attributeName + " not provided");
    }

    default public TypeName getRequiredTypeAttribute(Element element, String attributeName) {
        TypeName type = this.getOptionalTypeAttribute(element, attributeName);
        if (type == null) {
            throw new IllegalArgumentException("Attribute " + attributeName + " not provided on element " + element.getNodeName());
        }
        return type;
    }

    default public TypeName getOptionalTypeAttribute(Element element, String attributeName, TypeName defaultValue) {
        String typeAttr = this.getOptionalStringAttribute(element, attributeName, null);
        if (typeAttr != null) {
            return new TypeName(typeAttr);
        }
        return defaultValue;
    }

    default public TypeName getOptionalTypeAttribute(Element element, String attributeName) {
        return this.getOptionalTypeAttribute(element, attributeName, null);
    }

    default public Optional<TypeName> getOptionalType(Element element, String attributeName) {
        return this.getOptionalString(element, attributeName).map(TypeName::new);
    }

    default public boolean getOptionalBooleanAttribute(Element element, String attributeName, boolean defaultValue) {
        return this.getOptionalBoolean(element, attributeName).orElse(defaultValue);
    }

    default public Optional<Boolean> getOptionalBoolean(Element element, String attributeName) {
        return this.getOptionalString(element, attributeName).map(Boolean::valueOf);
    }

    default public String getOptionalStringAttribute(Element element, String attributeName, String defaultValue) {
        return this.getOptionalString(element, attributeName).orElse(defaultValue);
    }

    default public Optional<String> getOptionalString(Element element, String attributeName) {
        if (element.hasAttribute(attributeName)) {
            return Optional.of(element.getAttribute(attributeName));
        }
        return Optional.empty();
    }

    default public Optional<String> getOptionalTextOfChild(Element element, String childElementName) {
        Iterator<Element> children = this.childrenByName(element, childElementName::equals).iterator();
        if (children.hasNext()) {
            return Optional.ofNullable(children.next().getFirstChild().getTextContent());
        }
        return Optional.empty();
    }

    default public Iterable<Element> childrenByName(Element element, Predicate<String> matcher) {
        return () -> this.childByName(element, matcher);
    }

    default public Iterator<Element> childByName(final Element element, final Predicate<String> matcher) {
        return new Iterator<Element>(){
            private int i = -1;
            private final NodeList childNodes = element.getChildNodes();
            private int nextIndex = -1;

            @Override
            public boolean hasNext() {
                if (this.nextIndex == this.i) {
                    this.nextIndex = this.findNext();
                }
                return this.nextIndex > this.i;
            }

            @Override
            public Element next() {
                if (this.nextIndex == this.i) {
                    this.nextIndex = this.findNext();
                }
                if (this.nextIndex < this.i) {
                    throw new NoSuchElementException("There are no more matching elements");
                }
                this.i = this.nextIndex;
                return (Element)this.childNodes.item(this.i);
            }

            private int findNext() {
                int next = this.i;
                while (next < this.childNodes.getLength()) {
                    Element e;
                    if (!(this.childNodes.item(++next) instanceof Element) || !matcher.test((e = (Element)this.childNodes.item(next)).getNodeName())) continue;
                    return next;
                }
                return this.i - 1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    default public <E> void forEach(Iterator<E> iterator, Closure<E> closure) {
        while (iterator.hasNext()) {
            closure.call(iterator.next());
        }
    }
}

