/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity.internal;

import org.hibernate.FetchNotFoundException;
import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.entity.AbstractEntityInitializer;
import org.hibernate.sql.results.graph.entity.EntityLoadingLogging;
import org.hibernate.sql.results.graph.entity.EntityResultGraphNode;
import org.hibernate.sql.results.graph.entity.EntityValuedFetchable;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public class EntityJoinedFetchInitializer
extends AbstractEntityInitializer {
    private static final String CONCRETE_NAME = EntityJoinedFetchInitializer.class.getSimpleName();
    private final DomainResultAssembler<?> keyAssembler;
    private final NotFoundAction notFoundAction;

    public EntityJoinedFetchInitializer(EntityResultGraphNode resultDescriptor, EntityValuedFetchable referencedFetchable, NavigablePath navigablePath, LockMode lockMode, NotFoundAction notFoundAction, DomainResult<?> keyResult, DomainResult<Object> rowIdResult, Fetch identifierFetch, Fetch discriminatorFetch, FetchParentAccess parentAccess, AssemblerCreationState creationState) {
        super(resultDescriptor, navigablePath, lockMode, identifierFetch, discriminatorFetch, rowIdResult, parentAccess, creationState);
        assert (this.getInitializedPart() == referencedFetchable);
        this.notFoundAction = notFoundAction;
        this.keyAssembler = keyResult == null ? null : keyResult.createResultAssembler(this, creationState);
    }

    @Override
    public void resolveKey(RowProcessingState rowProcessingState) {
        if (this.isParentShallowCached()) {
            this.state = AbstractEntityInitializer.State.MISSING;
        } else if (this.state == AbstractEntityInitializer.State.UNINITIALIZED) {
            Object fkKeyValue;
            if (this.shouldSkipInitializer(rowProcessingState)) {
                this.state = AbstractEntityInitializer.State.MISSING;
                return;
            }
            super.resolveKey(rowProcessingState);
            if (this.keyAssembler != null && (fkKeyValue = this.keyAssembler.assemble(rowProcessingState)) != null && this.state == AbstractEntityInitializer.State.MISSING) {
                if (this.notFoundAction != NotFoundAction.IGNORE) {
                    throw new FetchNotFoundException(this.getEntityDescriptor().getEntityName(), fkKeyValue);
                }
                EntityLoadingLogging.ENTITY_LOADING_LOGGER.debugf("Ignoring dangling foreign-key due to `@NotFound(IGNORE); association will be null - %s", (Object)this.getNavigablePath());
            }
        }
    }

    @Override
    public void initializeInstanceFromParent(Object parentInstance, RowProcessingState rowProcessingState) {
        AttributeMapping attributeMapping = this.getInitializedPart().asAttributeMapping();
        Object instance = attributeMapping != null ? attributeMapping.getValue(parentInstance) : parentInstance;
        this.setEntityInstance(instance);
        this.setEntityInstanceForNotify(Hibernate.unproxy(instance));
        this.state = AbstractEntityInitializer.State.INITIALIZED;
        this.initializeSubInstancesFromParent(rowProcessingState);
    }

    @Override
    protected String getSimpleConcreteImplName() {
        return CONCRETE_NAME;
    }

    @Override
    public boolean isResultInitializer() {
        return false;
    }

    public String toString() {
        return "EntityJoinedFetchInitializer(" + LoggingHelper.toLoggableString(this.getNavigablePath()) + ")";
    }
}

