/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.connections.internal;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.engine.jdbc.connections.internal.ConnectionCreator;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.exception.JDBCConnectionException;
import org.hibernate.exception.internal.SQLStateConversionDelegate;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.internal.util.ValueHolder;
import org.hibernate.service.spi.ServiceException;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public abstract class BasicConnectionCreator
implements ConnectionCreator {
    private final ServiceRegistryImplementor serviceRegistry;
    private final String url;
    private final Properties connectionProps;
    private final boolean autoCommit;
    private final Integer isolation;
    private final String initSql;
    private final ValueHolder<SQLExceptionConversionDelegate> simpleConverterAccess = new ValueHolder<ValueHolder.DeferredInitializer<SQLExceptionConversionDelegate>>(() -> new SQLExceptionConversionDelegate(){
        private final SQLStateConversionDelegate sqlStateDelegate = new SQLStateConversionDelegate(() -> {
            throw new HibernateException("Unexpected call to ConversionContext.getViolatedConstraintNameExtractor");
        });

        @Override
        public JDBCException convert(SQLException sqlException, String message, String sql) {
            JDBCException exception = this.sqlStateDelegate.convert(sqlException, message, sql);
            if (exception == null) {
                exception = new JDBCConnectionException(message, sqlException, sql);
            }
            return exception;
        }
    });

    public BasicConnectionCreator(ServiceRegistryImplementor serviceRegistry, String url, Properties connectionProps, boolean autocommit, Integer isolation, String initSql) {
        this.serviceRegistry = serviceRegistry;
        this.url = url;
        this.connectionProps = connectionProps;
        this.autoCommit = autocommit;
        this.isolation = isolation;
        this.initSql = initSql;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public Connection createConnection() {
        Connection conn;
        block19: {
            conn = this.makeConnection(this.url, this.connectionProps);
            if (conn == null) {
                throw new HibernateException("Unable to make JDBC Connection [" + this.url + "]");
            }
            try {
                try {
                    if (this.isolation != null) {
                        conn.setTransactionIsolation(this.isolation);
                    }
                }
                catch (SQLException e) {
                    throw this.convertSqlException("Unable to set transaction isolation (" + this.isolation + ")", e);
                }
                try {
                    if (conn.getAutoCommit() != this.autoCommit) {
                        conn.setAutoCommit(this.autoCommit);
                    }
                }
                catch (SQLException e) {
                    throw this.convertSqlException("Unable to set auto-commit (" + this.autoCommit + ")", e);
                }
                if (this.initSql == null || this.initSql.trim().isEmpty()) break block19;
                try (Statement s = conn.createStatement();){
                    s.execute(this.initSql);
                }
                catch (SQLException e) {
                    throw this.convertSqlException("Unable to execute initSql (" + this.initSql + ")", e);
                }
            }
            catch (Error | RuntimeException e) {
                try {
                    conn.close();
                }
                catch (SQLException ex) {
                    e.addSuppressed(ex);
                }
                throw e;
            }
        }
        return conn;
    }

    protected JDBCException convertSqlException(String message, SQLException e) {
        String fullMessage = message + " [" + e.getMessage() + "]";
        try {
            JdbcServices jdbcServices = this.serviceRegistry.getService(JdbcServices.class);
            if (jdbcServices != null && jdbcServices.getSqlExceptionHelper() != null) {
                return jdbcServices.getSqlExceptionHelper().convert(e, fullMessage);
            }
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return this.simpleConverterAccess.getValue().convert(e, fullMessage, null);
    }

    protected abstract Connection makeConnection(String var1, Properties var2);

    public Properties getConnectionProperties() {
        return new Properties(this.connectionProps);
    }
}

