/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper.relation.lazy.initializor;

import java.util.List;
import java.util.Map;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleComponentData;
import org.hibernate.envers.internal.entities.mapper.relation.lazy.initializor.AbstractCollectionInitializor;
import org.hibernate.envers.internal.entities.mapper.relation.query.RelationQueryGenerator;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;

public class MapCollectionInitializor<T extends Map>
extends AbstractCollectionInitializor<T> {
    protected final Class<? extends T> collectionClass;
    private final MiddleComponentData elementComponentData;
    private final MiddleComponentData indexComponentData;

    public MapCollectionInitializor(EnversService enversService, AuditReaderImplementor versionsReader, RelationQueryGenerator queryGenerator, Object primaryKey, Number revision, boolean removed, Class<? extends T> collectionClass, MiddleComponentData elementComponentData, MiddleComponentData indexComponentData) {
        super(enversService, versionsReader, queryGenerator, primaryKey, revision, removed);
        this.collectionClass = collectionClass;
        this.elementComponentData = elementComponentData;
        this.indexComponentData = indexComponentData;
    }

    @Override
    protected T initializeCollection(int size) {
        return (T)((Map)this.newObjectInstance(this.collectionClass, new Object[0]));
    }

    @Override
    protected void addToCollection(T collection, Object collectionRow) {
        Object elementData = collectionRow;
        Object indexData = collectionRow;
        if (collectionRow instanceof List) {
            elementData = ((List)collectionRow).get(this.elementComponentData.getComponentIndex());
            indexData = ((List)collectionRow).get(this.indexComponentData.getComponentIndex());
        }
        Object element = this.elementComponentData.getComponentMapper().mapToObjectFromFullMap(this.entityInstantiator, (Map)elementData, null, this.revision);
        Object index = this.indexComponentData.getComponentMapper().mapToObjectFromFullMap(this.entityInstantiator, (Map)indexData, element, this.revision);
        collection.put((Object)index, (Object)element);
    }
}

