/*
 * Decompiled with CFR 0.152.
 */
package jnr.netdb;

import java.util.Collection;
import jnr.netdb.FileProtocolsDB;
import jnr.netdb.IANAProtocolsDB;
import jnr.netdb.NativeProtocolsDB;
import jnr.netdb.ProtocolsDB;

public final class Protocol {
    private final String protocolName;
    private final int proto;
    private final Collection<String> aliases;

    Protocol(String name, int proto, Collection<String> aliases2) {
        this.protocolName = name;
        this.proto = proto;
        this.aliases = aliases2;
    }

    public static final Protocol getProtocolByName(String name) {
        return Protocol.getProtocolDB().getProtocolByName(name);
    }

    public static final Protocol getProtocolByNumber(int proto) {
        return Protocol.getProtocolDB().getProtocolByNumber(proto);
    }

    public final String getName() {
        return this.protocolName;
    }

    public final int getProto() {
        return this.proto;
    }

    public final Collection<String> getAliases() {
        return this.aliases;
    }

    private static final ProtocolsDB getProtocolDB() {
        return ProtocolDBSingletonHolder.INSTANCE;
    }

    public String toString() {
        return String.format("<Protocol: Name: %s, Proto: %d, Aliases: %s>", this.protocolName, this.proto, this.aliases);
    }

    private static final class ProtocolDBSingletonHolder {
        static final ProtocolsDB INSTANCE = ProtocolDBSingletonHolder.load();

        private ProtocolDBSingletonHolder() {
        }

        private static final ProtocolsDB load() {
            ProtocolsDB db = NativeProtocolsDB.getInstance();
            if (db == null) {
                db = FileProtocolsDB.getInstance();
            }
            return db != null ? db : IANAProtocolsDB.getInstance();
        }
    }
}

