/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper.relation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.configuration.Configuration;
import org.hibernate.envers.internal.entities.mapper.PersistentCollectionChangeData;
import org.hibernate.envers.internal.entities.mapper.PropertyMapper;
import org.hibernate.envers.internal.entities.mapper.relation.AbstractCollectionMapper;
import org.hibernate.envers.internal.entities.mapper.relation.CommonCollectionMapperData;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleComponentData;
import org.hibernate.envers.internal.entities.mapper.relation.lazy.initializor.BasicCollectionInitializor;
import org.hibernate.envers.internal.entities.mapper.relation.lazy.initializor.Initializor;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

public class BasicCollectionMapper<T extends Collection>
extends AbstractCollectionMapper<T>
implements PropertyMapper {
    protected final MiddleComponentData elementComponentData;

    public BasicCollectionMapper(Configuration configuration, CommonCollectionMapperData commonCollectionMapperData, Class<? extends T> collectionClass, Class<? extends T> proxyClass, MiddleComponentData elementComponentData, boolean ordinalInId, boolean revisionTypeInId) {
        super(configuration, commonCollectionMapperData, collectionClass, proxyClass, ordinalInId, revisionTypeInId);
        this.elementComponentData = elementComponentData;
    }

    @Override
    protected Initializor<T> getInitializor(EnversService enversService, AuditReaderImplementor versionsReader, Object primaryKey, Number revision, boolean removed) {
        return new BasicCollectionInitializor(enversService, versionsReader, this.commonCollectionMapperData.getQueryGenerator(), primaryKey, revision, removed, this.collectionClass, this.elementComponentData);
    }

    @Override
    protected Collection getNewCollectionContent(PersistentCollection newCollection) {
        return (Collection)newCollection;
    }

    @Override
    protected Collection getOldCollectionContent(Serializable oldCollection) {
        if (oldCollection == null) {
            return null;
        }
        if (oldCollection instanceof Map) {
            return ((Map)((Object)oldCollection)).keySet();
        }
        return (Collection)((Object)oldCollection);
    }

    @Override
    protected void mapToMapFromObject(SessionImplementor session, Map<String, Object> idData, Map<String, Object> data, Object changed) {
        this.elementComponentData.getComponentMapper().mapToMapFromObject(session, idData, data, changed);
    }

    @Override
    protected Set<Object> buildCollectionChangeSet(Object eventCollection, Collection collection) {
        HashSet<Object> changeSet = new HashSet<Object>();
        if (eventCollection != null) {
            for (Object entry : collection) {
                if (entry == null) continue;
                changeSet.add(entry);
            }
        }
        return changeSet;
    }

    @Override
    protected List<PersistentCollectionChangeData> mapCollectionChanges(SessionImplementor session, PersistentCollection newColl, Serializable oldColl, Object id) {
        ArrayList<PersistentCollectionChangeData> collectionChanges = new ArrayList<PersistentCollectionChangeData>();
        CollectionPersister collectionPersister = this.resolveCollectionPersister(session, newColl);
        Collection newCollection = this.getNewCollectionContent(newColl);
        Collection oldCollection = this.getOldCollectionContent(oldColl);
        Set<Object> addedElements = this.buildCollectionChangeSet(newColl, newCollection);
        if (oldColl != null) {
            block0: for (Object oldEntry : oldCollection) {
                Iterator<Object> itor = addedElements.iterator();
                while (itor.hasNext()) {
                    Object newEntry = itor.next();
                    if (!this.isCollectionElementSame(session, collectionPersister, oldEntry, newEntry)) continue;
                    itor.remove();
                    continue block0;
                }
            }
        }
        Set<Object> deleteElements = this.buildCollectionChangeSet(oldColl, oldCollection);
        if (newColl != null) {
            block2: for (Object newEntry : newCollection) {
                Iterator<Object> itor = deleteElements.iterator();
                while (itor.hasNext()) {
                    Object deletedEntry = itor.next();
                    if (!this.isCollectionElementSame(session, collectionPersister, deletedEntry, newEntry)) continue;
                    itor.remove();
                    continue block2;
                }
            }
        }
        this.addCollectionChanges(session, collectionChanges, addedElements, RevisionType.ADD, id);
        this.addCollectionChanges(session, collectionChanges, deleteElements, RevisionType.DEL, id);
        return collectionChanges;
    }

    private boolean isCollectionElementSame(SessionImplementor session, CollectionPersister collectionPersister, Object lhs, Object rhs) {
        Type elementType = collectionPersister.getElementType();
        if (elementType.isEntityType() && !this.revisionTypeInId) {
            if (elementType.isSame(lhs, rhs)) {
                return true;
            }
            EntityPersister entityPersister = session.getFactory().getMappingMetamodel().getEntityDescriptor(((EntityType)elementType).getAssociatedEntityName());
            Object lhsId = entityPersister.getIdentifier(lhs, (SharedSessionContractImplementor)session);
            Object rhsId = entityPersister.getIdentifier(rhs, (SharedSessionContractImplementor)session);
            return entityPersister.getIdentifierType().isSame(lhsId, rhsId);
        }
        return elementType.isSame(lhs, rhs);
    }
}

