/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.stream.Stream;
import org.infinispan.AdvancedCache;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.functional.AbstractWriteManyCommand;
import org.infinispan.commands.functional.ReadOnlyKeyCommand;
import org.infinispan.commands.functional.ReadOnlyManyCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.functional.ReadWriteManyCommand;
import org.infinispan.commands.functional.ReadWriteManyEntriesCommand;
import org.infinispan.commands.functional.WriteOnlyKeyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyValueCommand;
import org.infinispan.commands.read.AbstractDataCommand;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.write.ComputeCommand;
import org.infinispan.commands.write.ComputeIfAbsentCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.IracPutKeyValueCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.stat.MetricInfo;
import org.infinispan.commons.stat.TimerTracker;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.ByRef;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.commons.util.concurrent.StripedCounters;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalMetricsConfiguration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.container.offheap.OffHeapMemoryAllocator;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.functional.impl.StatsEnvelope;
import org.infinispan.interceptors.impl.JmxStatsCommandInterceptor;
import org.infinispan.interceptors.impl.TransactionalExceptionEvictionInterceptor;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.MeasurementType;
import org.infinispan.jmx.annotations.Units;
import org.infinispan.metrics.impl.CustomMetricsSupplier;
import org.infinispan.metrics.impl.MetricUtils;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.util.concurrent.CompletionStages;

@MBean(objectName="Statistics", description="General statistics such as timings, hit/miss ratio, and so on.")
public final class CacheMgmtInterceptor
extends JmxStatsCommandInterceptor
implements CustomMetricsSupplier {
    @Inject
    ComponentRef<AdvancedCache<?, ?>> cache;
    @Inject
    InternalDataContainer<?, ?> dataContainer;
    @Inject
    TimeService timeService;
    @Inject
    OffHeapMemoryAllocator allocator;
    @Inject
    ComponentRegistry componentRegistry;
    @Inject
    GlobalConfiguration globalConfiguration;
    @Inject
    ComponentRef<PersistenceManager> persistenceManager;
    @Inject
    DistributionManager distributionManager;
    private final AtomicLong startNanoseconds = new AtomicLong(0L);
    private final AtomicLong resetNanoseconds = new AtomicLong(0L);
    private final StripedCounters<StripeB> counters = new StripedCounters(() -> new StripeC());
    private TimerTracker hitTimes = TimerTracker.NO_OP;
    private TimerTracker missTimes = TimerTracker.NO_OP;
    private TimerTracker storeTimes = TimerTracker.NO_OP;
    private TimerTracker removeTimes = TimerTracker.NO_OP;

    @Start
    public void start() {
        this.startNanoseconds.set(this.timeService.time());
        this.resetNanoseconds.set(this.startNanoseconds.get());
    }

    @Override
    public Collection<MetricInfo> getCustomMetrics(GlobalMetricsConfiguration configuration) {
        ArrayList<MetricInfo> metrics = new ArrayList<MetricInfo>(4);
        if (configuration.histograms()) {
            metrics.add((MetricInfo)MetricUtils.createTimer("HitTimes", "Hit Times", (o, timerTracker) -> {
                o.hitTimes = timerTracker;
            }, null));
            metrics.add((MetricInfo)MetricUtils.createTimer("MissTimes", "Miss Times", (o, timerTracker) -> {
                o.missTimes = timerTracker;
            }, null));
            metrics.add((MetricInfo)MetricUtils.createTimer("StoreTimes", "Store Times", (o, timerTracker) -> {
                o.storeTimes = timerTracker;
            }, null));
            metrics.add((MetricInfo)MetricUtils.createTimer("RemoveTimes", "Remove Times", (o, timerTracker) -> {
                o.removeTimes = timerTracker;
            }, null));
        } else {
            metrics.add((MetricInfo)MetricUtils.createFunctionTimer("HitTimes", "Hit Times", (o, timerTracker) -> {
                o.hitTimes = timerTracker;
            }, TimeUnit.NANOSECONDS, null));
            metrics.add((MetricInfo)MetricUtils.createFunctionTimer("MissTimes", "Miss Times", (o, timerTracker) -> {
                o.missTimes = timerTracker;
            }, TimeUnit.NANOSECONDS, null));
            metrics.add((MetricInfo)MetricUtils.createFunctionTimer("StoreTimes", "Store Times", (o, timerTracker) -> {
                o.storeTimes = timerTracker;
            }, TimeUnit.NANOSECONDS, null));
            metrics.add((MetricInfo)MetricUtils.createFunctionTimer("RemoveTimes", "Remove Times", (o, timerTracker) -> {
                o.removeTimes = timerTracker;
            }, TimeUnit.NANOSECONDS, null));
        }
        return metrics;
    }

    @Override
    public Object visitEvictCommand(InvocationContext ctx, EvictCommand command) throws Throwable {
        return super.visitEvictCommand(ctx, command);
    }

    @Override
    public final Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) {
        return this.visitDataReadCommand(ctx, command);
    }

    @Override
    public final Object visitGetCacheEntryCommand(InvocationContext ctx, GetCacheEntryCommand command) {
        return this.visitDataReadCommand(ctx, command);
    }

    public void addDataRead(boolean foundValue, long timeNanoSeconds) {
        StripeB stripe = (StripeB)this.counters.stripeForCurrentThread();
        if (foundValue) {
            this.counters.add(StripeB.hitTimesFieldUpdater, (Object)stripe, timeNanoSeconds);
            this.counters.increment(StripeB.hitsFieldUpdater, (Object)stripe);
            this.hitTimes.update(Duration.ofNanos(timeNanoSeconds));
        } else {
            this.counters.add(StripeB.missTimesFieldUpdater, (Object)stripe, timeNanoSeconds);
            this.counters.increment(StripeB.missesFieldUpdater, (Object)stripe);
            this.missTimes.update(Duration.ofNanos(timeNanoSeconds));
        }
    }

    private Object visitDataReadCommand(InvocationContext ctx, AbstractDataCommand command) {
        boolean statisticsEnabled = this.collectStatisticsForCommand(command);
        if (!statisticsEnabled || !ctx.isOriginLocal()) {
            return this.invokeNext(ctx, command);
        }
        long start = this.timeService.time();
        return this.invokeNextAndFinally(ctx, command, (rCtx, rCommand, rv, t) -> this.addDataRead(rv != null, this.timeService.timeDuration(start, TimeUnit.NANOSECONDS)));
    }

    @Override
    public Object visitGetAllCommand(InvocationContext ctx, GetAllCommand command) {
        boolean statisticsEnabled = this.collectStatisticsForCommand(command);
        if (!statisticsEnabled || !ctx.isOriginLocal()) {
            return this.invokeNext(ctx, command);
        }
        long start = this.timeService.time();
        return this.invokeNextAndFinally(ctx, command, (rCtx, rCommand, rv, t) -> {
            long intervalNanos = this.timeService.timeDuration(start, TimeUnit.NANOSECONDS);
            int requests = rCommand.getKeys().size();
            int hitCount = 0;
            if (t == null) {
                for (Map.Entry entry : ((Map)rv).entrySet()) {
                    if (entry.getValue() == null) continue;
                    ++hitCount;
                }
            }
            int missCount = requests - hitCount;
            StripeB stripe = (StripeB)this.counters.stripeForCurrentThread();
            if (hitCount > 0) {
                long hitTimesNanos = intervalNanos * (long)hitCount / (long)requests;
                this.counters.add(StripeB.hitsFieldUpdater, (Object)stripe, (long)hitCount);
                this.counters.add(StripeB.hitTimesFieldUpdater, (Object)stripe, hitTimesNanos);
                this.hitTimes.update(Duration.ofNanos(hitTimesNanos));
            }
            if (missCount > 0) {
                long missTimesNanos = intervalNanos * (long)missCount / (long)requests;
                this.counters.add(StripeB.missesFieldUpdater, (Object)stripe, (long)missCount);
                this.counters.add(StripeB.missTimesFieldUpdater, (Object)stripe, missTimesNanos);
                this.missTimes.update(Duration.ofNanos(missTimesNanos));
            }
        });
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) {
        boolean statisticsEnabled = this.collectStatisticsForCommand(command);
        if (!statisticsEnabled || !ctx.isOriginLocal()) {
            return this.invokeNext(ctx, command);
        }
        long start = this.timeService.time();
        return this.invokeNextAndFinally(ctx, command, (rCtx, rCommand, rv, t) -> {
            long intervalNanos = this.timeService.timeDuration(start, TimeUnit.NANOSECONDS);
            Map<Object, Object> data = rCommand.getMap();
            if (data != null && !data.isEmpty()) {
                StripeB stripe = (StripeB)this.counters.stripeForCurrentThread();
                this.counters.add(StripeB.storeTimesFieldUpdater, (Object)stripe, intervalNanos);
                this.counters.add(StripeB.storesFieldUpdater, (Object)stripe, (long)data.size());
                this.storeTimes.update(Duration.ofNanos(intervalNanos));
            }
        });
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) {
        return this.updateStoreStatistics(ctx, command);
    }

    @Override
    public Object visitIracPutKeyValueCommand(InvocationContext ctx, IracPutKeyValueCommand command) throws Throwable {
        return this.updateStoreStatistics(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) {
        return this.updateStoreStatistics(ctx, command);
    }

    @Override
    public Object visitComputeCommand(InvocationContext ctx, ComputeCommand command) {
        boolean statisticsEnabled = this.collectStatisticsForCommand(command);
        if (!statisticsEnabled || !ctx.isOriginLocal()) {
            return this.invokeNext(ctx, command);
        }
        long start = this.timeService.time();
        return this.invokeNextAndFinally(ctx, command, (rCtx, rCommand, rv, t) -> {
            if (rv == null && rCommand.isSuccessful()) {
                this.increaseRemoveMisses();
            } else if (rCommand.isSuccessful()) {
                long intervalNanos = this.timeService.timeDuration(start, TimeUnit.NANOSECONDS);
                StripeB stripe = (StripeB)this.counters.stripeForCurrentThread();
                this.counters.add(StripeB.storeTimesFieldUpdater, (Object)stripe, intervalNanos);
                this.counters.increment(StripeB.storesFieldUpdater, (Object)stripe);
                this.storeTimes.update(Duration.ofNanos(intervalNanos));
            }
        });
    }

    @Override
    public Object visitComputeIfAbsentCommand(InvocationContext ctx, ComputeIfAbsentCommand command) {
        return this.updateStoreStatistics(ctx, command);
    }

    private Object updateStoreStatistics(InvocationContext ctx, WriteCommand command) {
        boolean statisticsEnabled = this.collectStatisticsForCommand(command);
        if (!statisticsEnabled || !ctx.isOriginLocal()) {
            return this.invokeNext(ctx, command);
        }
        long start = this.timeService.time();
        return this.invokeNextAndFinally(ctx, command, (rCtx, rCommand, rv, t) -> {
            if (rCommand.isSuccessful()) {
                long intervalNanos = this.timeService.timeDuration(start, TimeUnit.NANOSECONDS);
                StripeB stripe = (StripeB)this.counters.stripeForCurrentThread();
                this.counters.add(StripeB.storeTimesFieldUpdater, (Object)stripe, intervalNanos);
                this.counters.increment(StripeB.storesFieldUpdater, (Object)stripe);
                this.storeTimes.update(Duration.ofNanos(intervalNanos));
            }
        });
    }

    @Override
    public Object visitReadOnlyKeyCommand(InvocationContext ctx, ReadOnlyKeyCommand command) {
        if (!ctx.isOriginLocal() || command.hasAnyFlag(FlagBitSets.SKIP_STATISTICS)) {
            return this.invokeNext(ctx, command);
        }
        if (!this.getStatisticsEnabled()) {
            return this.invokeNextThenApply(ctx, command, StatsEnvelope::unpack);
        }
        long start = this.timeService.time();
        return this.invokeNextThenApply(ctx, command, (rCtx, rCommand, rv) -> {
            long intervalNanos = this.timeService.timeDuration(start, TimeUnit.NANOSECONDS);
            StripeB stripe = (StripeB)this.counters.stripeForCurrentThread();
            StatsEnvelope envelope = (StatsEnvelope)rv;
            if (envelope.isMiss()) {
                this.counters.add(StripeB.missTimesFieldUpdater, (Object)stripe, intervalNanos);
                this.counters.increment(StripeB.missesFieldUpdater, (Object)stripe);
                this.missTimes.update(Duration.ofNanos(intervalNanos));
            } else if (envelope.isHit()) {
                this.counters.add(StripeB.hitTimesFieldUpdater, (Object)stripe, intervalNanos);
                this.counters.increment(StripeB.hitsFieldUpdater, (Object)stripe);
                this.hitTimes.update(Duration.ofNanos(intervalNanos));
            }
            return envelope.value();
        });
    }

    @Override
    public Object visitReadOnlyManyCommand(InvocationContext ctx, ReadOnlyManyCommand command) {
        if (!ctx.isOriginLocal() || command.hasAnyFlag(FlagBitSets.SKIP_STATISTICS)) {
            return this.invokeNext(ctx, command);
        }
        if (!this.getStatisticsEnabled()) {
            return this.invokeNextThenApply(ctx, command, StatsEnvelope::unpackStream);
        }
        long start = this.timeService.time();
        return this.invokeNextThenApply(ctx, command, (rCtx, rCommand, rv) -> {
            long intervalNanos = this.timeService.timeDuration(start, TimeUnit.NANOSECONDS);
            StripeB stripe = (StripeB)this.counters.stripeForCurrentThread();
            ByRef.Integer hitCount = new ByRef.Integer(0);
            ByRef.Integer missCount = new ByRef.Integer(0);
            int numResults = rCommand.getKeys().size();
            ArrayList retvals = new ArrayList(numResults);
            ((Stream)rv).forEach(e -> {
                if (e.isHit()) {
                    hitCount.inc();
                }
                if (e.isMiss()) {
                    missCount.inc();
                }
                retvals.add(e.value());
            });
            if (missCount.get() > 0) {
                long missTimesNanos = (long)missCount.get() * intervalNanos / (long)numResults;
                this.counters.add(StripeB.missTimesFieldUpdater, (Object)stripe, missTimesNanos);
                this.counters.add(StripeB.missesFieldUpdater, (Object)stripe, (long)missCount.get());
                this.missTimes.update(Duration.ofNanos(missTimesNanos));
            }
            if (hitCount.get() > 0) {
                long hitTimesNanos = (long)hitCount.get() * intervalNanos / (long)numResults;
                this.counters.add(StripeB.hitTimesFieldUpdater, (Object)stripe, hitTimesNanos);
                this.counters.add(StripeB.hitsFieldUpdater, (Object)stripe, (long)hitCount.get());
                this.hitTimes.update(Duration.ofNanos(hitTimesNanos));
            }
            return retvals.stream();
        });
    }

    @Override
    public Object visitWriteOnlyKeyCommand(InvocationContext ctx, WriteOnlyKeyCommand command) {
        return this.updateStatisticsWriteOnly(ctx, command);
    }

    private Object updateStatisticsWriteOnly(InvocationContext ctx, AbstractDataCommand command) {
        if (!ctx.isOriginLocal() || command.hasAnyFlag(FlagBitSets.SKIP_STATISTICS)) {
            return this.invokeNext(ctx, command);
        }
        if (!this.getStatisticsEnabled()) {
            return this.invokeNextThenApply(ctx, command, StatsEnvelope::unpack);
        }
        long start = this.timeService.time();
        return this.invokeNextThenApply(ctx, command, (rCtx, rCommand, rv) -> {
            long intervalNanos = this.timeService.timeDuration(start, TimeUnit.NANOSECONDS);
            StripeB stripe = (StripeB)this.counters.stripeForCurrentThread();
            StatsEnvelope envelope = (StatsEnvelope)rv;
            if (envelope.isDelete()) {
                this.counters.add(StripeB.removeTimesFieldUpdater, (Object)stripe, intervalNanos);
                this.counters.increment(StripeB.removeHitsFieldUpdater, (Object)stripe);
                this.removeTimes.update(Duration.ofNanos(intervalNanos));
            } else if ((envelope.flags() & 0xC) != 0) {
                this.counters.add(StripeB.storeTimesFieldUpdater, (Object)stripe, intervalNanos);
                this.counters.increment(StripeB.storesFieldUpdater, (Object)stripe);
                this.storeTimes.update(Duration.ofNanos(intervalNanos));
            }
            assert (envelope.value() == null);
            return null;
        });
    }

    @Override
    public Object visitReadWriteKeyValueCommand(InvocationContext ctx, ReadWriteKeyValueCommand command) {
        return this.updateStatisticsReadWrite(ctx, command);
    }

    private Object updateStatisticsReadWrite(InvocationContext ctx, AbstractDataCommand command) {
        if (!ctx.isOriginLocal() || command.hasAnyFlag(FlagBitSets.SKIP_STATISTICS)) {
            return this.invokeNext(ctx, command);
        }
        if (!this.getStatisticsEnabled()) {
            return this.invokeNextThenApply(ctx, command, StatsEnvelope::unpack);
        }
        long start = this.timeService.time();
        return this.invokeNextThenApply(ctx, command, (rCtx, rCommand, rv) -> {
            if (rv == null && !rCommand.isSuccessful() && rCommand.hasAnyFlag(FlagBitSets.FAIL_SILENTLY)) {
                return null;
            }
            long intervalNanos = this.timeService.timeDuration(start, TimeUnit.NANOSECONDS);
            StripeB stripe = (StripeB)this.counters.stripeForCurrentThread();
            StatsEnvelope envelope = (StatsEnvelope)rv;
            if (envelope.isDelete()) {
                this.counters.add(StripeB.removeTimesFieldUpdater, (Object)stripe, intervalNanos);
                this.counters.increment(StripeB.removeHitsFieldUpdater, (Object)stripe);
                this.removeTimes.update(Duration.ofNanos(intervalNanos));
            } else if ((envelope.flags() & 0xC) != 0) {
                this.counters.add(StripeB.storeTimesFieldUpdater, (Object)stripe, intervalNanos);
                this.counters.increment(StripeB.storesFieldUpdater, (Object)stripe);
                this.storeTimes.update(Duration.ofNanos(intervalNanos));
            }
            if (envelope.isHit()) {
                this.counters.add(StripeB.hitTimesFieldUpdater, (Object)stripe, intervalNanos);
                this.counters.increment(StripeB.hitsFieldUpdater, (Object)stripe);
                this.hitTimes.update(Duration.ofNanos(intervalNanos));
            } else if (envelope.isMiss()) {
                this.counters.add(StripeB.missTimesFieldUpdater, (Object)stripe, intervalNanos);
                this.counters.increment(StripeB.missesFieldUpdater, (Object)stripe);
                this.missTimes.update(Duration.ofNanos(intervalNanos));
            }
            return envelope.value();
        });
    }

    @Override
    public Object visitReadWriteKeyCommand(InvocationContext ctx, ReadWriteKeyCommand command) {
        return this.updateStatisticsReadWrite(ctx, command);
    }

    @Override
    public Object visitWriteOnlyKeyValueCommand(InvocationContext ctx, WriteOnlyKeyValueCommand command) {
        return this.updateStatisticsWriteOnly(ctx, command);
    }

    @Override
    public Object visitReadWriteManyCommand(InvocationContext ctx, ReadWriteManyCommand command) {
        return this.updateStatisticsReadWrite(ctx, command);
    }

    private Object updateStatisticsReadWrite(InvocationContext ctx, AbstractWriteManyCommand command) {
        if (!ctx.isOriginLocal() || command.hasAnyFlag(FlagBitSets.SKIP_STATISTICS)) {
            return this.invokeNext(ctx, command);
        }
        if (!this.getStatisticsEnabled()) {
            return this.invokeNextThenApply(ctx, command, StatsEnvelope::unpackCollection);
        }
        long start = this.timeService.time();
        return this.invokeNextThenApply(ctx, command, (rCtx, rCommand, rv) -> {
            long intervalNanos = this.timeService.timeDuration(start, TimeUnit.NANOSECONDS);
            StripeB stripe = (StripeB)this.counters.stripeForCurrentThread();
            int hits = 0;
            int misses = 0;
            int stores = 0;
            int removals = 0;
            int numResults = rCommand.getAffectedKeys().size();
            ArrayList results = new ArrayList(numResults);
            for (StatsEnvelope envelope : (Collection)rv) {
                if (envelope.isDelete()) {
                    ++removals;
                } else if ((envelope.flags() & 0xC) != 0) {
                    ++stores;
                }
                if (envelope.isHit()) {
                    ++hits;
                } else if (envelope.isMiss()) {
                    ++misses;
                }
                results.add(envelope.value());
            }
            if (removals > 0) {
                long removalsTimeNanos = (long)removals * intervalNanos / (long)numResults;
                this.counters.add(StripeB.removeTimesFieldUpdater, (Object)stripe, removalsTimeNanos);
                this.counters.add(StripeB.removeHitsFieldUpdater, (Object)stripe, (long)removals);
                this.removeTimes.update(Duration.ofNanos(removalsTimeNanos));
            }
            if (stores > 0) {
                long storesTimeNanos = (long)stores * intervalNanos / (long)numResults;
                this.counters.add(StripeB.storeTimesFieldUpdater, (Object)stripe, storesTimeNanos);
                this.counters.add(StripeB.storesFieldUpdater, (Object)stripe, (long)stores);
                this.storeTimes.update(Duration.ofNanos(storesTimeNanos));
            }
            if (misses > 0) {
                long missTimesNanos = (long)misses * intervalNanos / (long)numResults;
                this.counters.add(StripeB.missTimesFieldUpdater, (Object)stripe, missTimesNanos);
                this.counters.add(StripeB.missesFieldUpdater, (Object)stripe, (long)misses);
                this.missTimes.update(Duration.ofNanos(missTimesNanos));
            }
            if (hits > 0) {
                long hitTimesNanos = (long)hits * intervalNanos / (long)numResults;
                this.counters.add(StripeB.hitTimesFieldUpdater, (Object)stripe, hitTimesNanos);
                this.counters.add(StripeB.hitsFieldUpdater, (Object)stripe, (long)hits);
                this.hitTimes.update(Duration.ofNanos(hitTimesNanos));
            }
            return results;
        });
    }

    @Override
    public Object visitReadWriteManyEntriesCommand(InvocationContext ctx, ReadWriteManyEntriesCommand command) {
        return this.updateStatisticsReadWrite(ctx, command);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) {
        boolean statisticsEnabled = this.collectStatisticsForCommand(command);
        if (!statisticsEnabled || !ctx.isOriginLocal()) {
            return this.invokeNext(ctx, command);
        }
        long start = this.timeService.time();
        return this.invokeNextAndFinally(ctx, command, (rCtx, removeCommand, rv, t) -> {
            if (removeCommand.isConditional()) {
                if (removeCommand.isSuccessful()) {
                    this.increaseRemoveHits(start);
                } else {
                    this.increaseRemoveMisses();
                }
            } else if (rv == null) {
                this.increaseRemoveMisses();
            } else {
                this.increaseRemoveHits(start);
            }
        });
    }

    private void increaseRemoveHits(long start) {
        long intervalNanos = this.timeService.timeDuration(start, TimeUnit.NANOSECONDS);
        StripeB stripe = (StripeB)this.counters.stripeForCurrentThread();
        this.counters.add(StripeB.removeTimesFieldUpdater, (Object)stripe, intervalNanos);
        this.counters.increment(StripeB.removeHitsFieldUpdater, (Object)stripe);
        this.removeTimes.update(Duration.ofNanos(intervalNanos));
    }

    private void increaseRemoveMisses() {
        this.counters.increment(StripeB.removeMissesFieldUpdater, (Object)((StripeB)this.counters.stripeForCurrentThread()));
    }

    @ManagedAttribute(description="Number of cache attribute hits", displayName="Number of cache hits", measurementType=MeasurementType.TRENDSUP)
    public long getHits() {
        return this.counters.get(StripeB.hitsFieldUpdater);
    }

    @ManagedAttribute(description="Number of cache attribute misses", displayName="Number of cache misses", measurementType=MeasurementType.TRENDSUP)
    public long getMisses() {
        return this.counters.get(StripeB.missesFieldUpdater);
    }

    @ManagedAttribute(description="Number of cache removal hits", displayName="Number of cache removal hits", measurementType=MeasurementType.TRENDSUP)
    public long getRemoveHits() {
        return this.counters.get(StripeB.removeHitsFieldUpdater);
    }

    @ManagedAttribute(description="Number of cache removals where keys were not found", displayName="Number of cache removal misses", measurementType=MeasurementType.TRENDSUP)
    public long getRemoveMisses() {
        return this.counters.get(StripeB.removeMissesFieldUpdater);
    }

    @ManagedAttribute(description="Number of cache attribute put operations", displayName="Number of cache puts", measurementType=MeasurementType.TRENDSUP)
    public long getStores() {
        return this.counters.get(StripeB.storesFieldUpdater);
    }

    @ManagedAttribute(description="Number of cache eviction operations", displayName="Number of cache evictions", measurementType=MeasurementType.TRENDSUP)
    public long getEvictions() {
        return this.counters.get(StripeB.evictionsFieldUpdater);
    }

    @ManagedAttribute(description="Percentage hit/(hit+miss) ratio for the cache", displayName="Hit ratio", units=Units.PERCENTAGE)
    public double getHitRatio() {
        long hitsL = this.counters.get(StripeB.hitsFieldUpdater);
        double total = hitsL + this.counters.get(StripeB.missesFieldUpdater);
        if (total <= 0.0) {
            return 0.0;
        }
        return (double)hitsL / total;
    }

    @ManagedAttribute(description="Read/writes ratio for the cache", displayName="Read/write ratio", units=Units.PERCENTAGE)
    public double getReadWriteRatio() {
        long sum = this.counters.get(StripeB.storesFieldUpdater);
        if (sum == 0L) {
            return 0.0;
        }
        return (double)(this.counters.get(StripeB.hitsFieldUpdater) + this.counters.get(StripeB.missesFieldUpdater)) / (double)sum;
    }

    @ManagedAttribute(description="Average number of milliseconds for a read operation on the cache", displayName="Average read time", units=Units.MILLISECONDS)
    public long getAverageReadTime() {
        long total = this.counters.get(StripeB.hitsFieldUpdater) + this.counters.get(StripeB.missesFieldUpdater);
        if (total == 0L) {
            return 0L;
        }
        total = (this.counters.get(StripeB.hitTimesFieldUpdater) + this.counters.get(StripeB.missTimesFieldUpdater)) / total;
        return TimeUnit.NANOSECONDS.toMillis(total);
    }

    @ManagedAttribute(description="Average number of nanoseconds for a read operation on the cache", displayName="Average read time", units=Units.NANOSECONDS)
    public long getAverageReadTimeNanos() {
        long total = this.counters.get(StripeB.hitsFieldUpdater) + this.counters.get(StripeB.missesFieldUpdater);
        if (total == 0L) {
            return 0L;
        }
        return (this.counters.get(StripeB.hitTimesFieldUpdater) + this.counters.get(StripeB.missTimesFieldUpdater)) / total;
    }

    @ManagedAttribute(description="Average number of milliseconds for a write operation in the cache", displayName="Average write time", units=Units.MILLISECONDS)
    public long getAverageWriteTime() {
        long sum = this.counters.get(StripeB.storesFieldUpdater);
        if (sum == 0L) {
            return 0L;
        }
        return TimeUnit.NANOSECONDS.toMillis(this.counters.get(StripeB.storeTimesFieldUpdater) / sum);
    }

    @ManagedAttribute(description="Average number of nanoseconds for a write operation in the cache", displayName="Average write time", units=Units.NANOSECONDS)
    public long getAverageWriteTimeNanos() {
        long sum = this.counters.get(StripeB.storesFieldUpdater);
        if (sum == 0L) {
            return 0L;
        }
        return this.counters.get(StripeB.storeTimesFieldUpdater) / sum;
    }

    @ManagedAttribute(description="Average number of milliseconds for a remove operation in the cache", displayName="Average remove time", units=Units.MILLISECONDS)
    public long getAverageRemoveTime() {
        long removes = this.getRemoveHits();
        if (removes == 0L) {
            return 0L;
        }
        return TimeUnit.NANOSECONDS.toMillis(this.counters.get(StripeB.removeTimesFieldUpdater) / removes);
    }

    @ManagedAttribute(description="Average number of nanoseconds for a remove operation in the cache", displayName="Average remove time", units=Units.NANOSECONDS)
    public long getAverageRemoveTimeNanos() {
        long removes = this.getRemoveHits();
        if (removes == 0L) {
            return 0L;
        }
        return this.counters.get(StripeB.removeTimesFieldUpdater) / removes;
    }

    @ManagedAttribute(description="Approximate number of entries currently in the cache, including persisted and expired entries", displayName="Approximate number of entries")
    public long getApproximateEntries() {
        IntSet allSegments = IntSets.immutableRangeSet((int)this.cacheConfiguration.clustering().hash().numSegments());
        IntSet writeSegments = this.distributionManager != null ? this.distributionManager.getCacheTopology().getLocalWriteSegments() : allSegments;
        long persistenceSize = CompletionStages.join(this.approximatePersistenceSize(allSegments, writeSegments));
        return this.approximateTotalSize(persistenceSize, allSegments);
    }

    private CompletionStage<Long> approximatePersistenceSize(IntSet privateSegments, IntSet sharedSegments) {
        return this.persistenceManager.running().approximateSize(PersistenceManager.AccessMode.PRIVATE, privateSegments).thenCompose(privateSize -> {
            if (privateSize >= 0L) {
                return CompletableFuture.completedFuture(privateSize);
            }
            return this.persistenceManager.running().approximateSize(PersistenceManager.AccessMode.SHARED, sharedSegments);
        });
    }

    private long approximateTotalSize(long persistenceSize, IntSet segments) {
        if (this.cacheConfiguration.persistence().passivation()) {
            long inMemorySize = this.dataContainer.sizeIncludingExpired(segments);
            if (persistenceSize >= 0L) {
                return inMemorySize + persistenceSize;
            }
            return inMemorySize;
        }
        if (persistenceSize >= 0L) {
            return persistenceSize;
        }
        return this.dataContainer.sizeIncludingExpired(segments);
    }

    @ManagedAttribute(description="Approximate number of entries currently in memory, including expired entries", displayName="Approximate number of cache entries in memory")
    public long getApproximateEntriesInMemory() {
        return this.dataContainer.sizeIncludingExpired();
    }

    @ManagedAttribute(description="Approximate number of entries currently in the cache for which the local node is a primary owner, including persisted and expired entries", displayName="Approximate number of entries owned as primary")
    public long getApproximateEntriesUnique() {
        IntSet primarySegments;
        if (this.distributionManager != null) {
            LocalizedCacheTopology cacheTopology = this.distributionManager.getCacheTopology();
            primarySegments = cacheTopology.getLocalPrimarySegments();
        } else {
            primarySegments = IntSets.immutableRangeSet((int)this.cacheConfiguration.clustering().hash().numSegments());
        }
        long persistenceSize = CompletionStages.join(this.approximatePersistenceSize(primarySegments, primarySegments));
        return this.approximateTotalSize(persistenceSize, primarySegments);
    }

    @Deprecated(forRemoval=true)
    @ManagedAttribute(description="Number of entries in the cache including passivated entries", displayName="Number of current cache entries")
    public int getNumberOfEntries() {
        return this.globalConfiguration.metrics().accurateSize() ? this.cache.wired().withFlags(Flag.CACHE_MODE_LOCAL).size() : -1;
    }

    @Deprecated(forRemoval=true)
    @ManagedAttribute(description="Number of entries currently in-memory excluding expired entries", displayName="Number of in-memory cache entries")
    public int getNumberOfEntriesInMemory() {
        return this.globalConfiguration.metrics().accurateSize() ? this.dataContainer.size() : -1;
    }

    @ManagedAttribute(description="Amount of memory in bytes allocated for use in eviction for data in the cache", displayName="Memory used by data in the cache")
    public long getDataMemoryUsed() {
        if (this.cacheConfiguration.memory().isEvictionEnabled() && this.cacheConfiguration.memory().maxSizeBytes() > 0L) {
            return this.dataContainer.evictionSize();
        }
        return -1L;
    }

    @ManagedAttribute(description="Amount off-heap memory used by this cache (bytes)", displayName="Off-Heap memory used")
    public long getOffHeapMemoryUsed() {
        return this.allocator.getAllocatedAmount();
    }

    @ManagedAttribute(description="Amount of nodes required to guarantee data consistency", displayName="Required Minimum Nodes")
    public int getRequiredMinimumNumberOfNodes() {
        return CacheMgmtInterceptor.calculateRequiredMinimumNumberOfNodes(this.cache.wired(), this.componentRegistry);
    }

    public static int calculateRequiredMinimumNumberOfNodes(AdvancedCache<?, ?> cache, ComponentRegistry componentRegistry) {
        int evictionRestrictedNodes;
        Configuration config = cache.getCacheConfiguration();
        ClusteringConfiguration clusteringConfiguration = config.clustering();
        CacheMode mode = clusteringConfiguration.cacheMode();
        if (mode.isReplicated() || !mode.isClustered()) {
            return 1;
        }
        LocalizedCacheTopology cacheTopology = cache.getDistributionManager().getCacheTopology();
        if (mode.isInvalidation()) {
            return cacheTopology.getMembers().size();
        }
        int numMembers = cacheTopology.getMembers().size();
        int numOwners = mode.isScattered() ? 2 : clusteringConfiguration.hash().numOwners();
        int minNodes = numMembers - numOwners + 1;
        long maxSize = config.memory().size();
        if (maxSize > 0L) {
            long capacity;
            long totalData;
            EvictionStrategy evictionStrategy = config.memory().evictionStrategy();
            switch (evictionStrategy) {
                case REMOVE: {
                    DataContainer<?, ?> dataContainer = cache.getDataContainer();
                    totalData = dataContainer.evictionSize() * (long)numOwners;
                    capacity = dataContainer.capacity();
                    break;
                }
                case EXCEPTION: {
                    TransactionalExceptionEvictionInterceptor exceptionInterceptor = componentRegistry.getComponent(TransactionalExceptionEvictionInterceptor.class);
                    totalData = exceptionInterceptor.getCurrentSize();
                    capacity = exceptionInterceptor.getMaxSize();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("We only support remove or exception based strategy here");
                }
            }
            evictionRestrictedNodes = (int)(totalData / capacity) + (totalData % capacity != 0L ? 1 : 0);
        } else {
            evictionRestrictedNodes = 1;
        }
        return Math.max(evictionRestrictedNodes, minNodes);
    }

    @ManagedAttribute(description="Number of seconds since cache started", displayName="Seconds since cache started", units=Units.SECONDS, measurementType=MeasurementType.TRENDSUP)
    public long getTimeSinceStart() {
        return this.timeService.timeDuration(this.startNanoseconds.get(), TimeUnit.SECONDS);
    }

    @Deprecated(forRemoval=true)
    @ManagedAttribute(description="Number of seconds since cache started", displayName="Seconds since cache started", units=Units.SECONDS, measurementType=MeasurementType.TRENDSUP)
    public long getElapsedTime() {
        return this.getTimeSinceStart();
    }

    @ManagedAttribute(description="Number of seconds since the cache statistics were last reset", displayName="Seconds since cache statistics were reset", units=Units.SECONDS)
    public long getTimeSinceReset() {
        return this.timeService.timeDuration(this.resetNanoseconds.get(), TimeUnit.SECONDS);
    }

    @Override
    public void resetStatistics() {
        this.counters.reset(StripeB.hitsFieldUpdater);
        this.counters.reset(StripeB.missesFieldUpdater);
        this.counters.reset(StripeB.storesFieldUpdater);
        this.counters.reset(StripeB.evictionsFieldUpdater);
        this.counters.reset(StripeB.hitTimesFieldUpdater);
        this.counters.reset(StripeB.missTimesFieldUpdater);
        this.counters.reset(StripeB.storeTimesFieldUpdater);
        this.counters.reset(StripeB.removeHitsFieldUpdater);
        this.counters.reset(StripeB.removeTimesFieldUpdater);
        this.counters.reset(StripeB.removeMissesFieldUpdater);
        this.resetNanoseconds.set(this.timeService.time());
    }

    private boolean collectStatisticsForCommand(FlagAffectedCommand cmd) {
        return super.getStatisticsEnabled() && !cmd.hasAnyFlag(FlagBitSets.SKIP_STATISTICS);
    }

    public void addEvictions(long numEvictions) {
        this.counters.add(StripeB.evictionsFieldUpdater, (Object)((StripeB)this.counters.stripeForCurrentThread()), numEvictions);
    }

    private static class StripeB
    extends StripeA {
        static final AtomicLongFieldUpdater<StripeB> hitTimesFieldUpdater = AtomicLongFieldUpdater.newUpdater(StripeB.class, "hitTimes");
        static final AtomicLongFieldUpdater<StripeB> missTimesFieldUpdater = AtomicLongFieldUpdater.newUpdater(StripeB.class, "missTimes");
        static final AtomicLongFieldUpdater<StripeB> storeTimesFieldUpdater = AtomicLongFieldUpdater.newUpdater(StripeB.class, "storeTimes");
        static final AtomicLongFieldUpdater<StripeB> removeHitsFieldUpdater = AtomicLongFieldUpdater.newUpdater(StripeB.class, "removeHits");
        static final AtomicLongFieldUpdater<StripeB> removeMissesFieldUpdater = AtomicLongFieldUpdater.newUpdater(StripeB.class, "removeMisses");
        static final AtomicLongFieldUpdater<StripeB> storesFieldUpdater = AtomicLongFieldUpdater.newUpdater(StripeB.class, "stores");
        static final AtomicLongFieldUpdater<StripeB> evictionsFieldUpdater = AtomicLongFieldUpdater.newUpdater(StripeB.class, "evictions");
        static final AtomicLongFieldUpdater<StripeB> missesFieldUpdater = AtomicLongFieldUpdater.newUpdater(StripeB.class, "misses");
        static final AtomicLongFieldUpdater<StripeB> hitsFieldUpdater = AtomicLongFieldUpdater.newUpdater(StripeB.class, "hits");
        static final AtomicLongFieldUpdater<StripeB> removeTimesFieldUpdater = AtomicLongFieldUpdater.newUpdater(StripeB.class, "removeTimes");
        private volatile long hits = 0L;
        private volatile long hitTimes = 0L;
        private volatile long misses = 0L;
        private volatile long missTimes = 0L;
        private volatile long stores = 0L;
        private volatile long storeTimes = 0L;
        private volatile long evictions = 0L;
        private volatile long removeHits = 0L;
        private volatile long removeMisses = 0L;
        private volatile long removeTimes = 0L;

        private StripeB() {
        }
    }

    private static final class StripeC
    extends StripeB {
        private long slack1;
        private long slack2;
        private long slack3;
        private long slack4;
        private long slack5;
        private long slack6;
        private long slack7;
        private long slack8;

        private StripeC() {
        }
    }

    private static class StripeA {
        private long slack1;
        private long slack2;
        private long slack3;
        private long slack4;
        private long slack5;
        private long slack6;
        private long slack7;
        private long slack8;

        private StripeA() {
        }
    }
}

