/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.persistence.impl;

import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.marshall.persistence.impl.MarshallableEntryImpl;
import org.infinispan.marshall.persistence.impl.MarshalledValueImpl;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.MarshallableEntryFactory;
import org.infinispan.persistence.spi.MarshalledValue;

@Scope(value=Scopes.NAMED_CACHE)
public class MarshalledEntryFactoryImpl
implements MarshallableEntryFactory {
    private static final MarshallableEntry EMPTY = new MarshallableEntryImpl();
    @Inject
    @ComponentName(value="org.infinispan.marshaller.persistence")
    Marshaller marshaller;

    public MarshalledEntryFactoryImpl() {
    }

    public MarshalledEntryFactoryImpl(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public MarshallableEntry create(ByteBuffer key, ByteBuffer valueBytes) {
        return this.create(key, valueBytes, (ByteBuffer)null, (ByteBuffer)null, -1L, -1L);
    }

    public MarshallableEntry create(ByteBuffer key, ByteBuffer valueBytes, ByteBuffer metadataBytes, ByteBuffer internalMetadataBytes, long created, long lastUsed) {
        return new MarshallableEntryImpl(key, valueBytes, metadataBytes, internalMetadataBytes, created, lastUsed, this.marshaller);
    }

    public MarshallableEntry create(Object key, ByteBuffer valueBytes, ByteBuffer metadataBytes, ByteBuffer internalMetadataBytes, long created, long lastUsed) {
        return new MarshallableEntryImpl(key, valueBytes, metadataBytes, internalMetadataBytes, created, lastUsed, this.marshaller);
    }

    public MarshallableEntry create(Object key) {
        return this.create(key, MarshalledValueImpl.EMPTY);
    }

    public MarshallableEntry create(Object key, Object value) {
        return this.create(key, value, null, null, -1L, -1L);
    }

    public MarshallableEntry create(Object key, Object value, Metadata metadata, PrivateMetadata internalMetadata, long created, long lastUsed) {
        return new MarshallableEntryImpl<Object, Object>(key, value, metadata, internalMetadata, created, lastUsed, this.marshaller);
    }

    public MarshallableEntry create(Object key, MarshalledValue value) {
        return new MarshallableEntryImpl(key, value.getValueBytes(), value.getMetadataBytes(), value.getInternalMetadataBytes(), value.getCreated(), value.getLastUsed(), this.marshaller);
    }

    public MarshallableEntry cloneWithExpiration(MarshallableEntry me, long creationTime, long lifespan) {
        Metadata.Builder builder;
        Metadata metadata = me.getMetadata();
        if (metadata != null) {
            if (metadata.lifespan() > 0L) {
                return me;
            }
            builder = metadata.builder();
        } else {
            builder = new EmbeddedMetadata.Builder();
        }
        metadata = builder.lifespan(lifespan).build();
        if (!(me instanceof MarshallableEntryImpl)) {
            return new MarshallableEntryImpl(me.getKey(), me.getValue(), metadata, me.getInternalMetadata(), creationTime, creationTime, this.marshaller);
        }
        MarshallableEntryImpl meCast = (MarshallableEntryImpl)me;
        meCast.metadata = metadata;
        meCast.metadataBytes = null;
        meCast.created = creationTime;
        return meCast;
    }

    public MarshallableEntry getEmpty() {
        return EMPTY;
    }
}

