/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity.internal;

import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.engine.spi.EntityHolder;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.EntityUniqueKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.type.Type;

public class EntityDelayedFetchInitializer
implements EntityInitializer {
    private final FetchParentAccess parentAccess;
    private final NavigablePath navigablePath;
    private final FetchParentAccess owningParent;
    private final EntityMappingType ownedModelPartDeclaringType;
    private final boolean isPartOfKey;
    private final ToOneAttributeMapping referencedModelPart;
    private final boolean selectByUniqueKey;
    private final DomainResultAssembler<?> identifierAssembler;
    protected boolean parentShallowCached;
    private boolean processed;
    private Object entityInstance;
    private Object identifier;

    public EntityDelayedFetchInitializer(FetchParentAccess parentAccess, NavigablePath fetchedNavigable, ToOneAttributeMapping referencedModelPart, boolean selectByUniqueKey, DomainResultAssembler<?> identifierAssembler) {
        assert (referencedModelPart.getNotFoundAction() == null);
        this.parentAccess = parentAccess;
        this.navigablePath = fetchedNavigable;
        this.isPartOfKey = Initializer.isPartOfKey(fetchedNavigable, parentAccess);
        this.owningParent = FetchParentAccess.determineOwningParent(parentAccess);
        this.ownedModelPartDeclaringType = FetchParentAccess.determineOwnedModelPartDeclaringType(referencedModelPart, parentAccess, this.owningParent);
        this.referencedModelPart = referencedModelPart;
        this.selectByUniqueKey = selectByUniqueKey;
        this.identifierAssembler = identifierAssembler;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public void resolveKey(RowProcessingState rowProcessingState) {
    }

    @Override
    public ModelPart getInitializedPart() {
        return this.referencedModelPart;
    }

    @Override
    public void resolveInstance(RowProcessingState rowProcessingState) {
        if (this.processed) {
            return;
        }
        this.processed = true;
        if (this.parentShallowCached || this.shouldSkipInitializer(rowProcessingState)) {
            return;
        }
        this.identifier = this.identifierAssembler.assemble(rowProcessingState);
        if (this.identifier == null) {
            this.entityInstance = null;
        } else {
            SharedSessionContractImplementor session = rowProcessingState.getSession();
            EntityPersister concreteDescriptor = this.referencedModelPart.getEntityMappingType().getEntityPersister();
            PersistenceContext persistenceContext = session.getPersistenceContextInternal();
            if (this.selectByUniqueKey) {
                String uniqueKeyPropertyName = this.referencedModelPart.getReferencedPropertyName();
                Type uniqueKeyPropertyType = this.referencedModelPart.getReferencedPropertyName() == null ? concreteDescriptor.getIdentifierType() : session.getFactory().getReferencedPropertyType(concreteDescriptor.getEntityName(), uniqueKeyPropertyName);
                EntityUniqueKey euk = new EntityUniqueKey(concreteDescriptor.getEntityName(), uniqueKeyPropertyName, this.identifier, uniqueKeyPropertyType, session.getFactory());
                this.entityInstance = persistenceContext.getEntity(euk);
                if (this.entityInstance == null) {
                    if (this.referencedModelPart.isLazy()) {
                        this.entityInstance = LazyPropertyInitializer.UNFETCHED_PROPERTY;
                    } else {
                        this.entityInstance = concreteDescriptor.loadByUniqueKey(uniqueKeyPropertyName, this.identifier, session);
                        if (this.entityInstance != null) {
                            persistenceContext.addEntity(euk, this.entityInstance);
                        }
                    }
                }
                if (this.entityInstance != null) {
                    this.entityInstance = persistenceContext.proxyFor(this.entityInstance);
                }
            } else {
                EntityKey entityKey = new EntityKey(this.identifier, concreteDescriptor);
                EntityHolder holder = persistenceContext.getEntityHolder(entityKey);
                if (holder != null && holder.getEntity() != null) {
                    this.entityInstance = persistenceContext.proxyFor(holder, concreteDescriptor);
                } else if (this.referencedModelPart.isOptional() && this.referencedModelPart.isLazy()) {
                    this.entityInstance = LazyPropertyInitializer.UNFETCHED_PROPERTY;
                } else {
                    this.entityInstance = session.internalLoad(concreteDescriptor.getEntityName(), this.identifier, false, false);
                    LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(this.entityInstance);
                    if (lazyInitializer != null) {
                        lazyInitializer.setUnwrap(this.referencedModelPart.isUnwrapProxy() && concreteDescriptor.isInstrumented());
                    }
                }
            }
        }
    }

    @Override
    public void initializeInstance(RowProcessingState rowProcessingState) {
    }

    @Override
    public void finishUpRow(RowProcessingState rowProcessingState) {
        this.entityInstance = null;
        this.identifier = null;
        this.processed = false;
    }

    @Override
    public void markShallowCached() {
        this.parentShallowCached = true;
    }

    @Override
    public void endLoading(ExecutionContext executionContext) {
        this.parentShallowCached = false;
    }

    @Override
    public EntityPersister getEntityDescriptor() {
        return this.referencedModelPart.getEntityMappingType().getEntityPersister();
    }

    @Override
    public Object getEntityInstance() {
        return this.entityInstance;
    }

    @Override
    public boolean isEntityInitialized() {
        return false;
    }

    @Override
    public FetchParentAccess getFetchParentAccess() {
        return this.parentAccess;
    }

    @Override
    public @Nullable FetchParentAccess getOwningParent() {
        return this.owningParent;
    }

    @Override
    public @Nullable EntityMappingType getOwnedModelPartDeclaringType() {
        return this.ownedModelPartDeclaringType;
    }

    @Override
    public boolean isPartOfKey() {
        return this.isPartOfKey;
    }

    @Override
    public boolean isResultInitializer() {
        return false;
    }

    @Override
    public EntityPersister getConcreteDescriptor() {
        return this.getEntityDescriptor();
    }

    public String toString() {
        return "EntityDelayedFetchInitializer(" + LoggingHelper.toLoggableString(this.navigablePath) + ")";
    }

    protected void setEntityInstance(Object entityInstance) {
        this.entityInstance = entityInstance;
    }

    protected void setProcessed(boolean processed) {
        this.processed = processed;
    }

    protected boolean isProcessed() {
        return this.processed;
    }

    protected Object getIdentifier() {
        return this.identifier;
    }

    protected void setIdentifier(Object identifier) {
        this.identifier = identifier;
    }

    protected boolean isSelectByUniqueKey() {
        return this.selectByUniqueKey;
    }

    protected DomainResultAssembler<?> getIdentifierAssembler() {
        return this.identifierAssembler;
    }

    @Override
    public EntityKey getEntityKey() {
        throw new UnsupportedOperationException("This should never happen, because this initializer has not child initializers");
    }

    @Override
    public Object getParentKey() {
        throw new UnsupportedOperationException("This should never happen, because this initializer has not child initializers");
    }

    @Override
    public void registerResolutionListener(Consumer<Object> listener) {
        throw new UnsupportedOperationException("This should never happen, because this initializer has not child initializers");
    }
}

