/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.grpclb;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import io.grpc.InternalServiceProviders;
import io.grpc.NameResolver;
import io.grpc.NameResolverProvider;
import io.grpc.grpclb.GrpclbNameResolver;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.SharedResourceHolder;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Executor;

final class SecretGrpclbNameResolverProvider {
    private SecretGrpclbNameResolverProvider() {
    }

    public static final class Provider
    extends NameResolverProvider {
        private static final String SCHEME = "dns";
        private static final boolean IS_ANDROID = InternalServiceProviders.isAndroid((ClassLoader)SecretGrpclbNameResolverProvider.class.getClassLoader());

        public GrpclbNameResolver newNameResolver(URI targetUri, NameResolver.Args args) {
            if (SCHEME.equals(targetUri.getScheme())) {
                String targetPath = (String)Preconditions.checkNotNull((Object)targetUri.getPath(), (Object)"targetPath");
                Preconditions.checkArgument((boolean)targetPath.startsWith("/"), (String)"the path component (%s) of the target (%s) must start with '/'", (Object)targetPath, (Object)targetUri);
                String name = targetPath.substring(1);
                return new GrpclbNameResolver(targetUri.getAuthority(), name, args, (SharedResourceHolder.Resource<Executor>)GrpcUtil.SHARED_CHANNEL_EXECUTOR, Stopwatch.createUnstarted(), IS_ANDROID);
            }
            return null;
        }

        public String getDefaultScheme() {
            return SCHEME;
        }

        protected boolean isAvailable() {
            return true;
        }

        public int priority() {
            return 6;
        }

        protected Collection<Class<? extends SocketAddress>> getProducedSocketAddressTypes() {
            return Collections.singleton(InetSocketAddress.class);
        }
    }
}

