/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.annotation;

import java.io.Serializable;
import javax.cache.Cache;
import javax.cache.annotation.CacheKeyGenerator;
import javax.cache.annotation.CacheRemove;
import javax.cache.annotation.CacheResolver;
import javax.cache.annotation.GeneratedCacheKey;
import javax.interceptor.InvocationContext;
import org.infinispan.jcache.annotation.CacheKeyInvocationContextFactory;
import org.infinispan.jcache.annotation.CacheKeyInvocationContextImpl;
import org.infinispan.jcache.logging.Log;

public abstract class AbstractCacheRemoveEntryInterceptor
implements Serializable {
    private static final long serialVersionUID = -9079291622309963969L;
    private final CacheResolver defaultCacheResolver;
    private final CacheKeyInvocationContextFactory contextFactory;

    public AbstractCacheRemoveEntryInterceptor(CacheResolver defaultCacheResolver, CacheKeyInvocationContextFactory contextFactory) {
        this.defaultCacheResolver = defaultCacheResolver;
        this.contextFactory = contextFactory;
    }

    public Object cacheRemoveEntry(InvocationContext invocationContext) throws Exception {
        if (this.getLog().isTraceEnabled()) {
            this.getLog().tracef("Interception of method '%s.%s'", (Object)invocationContext.getMethod().getDeclaringClass().getName(), (Object)invocationContext.getMethod().getName());
        }
        CacheKeyInvocationContextImpl cacheKeyInvocationContext = this.contextFactory.getCacheKeyInvocationContext(invocationContext);
        CacheKeyGenerator cacheKeyGenerator = cacheKeyInvocationContext.getCacheKeyGenerator();
        CacheResolver cacheResolver = cacheKeyInvocationContext.getCacheResolver();
        if (cacheResolver == null) {
            cacheResolver = this.defaultCacheResolver;
        }
        Cache cache = cacheResolver.resolveCache(cacheKeyInvocationContext);
        CacheRemove cacheRemoveEntry = (CacheRemove)cacheKeyInvocationContext.getCacheAnnotation();
        GeneratedCacheKey cacheKey = cacheKeyGenerator.generateCacheKey(cacheKeyInvocationContext);
        if (!cacheRemoveEntry.afterInvocation()) {
            cache.remove((Object)cacheKey);
            if (this.getLog().isTraceEnabled()) {
                this.getLog().tracef("Removed before invocation in cache '%s' key '%s'", (Object)cache.getName(), (Object)cacheKey);
            }
        }
        Object result = invocationContext.proceed();
        if (cacheRemoveEntry.afterInvocation()) {
            cache.remove((Object)cacheKey);
            if (this.getLog().isTraceEnabled()) {
                this.getLog().tracef("Removed after invocation in cache '%s' key '%s'", (Object)cache.getName(), (Object)cacheKey);
            }
        }
        return result;
    }

    protected abstract Log getLog();
}

