/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.core.Ordered;
import org.springframework.credhub.core.CredHubOperations;
import org.springframework.credhub.support.CredentialDetails;
import org.springframework.credhub.support.CredentialName;
import org.springframework.credhub.support.SimpleCredentialName;
import org.springframework.credhub.support.json.JsonCredential;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class CredhubEnvironmentRepository
implements EnvironmentRepository,
Ordered {
    private CredHubOperations credHubOperations;
    private static final String DEFAULT_PROFILE = "default";
    private static final String DEFAULT_LABEL = "master";
    private static final String DEFAULT_APPLICATION = "application";
    private int order = Integer.MAX_VALUE;

    public CredhubEnvironmentRepository(CredHubOperations credHubOperations) {
        this.credHubOperations = credHubOperations;
    }

    @Override
    public Environment findOne(String application, String profilesList, String label) {
        if (ObjectUtils.isEmpty((Object)profilesList)) {
            profilesList = DEFAULT_PROFILE;
        }
        if (ObjectUtils.isEmpty((Object)label)) {
            label = DEFAULT_LABEL;
        }
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profilesList);
        Environment environment = new Environment(application, profiles, label, null, null);
        for (String profile : profiles) {
            environment.add(new PropertySource("credhub-" + application + "-" + profile + "-" + label, this.findProperties(application, profile, label)));
            if (DEFAULT_APPLICATION.equals(application)) continue;
            this.addDefaultPropertySource(environment, DEFAULT_APPLICATION, profile, label);
        }
        if (!Arrays.asList(profiles).contains(DEFAULT_PROFILE)) {
            this.addDefaultPropertySource(environment, application, DEFAULT_PROFILE, label);
        }
        if (!Arrays.asList(profiles).contains(DEFAULT_PROFILE) && !DEFAULT_APPLICATION.equals(application)) {
            this.addDefaultPropertySource(environment, DEFAULT_APPLICATION, DEFAULT_PROFILE, label);
        }
        return environment;
    }

    private void addDefaultPropertySource(Environment environment, String application, String profile, String label) {
        Map<Object, Object> properties = this.findProperties(application, profile, label);
        if (!properties.isEmpty()) {
            PropertySource propertySource = new PropertySource("credhub-" + application + "-" + profile + "-" + label, properties);
            environment.add(propertySource);
        }
    }

    private Map<Object, Object> findProperties(String application, String profile, String label) {
        String path = "/" + application + "/" + profile + "/" + label;
        return this.credHubOperations.credentials().findByPath(path).stream().map(credentialSummary -> credentialSummary.getName().getName()).map(name -> this.credHubOperations.credentials().getByName((CredentialName)new SimpleCredentialName(new String[]{name}), JsonCredential.class)).map(CredentialDetails::getValue).flatMap(jsonCredential -> jsonCredential.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> b));
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

