/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jdbc.store.drivers;

import java.lang.invoke.MethodHandles;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.activemq.artemis.jdbc.store.drivers.JDBCConnectionProvider;
import org.apache.activemq.artemis.jdbc.store.drivers.JDBCUtils;
import org.apache.activemq.artemis.jdbc.store.sql.SQLProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJDBCDriver {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected SQLProvider sqlProvider;
    protected JDBCConnectionProvider connectionProvider;

    public AbstractJDBCDriver() {
    }

    public AbstractJDBCDriver(JDBCConnectionProvider connectionProvider, SQLProvider provider) {
        this.connectionProvider = connectionProvider;
        this.sqlProvider = provider;
    }

    public void start() throws SQLException {
        this.createSchema();
        this.prepareStatements();
    }

    public void stop() throws SQLException {
    }

    protected abstract void prepareStatements();

    protected abstract void createSchema() throws SQLException;

    protected final void createTable(String ... schemaSqls) throws SQLException {
        this.createTableIfNotExists(this.sqlProvider.getTableName(), schemaSqls);
    }

    public void destroy() throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("dropping {}", (Object)this.sqlProvider.getTableName(), (Object)new Exception("trace"));
        }
        String dropTableSql = "DROP TABLE " + this.sqlProvider.getTableName();
        try (Connection connection = this.connectionProvider.getConnection();){
            try {
                connection.setAutoCommit(false);
                try (Statement statement = connection.createStatement();){
                    statement.executeUpdate(dropTableSql);
                }
                connection.commit();
            }
            catch (SQLException e) {
                logger.error(JDBCUtils.appendSQLExceptionDetails(new StringBuilder(), e, dropTableSql).toString());
                try {
                    connection.rollback();
                }
                catch (SQLException rollbackEx) {
                    logger.error(JDBCUtils.appendSQLExceptionDetails(new StringBuilder(), rollbackEx, dropTableSql).toString());
                    throw rollbackEx;
                }
                throw e;
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void createTableIfNotExists(String tableName, String ... sqls) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public SQLProvider getSqlProvider() {
        return this.sqlProvider;
    }

    public void setSqlProvider(SQLProvider sqlProvider) {
        this.sqlProvider = sqlProvider;
    }

    public void setJdbcConnectionProvider(JDBCConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
    }

    public JDBCConnectionProvider getJdbcConnectionProvider() {
        return this.connectionProvider;
    }

    private static /* synthetic */ String[] lambda$createTableIfNotExists$2(int x$0) {
        return new String[x$0];
    }

    private static /* synthetic */ boolean lambda$createTableIfNotExists$1(String sql) {
        String upperCaseSql = sql.toUpperCase();
        return !upperCaseSql.contains("CREATE TABLE") && !upperCaseSql.contains("CREATE INDEX");
    }

    private static /* synthetic */ boolean lambda$createTableIfNotExists$0(String sql) {
        return sql.contains("INSERT INTO");
    }
}

