/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.spi;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.persister.internal.SqlFragmentPredicate;
import org.hibernate.query.sqm.tree.expression.Conversion;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.expression.AggregateColumnWriteExpression;
import org.hibernate.sql.ast.tree.expression.Any;
import org.hibernate.sql.ast.tree.expression.BinaryArithmeticExpression;
import org.hibernate.sql.ast.tree.expression.CaseSearchedExpression;
import org.hibernate.sql.ast.tree.expression.CaseSimpleExpression;
import org.hibernate.sql.ast.tree.expression.CastTarget;
import org.hibernate.sql.ast.tree.expression.Collation;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Distinct;
import org.hibernate.sql.ast.tree.expression.Duration;
import org.hibernate.sql.ast.tree.expression.DurationUnit;
import org.hibernate.sql.ast.tree.expression.EntityTypeLiteral;
import org.hibernate.sql.ast.tree.expression.Every;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.ExtractUnit;
import org.hibernate.sql.ast.tree.expression.Format;
import org.hibernate.sql.ast.tree.expression.JdbcLiteral;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.expression.ModifiedSubQueryExpression;
import org.hibernate.sql.ast.tree.expression.Over;
import org.hibernate.sql.ast.tree.expression.Overflow;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.expression.SelfRenderingExpression;
import org.hibernate.sql.ast.tree.expression.SqlSelectionExpression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.Star;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.expression.TrimSpecification;
import org.hibernate.sql.ast.tree.expression.UnaryOperation;
import org.hibernate.sql.ast.tree.from.FromClause;
import org.hibernate.sql.ast.tree.from.FunctionTableReference;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.QueryPartTableReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.from.ValuesTableReference;
import org.hibernate.sql.ast.tree.insert.InsertSelectStatement;
import org.hibernate.sql.ast.tree.predicate.BetweenPredicate;
import org.hibernate.sql.ast.tree.predicate.BooleanExpressionPredicate;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.ExistsPredicate;
import org.hibernate.sql.ast.tree.predicate.FilterPredicate;
import org.hibernate.sql.ast.tree.predicate.GroupedPredicate;
import org.hibernate.sql.ast.tree.predicate.InArrayPredicate;
import org.hibernate.sql.ast.tree.predicate.InListPredicate;
import org.hibernate.sql.ast.tree.predicate.InSubQueryPredicate;
import org.hibernate.sql.ast.tree.predicate.Junction;
import org.hibernate.sql.ast.tree.predicate.LikePredicate;
import org.hibernate.sql.ast.tree.predicate.NegatedPredicate;
import org.hibernate.sql.ast.tree.predicate.NullnessPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.predicate.SelfRenderingPredicate;
import org.hibernate.sql.ast.tree.select.QueryGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.ast.tree.select.SortSpecification;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.model.ast.ColumnWriteFragment;
import org.hibernate.sql.model.internal.TableDeleteCustomSql;
import org.hibernate.sql.model.internal.TableDeleteStandard;
import org.hibernate.sql.model.internal.TableInsertCustomSql;
import org.hibernate.sql.model.internal.TableInsertStandard;
import org.hibernate.sql.model.internal.TableUpdateCustomSql;
import org.hibernate.sql.model.internal.TableUpdateStandard;

public class ExpressionReplacementWalker
implements SqlAstWalker {
    private SqlAstNode returnedNode;

    public final <X extends SqlAstNode> X replaceExpressions(X expression) {
        expression.accept(this);
        return (X)this.returnedNode;
    }

    protected <X extends SqlAstNode> X replaceExpression(X expression) {
        return expression;
    }

    private void doReplaceExpression(SqlAstNode expression) {
        this.returnedNode = this.replaceExpression(expression);
    }

    @Override
    public void visitColumnReference(ColumnReference columnReference) {
        this.doReplaceExpression(columnReference);
    }

    @Override
    public void visitAggregateColumnWriteExpression(AggregateColumnWriteExpression aggregateColumnWriteExpression) {
        this.doReplaceExpression(aggregateColumnWriteExpression);
    }

    @Override
    public void visitExtractUnit(ExtractUnit extractUnit) {
        this.doReplaceExpression(extractUnit);
    }

    @Override
    public void visitFormat(Format format) {
        this.doReplaceExpression(format);
    }

    @Override
    public void visitDistinct(Distinct distinct) {
        this.doReplaceExpression(distinct);
    }

    @Override
    public void visitOverflow(Overflow overflow) {
        this.doReplaceExpression(overflow);
    }

    @Override
    public void visitStar(Star star) {
        this.doReplaceExpression(star);
    }

    @Override
    public void visitTrimSpecification(TrimSpecification trimSpecification) {
        this.doReplaceExpression(trimSpecification);
    }

    @Override
    public void visitCastTarget(CastTarget castTarget) {
        this.doReplaceExpression(castTarget);
    }

    @Override
    public void visitBinaryArithmeticExpression(BinaryArithmeticExpression arithmeticExpression) {
        this.doReplaceExpression(arithmeticExpression);
    }

    @Override
    public void visitCaseSearchedExpression(CaseSearchedExpression caseSearchedExpression) {
        this.doReplaceExpression(caseSearchedExpression);
    }

    @Override
    public void visitCaseSimpleExpression(CaseSimpleExpression caseSimpleExpression) {
        this.doReplaceExpression(caseSimpleExpression);
    }

    @Override
    public void visitAny(Any any) {
        this.doReplaceExpression(any);
    }

    @Override
    public void visitEvery(Every every) {
        this.doReplaceExpression(every);
    }

    @Override
    public void visitSummarization(Summarization every) {
        this.doReplaceExpression(every);
    }

    @Override
    public void visitOver(Over<?> over) {
        this.doReplaceExpression(over);
    }

    @Override
    public void visitSelfRenderingExpression(SelfRenderingExpression expression) {
        this.doReplaceExpression(expression);
    }

    @Override
    public void visitSqlSelectionExpression(SqlSelectionExpression expression) {
        this.doReplaceExpression(expression);
    }

    @Override
    public void visitEntityTypeLiteral(EntityTypeLiteral expression) {
        this.doReplaceExpression(expression);
    }

    @Override
    public void visitTuple(SqlTuple tuple) {
        this.doReplaceExpression(tuple);
    }

    @Override
    public void visitCollation(Collation collation) {
        this.doReplaceExpression(collation);
    }

    @Override
    public void visitParameter(JdbcParameter jdbcParameter) {
        this.doReplaceExpression(jdbcParameter);
    }

    @Override
    public void visitJdbcLiteral(JdbcLiteral<?> jdbcLiteral) {
        this.doReplaceExpression(jdbcLiteral);
    }

    @Override
    public void visitQueryLiteral(QueryLiteral<?> queryLiteral) {
        this.doReplaceExpression(queryLiteral);
    }

    @Override
    public void visitUnaryOperationExpression(UnaryOperation unaryOperationExpression) {
        this.doReplaceExpression(unaryOperationExpression);
    }

    @Override
    public void visitModifiedSubQueryExpression(ModifiedSubQueryExpression expression) {
        this.doReplaceExpression(expression);
    }

    @Override
    public void visitDurationUnit(DurationUnit durationUnit) {
        this.doReplaceExpression(durationUnit);
    }

    @Override
    public void visitDuration(Duration duration) {
        this.doReplaceExpression(duration);
    }

    @Override
    public void visitConversion(Conversion conversion) {
        this.doReplaceExpression(conversion);
    }

    @Override
    public void visitBooleanExpressionPredicate(BooleanExpressionPredicate booleanExpressionPredicate) {
        this.doReplaceExpression(booleanExpressionPredicate);
    }

    @Override
    public void visitSqlFragmentPredicate(SqlFragmentPredicate predicate) {
        this.doReplaceExpression(predicate);
    }

    @Override
    public void visitBetweenPredicate(BetweenPredicate betweenPredicate) {
        Expression expression = this.replaceExpression(betweenPredicate.getExpression());
        Expression lowerBound = this.replaceExpression(betweenPredicate.getLowerBound());
        Expression upperBound = this.replaceExpression(betweenPredicate.getUpperBound());
        this.returnedNode = expression != betweenPredicate.getExpression() || lowerBound != betweenPredicate.getLowerBound() || upperBound != betweenPredicate.getUpperBound() ? new BetweenPredicate(expression, lowerBound, upperBound, betweenPredicate.isNegated(), betweenPredicate.getExpressionType()) : betweenPredicate;
    }

    @Override
    public void visitGroupedPredicate(GroupedPredicate groupedPredicate) {
        groupedPredicate.getSubPredicate().accept(this);
        this.returnedNode = this.returnedNode != groupedPredicate.getSubPredicate() ? new GroupedPredicate((Predicate)this.returnedNode) : groupedPredicate;
    }

    @Override
    public void visitInListPredicate(InListPredicate inListPredicate) {
        Expression testExpression = this.replaceExpression(inListPredicate.getTestExpression());
        ArrayList<Expression> items = null;
        List<Expression> listExpressions = inListPredicate.getListExpressions();
        for (int i = 0; i < listExpressions.size(); ++i) {
            Expression listExpression = listExpressions.get(i);
            Expression newListExpression = this.replaceExpression(listExpression);
            if (newListExpression == listExpression) continue;
            if (items == null) {
                items = new ArrayList<Expression>(listExpressions);
            }
            items.set(i, newListExpression);
        }
        this.returnedNode = testExpression != inListPredicate.getTestExpression() || items != null ? new InListPredicate(testExpression, items == null ? listExpressions : items, inListPredicate.isNegated(), inListPredicate.getExpressionType()) : inListPredicate;
    }

    @Override
    public void visitInArrayPredicate(InArrayPredicate inArrayPredicate) {
        Expression replacedTestExpression = this.replaceExpression(inArrayPredicate.getTestExpression());
        this.returnedNode = new InArrayPredicate(replacedTestExpression, inArrayPredicate.getArrayParameter());
    }

    @Override
    public void visitInSubQueryPredicate(InSubQueryPredicate inSubQueryPredicate) {
        Expression testExpression = this.replaceExpression(inSubQueryPredicate.getTestExpression());
        SelectStatement subQuery = this.replaceExpression(inSubQueryPredicate.getSubQuery());
        this.returnedNode = testExpression != inSubQueryPredicate.getTestExpression() || subQuery != inSubQueryPredicate.getSubQuery() ? new InSubQueryPredicate(testExpression, subQuery, inSubQueryPredicate.isNegated(), inSubQueryPredicate.getExpressionType()) : inSubQueryPredicate;
    }

    @Override
    public void visitExistsPredicate(ExistsPredicate existsPredicate) {
        SelectStatement selectStatement = this.replaceExpression(existsPredicate.getExpression());
        this.returnedNode = selectStatement != existsPredicate.getExpression() ? new ExistsPredicate(selectStatement, existsPredicate.isNegated(), existsPredicate.getExpressionType()) : existsPredicate;
    }

    @Override
    public void visitJunction(Junction junction) {
        List<Predicate> predicates = junction.getPredicates();
        ArrayList<Predicate> newPredicates = null;
        for (int i = 0; i < predicates.size(); ++i) {
            predicates.get(i).accept(this);
            if (this.returnedNode == predicates.get(i)) continue;
            if (newPredicates == null) {
                newPredicates = new ArrayList<Predicate>(predicates);
            }
            newPredicates.set(i, (Predicate)this.returnedNode);
        }
        this.returnedNode = newPredicates != null ? new Junction(junction.getNature(), newPredicates, junction.getExpressionType()) : junction;
    }

    @Override
    public void visitLikePredicate(LikePredicate likePredicate) {
        Expression matchExpression = this.replaceExpression(likePredicate.getMatchExpression());
        Expression patternExpression = this.replaceExpression(likePredicate.getPattern());
        Expression escapeExpression = likePredicate.getEscapeCharacter() == null ? null : this.replaceExpression(likePredicate.getEscapeCharacter());
        this.returnedNode = matchExpression != likePredicate.getMatchExpression() || patternExpression != likePredicate.getPattern() || escapeExpression != likePredicate.getEscapeCharacter() ? new LikePredicate(matchExpression, patternExpression, escapeExpression, likePredicate.isNegated(), likePredicate.isCaseSensitive(), likePredicate.getExpressionType()) : likePredicate;
    }

    @Override
    public void visitNegatedPredicate(NegatedPredicate negatedPredicate) {
        negatedPredicate.getPredicate().accept(this);
        this.returnedNode = this.returnedNode != negatedPredicate.getPredicate() ? new NegatedPredicate((Predicate)this.returnedNode) : negatedPredicate;
    }

    @Override
    public void visitNullnessPredicate(NullnessPredicate nullnessPredicate) {
        Expression expression = this.replaceExpression(nullnessPredicate.getExpression());
        this.returnedNode = expression != nullnessPredicate.getExpression() ? new NullnessPredicate(expression, nullnessPredicate.isNegated(), nullnessPredicate.getExpressionType()) : nullnessPredicate;
    }

    @Override
    public void visitRelationalPredicate(ComparisonPredicate comparisonPredicate) {
        Expression lhs = this.replaceExpression(comparisonPredicate.getLeftHandExpression());
        Expression rhs = this.replaceExpression(comparisonPredicate.getRightHandExpression());
        this.returnedNode = lhs != comparisonPredicate.getLeftHandExpression() || rhs != comparisonPredicate.getRightHandExpression() ? new ComparisonPredicate(lhs, comparisonPredicate.getOperator(), rhs, comparisonPredicate.getExpressionType()) : comparisonPredicate;
    }

    @Override
    public void visitSelfRenderingPredicate(SelfRenderingPredicate selfRenderingPredicate) {
        SelfRenderingExpression selfRenderingExpression = this.replaceExpression(selfRenderingPredicate.getSelfRenderingExpression());
        this.returnedNode = selfRenderingExpression != selfRenderingPredicate.getSelfRenderingExpression() ? new SelfRenderingPredicate(selfRenderingExpression) : selfRenderingPredicate;
    }

    @Override
    public void visitSelectStatement(SelectStatement statement) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitDeleteStatement(DeleteStatement statement) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitUpdateStatement(UpdateStatement statement) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitInsertStatement(InsertSelectStatement statement) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitAssignment(Assignment assignment) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitQueryGroup(QueryGroup queryGroup) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitQuerySpec(QuerySpec querySpec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitSortSpecification(SortSpecification sortSpecification) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitOffsetFetchClause(QueryPart querySpec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitSelectClause(SelectClause selectClause) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitSqlSelection(SqlSelection sqlSelection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitFromClause(FromClause fromClause) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitTableGroup(TableGroup tableGroup) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitTableGroupJoin(TableGroupJoin tableGroupJoin) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitNamedTableReference(NamedTableReference tableReference) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitValuesTableReference(ValuesTableReference tableReference) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitQueryPartTableReference(QueryPartTableReference tableReference) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitFunctionTableReference(FunctionTableReference tableReference) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitTableReferenceJoin(TableReferenceJoin tableReferenceJoin) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitFilterPredicate(FilterPredicate filterPredicate) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitFilterFragmentPredicate(FilterPredicate.FilterFragmentPredicate fragmentPredicate) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitStandardTableInsert(TableInsertStandard tableInsert) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitCustomTableInsert(TableInsertCustomSql tableInsert) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitStandardTableUpdate(TableUpdateStandard tableUpdate) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitCustomTableUpdate(TableUpdateCustomSql tableUpdate) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitStandardTableDelete(TableDeleteStandard tableDelete) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitCustomTableDelete(TableDeleteCustomSql tableDelete) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitColumnWriteFragment(ColumnWriteFragment columnWriteFragment) {
        throw new UnsupportedOperationException();
    }
}

