/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl;

import java.lang.invoke.MethodHandles;
import java.util.IntSummaryStatistics;
import java.util.Iterator;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.infinispan.BaseCacheStream;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.infinispan.DoubleCacheStream;
import org.infinispan.IntCacheStream;
import org.infinispan.LongCacheStream;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.reactive.publisher.PublisherReducers;
import org.infinispan.stream.impl.AbstractCacheStream;
import org.infinispan.stream.impl.CacheBiConsumers;
import org.infinispan.stream.impl.DistributedCacheStream;
import org.infinispan.stream.impl.DistributedDoubleCacheStream;
import org.infinispan.stream.impl.DistributedLongCacheStream;
import org.infinispan.stream.impl.IntermediateIntCacheStream;
import org.infinispan.stream.impl.intops.primitive.i.AsDoubleIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.AsLongIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.BoxedIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.DistinctIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.FilterIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.FlatMapIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.LimitIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.MapIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.MapToDoubleIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.MapToLongIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.MapToObjIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.PeekIntOperation;
import org.infinispan.util.function.SerializableComparator;
import org.infinispan.util.function.SerializableIntConsumer;
import org.infinispan.util.function.SerializableIntFunction;
import org.infinispan.util.function.SerializableIntPredicate;
import org.infinispan.util.function.SerializableIntToDoubleFunction;
import org.infinispan.util.function.SerializableIntToLongFunction;
import org.infinispan.util.function.SerializableIntUnaryOperator;
import org.infinispan.util.function.SerializableObjIntConsumer;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class DistributedIntCacheStream<Original>
extends AbstractCacheStream<Original, Integer, IntStream, IntCacheStream>
implements IntCacheStream {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());

    protected DistributedIntCacheStream(AbstractCacheStream other) {
        super(other);
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected DistributedIntCacheStream unwrap() {
        return this;
    }

    @Override
    public IntCacheStream filter(IntPredicate predicate) {
        return (IntCacheStream)this.addIntermediateOperation(new FilterIntOperation(predicate));
    }

    @Override
    public IntCacheStream filter(SerializableIntPredicate predicate) {
        return this.filter((IntPredicate)predicate);
    }

    @Override
    public IntCacheStream map(IntUnaryOperator mapper) {
        return (IntCacheStream)this.addIntermediateOperation(new MapIntOperation(mapper));
    }

    @Override
    public IntCacheStream map(SerializableIntUnaryOperator mapper) {
        return this.map((IntUnaryOperator)mapper);
    }

    @Override
    public <U> CacheStream<U> mapToObj(IntFunction<? extends U> mapper) {
        this.addIntermediateOperationMap(new MapToObjIntOperation<U>(mapper));
        return this.cacheStream();
    }

    @Override
    public <U> CacheStream<U> mapToObj(SerializableIntFunction<? extends U> mapper) {
        return this.mapToObj((IntFunction)mapper);
    }

    @Override
    public LongCacheStream mapToLong(IntToLongFunction mapper) {
        this.addIntermediateOperationMap(new MapToLongIntOperation(mapper));
        return this.longCacheStream();
    }

    @Override
    public LongCacheStream mapToLong(SerializableIntToLongFunction mapper) {
        return this.mapToLong((IntToLongFunction)mapper);
    }

    @Override
    public DoubleCacheStream mapToDouble(IntToDoubleFunction mapper) {
        this.addIntermediateOperationMap(new MapToDoubleIntOperation(mapper));
        return this.doubleCacheStream();
    }

    @Override
    public DoubleCacheStream mapToDouble(SerializableIntToDoubleFunction mapper) {
        return this.mapToDouble((IntToDoubleFunction)mapper);
    }

    @Override
    public IntCacheStream flatMap(IntFunction<? extends IntStream> mapper) {
        this.iteratorOperation = AbstractCacheStream.IteratorOperation.FLAT_MAP;
        return (IntCacheStream)this.addIntermediateOperation(new FlatMapIntOperation(mapper));
    }

    @Override
    public IntCacheStream flatMap(SerializableIntFunction<? extends IntStream> mapper) {
        return this.flatMap((IntFunction)mapper);
    }

    @Override
    public IntCacheStream distinct() {
        this.addIntermediateOperation(DistinctIntOperation.getInstance());
        return new IntermediateIntCacheStream(this).distinct();
    }

    @Override
    public IntCacheStream sorted() {
        return new IntermediateIntCacheStream(this).sorted();
    }

    @Override
    public IntCacheStream peek(IntConsumer action) {
        return (IntCacheStream)this.addIntermediateOperation(new PeekIntOperation(action));
    }

    @Override
    public IntCacheStream peek(SerializableIntConsumer action) {
        return this.peek((IntConsumer)action);
    }

    @Override
    public IntCacheStream limit(long maxSize) {
        this.addIntermediateOperation(new LimitIntOperation(maxSize));
        return new IntermediateIntCacheStream(this).limit(maxSize);
    }

    @Override
    public IntCacheStream skip(long n) {
        return new IntermediateIntCacheStream(this).skip(n);
    }

    @Override
    public LongCacheStream asLongStream() {
        this.addIntermediateOperationMap(AsLongIntOperation.getInstance());
        return this.longCacheStream();
    }

    @Override
    public DoubleCacheStream asDoubleStream() {
        this.addIntermediateOperationMap(AsDoubleIntOperation.getInstance());
        return this.doubleCacheStream();
    }

    @Override
    public CacheStream<Integer> boxed() {
        this.addIntermediateOperationMap(BoxedIntOperation.getInstance());
        return this.cacheStream();
    }

    @Override
    public void forEach(IntConsumer action) {
        this.peek(action).iterator().forEachRemaining(ignore -> {});
    }

    @Override
    public void forEach(SerializableIntConsumer action) {
        this.forEach((IntConsumer)action);
    }

    @Override
    public <K, V> void forEach(ObjIntConsumer<Cache<K, V>> action) {
        this.peek(CacheBiConsumers.intConsumer(action)).iterator().forEachRemaining(ignore -> {});
    }

    @Override
    public <K, V> void forEach(SerializableObjIntConsumer<Cache<K, V>> action) {
        this.forEach((ObjIntConsumer<Cache<K, V>>)action);
    }

    @Override
    public void forEachOrdered(IntConsumer action) {
        this.forEach(action);
    }

    @Override
    public int[] toArray() {
        E[] values = this.performPublisherOperation(PublisherReducers.toArrayReducer(), PublisherReducers.toArrayFinalizer());
        int[] results = new int[values.length];
        int i = 0;
        for (Object obj : values) {
            results[i++] = (Integer)obj;
        }
        return results;
    }

    @Override
    public int reduce(int identity, IntBinaryOperator op) {
        Function reduce = PublisherReducers.reduce(identity, op::applyAsInt);
        return this.performPublisherOperation(reduce, reduce);
    }

    @Override
    public OptionalInt reduce(IntBinaryOperator op) {
        Function reduce = PublisherReducers.reduce(op::applyAsInt);
        Integer result = (Integer)this.performPublisherOperation(reduce, reduce);
        if (result == null) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(result);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjIntConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        return this.performPublisherOperation(PublisherReducers.collect(supplier, accumulator::accept), PublisherReducers.accumulate(combiner));
    }

    @Override
    public int sum() {
        long result = this.mapToLong(Integer::toUnsignedLong).sum();
        if (result > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)result;
    }

    @Override
    public OptionalInt min() {
        SerializableComparator serializableComparator = Integer::compareTo;
        Function minFunction = PublisherReducers.min(serializableComparator);
        Integer min = (Integer)this.performPublisherOperation(minFunction, minFunction);
        if (min == null) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(min);
    }

    @Override
    public OptionalInt max() {
        SerializableComparator serializableComparator = Integer::compareTo;
        Function maxFunction = PublisherReducers.max(serializableComparator);
        Integer max = (Integer)this.performPublisherOperation(maxFunction, maxFunction);
        if (max == null) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(max);
    }

    @Override
    public OptionalDouble average() {
        IntSummaryStatistics iss = this.summaryStatistics();
        if (iss.getCount() == 0L) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(iss.getAverage());
    }

    @Override
    public IntSummaryStatistics summaryStatistics() {
        return (IntSummaryStatistics)this.performPublisherOperation(PublisherReducers.reduceWith(IntSummaryStatistics::new, (lss, intValue) -> {
            lss.accept((int)intValue);
            return lss;
        }), PublisherReducers.reduce((first, second) -> {
            first.combine((IntSummaryStatistics)second);
            return first;
        }));
    }

    @Override
    public boolean anyMatch(IntPredicate predicate) {
        return this.performPublisherOperation(PublisherReducers.anyMatch(predicate::test), PublisherReducers.or());
    }

    @Override
    public boolean allMatch(IntPredicate predicate) {
        return this.performPublisherOperation(PublisherReducers.allMatch(predicate::test), PublisherReducers.and());
    }

    @Override
    public boolean noneMatch(IntPredicate predicate) {
        return this.performPublisherOperation(PublisherReducers.noneMatch(predicate::test), PublisherReducers.and());
    }

    @Override
    public OptionalInt findFirst() {
        return this.findAny();
    }

    @Override
    public OptionalInt findAny() {
        Function function = PublisherReducers.findFirst();
        Integer value = (Integer)this.performPublisherOperation(function, function);
        if (value == null) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(value);
    }

    @Override
    public PrimitiveIterator.OfInt iterator() {
        return this.remoteIterator();
    }

    PrimitiveIterator.OfInt remoteIterator() {
        this.intermediateOperations.add(BoxedIntOperation.getInstance());
        DistributedCacheStream stream = new DistributedCacheStream((AbstractCacheStream)this);
        Iterator<Integer> iterator = stream.iterator();
        return new IntegerIteratorToPrimitiveInteger(iterator);
    }

    @Override
    public Spliterator.OfInt spliterator() {
        return Spliterators.spliteratorUnknownSize(this.iterator(), 4096);
    }

    @Override
    public long count() {
        return this.performPublisherOperation(PublisherReducers.count(), PublisherReducers.add());
    }

    @Override
    public IntCacheStream sequentialDistribution() {
        this.parallelDistribution = false;
        return this;
    }

    @Override
    public IntCacheStream parallelDistribution() {
        this.parallelDistribution = true;
        return this;
    }

    @Override
    public IntCacheStream filterKeySegments(Set<Integer> segments) {
        return this.filterKeySegments(IntSets.from(segments));
    }

    @Override
    public IntCacheStream filterKeySegments(IntSet segments) {
        this.segmentsToFilter = segments;
        return this;
    }

    @Override
    public IntCacheStream filterKeys(Set<?> keys) {
        this.keysToFilter = keys;
        return this;
    }

    @Override
    public IntCacheStream distributedBatchSize(int batchSize) {
        this.distributedBatchSize = batchSize;
        return this;
    }

    @Override
    public IntCacheStream segmentCompletionListener(BaseCacheStream.SegmentCompletionListener listener) {
        this.segmentCompletionListener = this.segmentCompletionListener == null ? listener : DistributedIntCacheStream.composeWithExceptions(this.segmentCompletionListener, listener);
        return this;
    }

    @Override
    public IntCacheStream disableRehashAware() {
        this.rehashAware = false;
        return this;
    }

    @Override
    public IntCacheStream timeout(long timeout, TimeUnit unit) {
        if (timeout <= 0L) {
            throw new IllegalArgumentException("Timeout must be greater than 0");
        }
        this.timeout = timeout;
        this.timeoutUnit = unit;
        return this;
    }

    protected <R> DistributedCacheStream<Original, R> cacheStream() {
        return new DistributedCacheStream((AbstractCacheStream)this);
    }

    protected DistributedDoubleCacheStream<Original> doubleCacheStream() {
        return new DistributedDoubleCacheStream((AbstractCacheStream)this);
    }

    protected DistributedLongCacheStream<Original> longCacheStream() {
        return new DistributedLongCacheStream((AbstractCacheStream)this);
    }

    static class IntegerIteratorToPrimitiveInteger
    implements PrimitiveIterator.OfInt {
        private final Iterator<Integer> iterator;

        IntegerIteratorToPrimitiveInteger(Iterator<Integer> iterator) {
            this.iterator = iterator;
        }

        @Override
        public int nextInt() {
            return this.iterator.next();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }
    }
}

