/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.support;

import org.infinispan.persistence.spi.CacheWriter;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.MarshallableEntry;

public abstract class DelegatingCacheWriter<K, V>
implements CacheWriter<K, V> {
    protected final CacheWriter<K, V> actual;
    protected InitializationContext ctx;

    public DelegatingCacheWriter(CacheWriter<K, V> actual) {
        this.actual = actual;
    }

    @Override
    public void init(InitializationContext ctx) {
        this.ctx = ctx;
        if (this.actual instanceof DelegatingCacheWriter) {
            this.actual.init(ctx);
        }
    }

    public void start() {
        if (this.actual instanceof DelegatingCacheWriter) {
            this.actual.start();
        }
    }

    public void stop() {
        if (this.actual instanceof DelegatingCacheWriter) {
            this.actual.stop();
        }
    }

    @Override
    public void write(MarshallableEntry<? extends K, ? extends V> entry) {
        this.actual.write(entry);
    }

    @Override
    public boolean delete(Object key) {
        return this.actual.delete(key);
    }

    public CacheWriter undelegate() {
        CacheWriter<K, V> cl = this;
        while ((cl = cl.actual) instanceof DelegatingCacheWriter) {
        }
        return cl;
    }
}

