/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.topology;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.topology.AbstractCacheControlCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.remoting.transport.Address;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.PersistentUUID;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TopologyUpdateStableCommand
extends AbstractCacheControlCommand {
    private static final Log log = LogFactory.getLog(TopologyUpdateStableCommand.class);
    public static final byte COMMAND_ID = 97;
    private String cacheName;
    private ConsistentHash currentCH;
    private ConsistentHash pendingCH;
    private List<Address> actualMembers;
    private List<PersistentUUID> persistentUUIDs;
    private int rebalanceId;
    private int topologyId;
    private int viewId;
    private boolean topologyRestored;

    public TopologyUpdateStableCommand() {
        super((byte)97);
    }

    public TopologyUpdateStableCommand(String cacheName, Address origin, CacheTopology cacheTopology, int viewId) {
        super((byte)97, origin);
        this.cacheName = cacheName;
        this.topologyId = cacheTopology.getTopologyId();
        this.rebalanceId = cacheTopology.getRebalanceId();
        this.currentCH = cacheTopology.getCurrentCH();
        this.pendingCH = cacheTopology.getPendingCH();
        this.actualMembers = cacheTopology.getActualMembers();
        this.persistentUUIDs = cacheTopology.getMembersPersistentUUIDs();
        this.viewId = viewId;
        this.topologyRestored = cacheTopology.wasTopologyRestoredFromState();
    }

    @Override
    public CompletionStage<?> invokeAsync(GlobalComponentRegistry gcr) throws Throwable {
        if (!gcr.isLocalTopologyManagerRunning()) {
            log.debugf("Discard stable update because topology manager not running %s", this);
            return CompletableFutures.completedNull();
        }
        CacheTopology topology = new CacheTopology(this.topologyId, this.rebalanceId, this.topologyRestored, this.currentCH, this.pendingCH, CacheTopology.Phase.NO_REBALANCE, this.actualMembers, this.persistentUUIDs);
        return gcr.getLocalTopologyManager().handleStableTopologyUpdate(this.cacheName, topology, this.origin, this.viewId);
    }

    public ConsistentHash getCurrentCH() {
        return this.currentCH;
    }

    public ConsistentHash getPendingCH() {
        return this.pendingCH;
    }

    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        MarshallUtil.marshallString((String)this.cacheName, (ObjectOutput)output);
        output.writeObject(this.currentCH);
        output.writeObject(this.pendingCH);
        MarshallUtil.marshallCollection(this.actualMembers, (ObjectOutput)output);
        MarshallUtil.marshallCollection(this.persistentUUIDs, (ObjectOutput)output);
        output.writeInt(this.topologyId);
        output.writeInt(this.rebalanceId);
        output.writeInt(this.viewId);
        output.writeBoolean(this.topologyRestored);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.cacheName = MarshallUtil.unmarshallString((ObjectInput)input);
        this.currentCH = (ConsistentHash)input.readObject();
        this.pendingCH = (ConsistentHash)input.readObject();
        this.actualMembers = (List)MarshallUtil.unmarshallCollection((ObjectInput)input, ArrayList::new);
        this.persistentUUIDs = (List)MarshallUtil.unmarshallCollection((ObjectInput)input, ArrayList::new);
        this.topologyId = input.readInt();
        this.rebalanceId = input.readInt();
        this.viewId = input.readInt();
        this.topologyRestored = input.readBoolean();
    }

    public String toString() {
        return "TopologyUpdateStableCommand{cacheName='" + this.cacheName + "', origin=" + String.valueOf(this.origin) + ", currentCH=" + String.valueOf(this.currentCH) + ", pendingCH=" + String.valueOf(this.pendingCH) + ", actualMembers=" + String.valueOf(this.actualMembers) + ", persistentUUIDs=" + String.valueOf(this.persistentUUIDs) + ", rebalanceId=" + this.rebalanceId + ", topologyId=" + this.topologyId + ", viewId=" + this.viewId + "}";
    }
}

