/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.security.jaas;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import org.apache.activemq.artemis.spi.core.security.jaas.AuditLoginModule;
import org.apache.activemq.artemis.spi.core.security.jaas.CertificateCallback;
import org.apache.activemq.artemis.spi.core.security.jaas.UserPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalCertificateLoginModule
implements AuditLoginModule {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private CallbackHandler callbackHandler;
    private Subject subject;
    private String userName;
    private final Set<Principal> principals = new HashSet<Principal>();

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
    }

    @Override
    public boolean login() throws LoginException {
        Callback[] callbacks = new Callback[]{new CertificateCallback()};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.getMessage());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException("Unable to obtain client certificates: " + uce.getMessage());
        }
        Object[] certificates = ((CertificateCallback)callbacks[0]).getCertificates();
        if (certificates != null && certificates.length > 0 && certificates[0] != null) {
            this.userName = ((X509Certificate)certificates[0]).getSubjectDN().getName();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Certificates: {}, userName: {}", (Object)Arrays.toString(certificates), (Object)this.userName);
        }
        return this.userName != null;
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.userName != null) {
            this.principals.add(new UserPrincipal(this.userName));
            this.subject.getPrincipals().addAll(this.principals);
        }
        this.clear();
        logger.debug("commit");
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        this.registerFailureForAudit(this.userName);
        this.clear();
        logger.debug("abort");
        return true;
    }

    @Override
    public boolean logout() {
        this.subject.getPrincipals().removeAll(this.principals);
        this.principals.clear();
        logger.debug("logout");
        return true;
    }

    private void clear() {
        this.userName = null;
    }
}

