/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.validation;

import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.validation.ApplicableTo;
import com.xebialabs.deployit.plugin.api.validation.Rule;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import com.xebialabs.xlplatform.utils.Strings;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Target(value={ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
@Rule(clazz=Validator.class, type="applicationDependencies")
@ApplicableTo(value={PropertyKind.MAP_STRING_STRING})
public @interface ApplicationDependenciesFormat {
    public static final String DEFAULT_MESSAGE_WRONG_APPLICATION = "Application names should be used instead of paths: '%s'.";

    public static class Validator
    implements com.xebialabs.deployit.plugin.api.validation.Validator<Map<String, String>> {
        private String messageWrongApplication = "Application names should be used instead of paths: '%s'.";

        @Override
        public void validate(Map<String, String> value, ValidationContext context) {
            if (value == null) {
                return;
            }
            List<String> invalidApplicationNames = value.keySet().stream().filter(Validator::nameInvalid).collect(Collectors.toList());
            if (!invalidApplicationNames.isEmpty()) {
                context.error(String.format(this.messageWrongApplication, Strings.mkString(invalidApplicationNames, "', '")), new Object[0]);
            }
        }

        private static boolean nameInvalid(String name) {
            return name == null || name.contains("/");
        }
    }
}

