/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractMap<K, V>
implements Map<K, V> {
    protected transient Set<Map.Entry<K, V>> entrySet = null;
    protected transient Set<K> keySet = null;
    protected transient Collection<V> values = null;

    @Override
    public int hashCode() {
        int h = 0;
        Iterator i = this.entrySet().iterator();
        while (i.hasNext()) {
            h += i.next().hashCode();
        }
        return h;
    }

    protected static int hash(Object key) {
        int h = key.hashCode();
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    protected static boolean eq(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }

    protected static void assertKeyNotNull(Object key) {
        if (key == null) {
            throw new NullPointerException("Null keys are not supported!");
        }
    }

    protected static class SimpleEntry<K, V>
    implements Map.Entry<K, V> {
        private K key;
        private V value;

        SimpleEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        SimpleEntry(Map.Entry<K, V> entry) {
            this.key = entry.getKey();
            this.value = entry.getValue();
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V old = this.value;
            this.value = value;
            return old;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return AbstractMap.eq(this.key, e.getKey()) && AbstractMap.eq(this.value, e.getValue());
        }

        @Override
        public int hashCode() {
            return AbstractMap.hash(this.key) ^ (this.value == null ? 0 : AbstractMap.hash(this.value));
        }

        public String toString() {
            return String.valueOf(this.getKey()) + "=" + String.valueOf(this.getValue());
        }
    }
}

