/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.transport.netty;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.pekko.ConfigurationException;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.Address$;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.dispatch.Dispatchers;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.event.MarkerLoggingAdapter;
import org.apache.pekko.remote.RARP;
import org.apache.pekko.remote.RARP$;
import org.apache.pekko.remote.transport.AssociationHandle;
import org.apache.pekko.remote.transport.Transport;
import org.apache.pekko.remote.transport.netty.ClientHandler;
import org.apache.pekko.remote.transport.netty.NettyFutureBridge$;
import org.apache.pekko.remote.transport.netty.NettySSLSupport$;
import org.apache.pekko.remote.transport.netty.NettyTransport$;
import org.apache.pekko.remote.transport.netty.NettyTransportException;
import org.apache.pekko.remote.transport.netty.NettyTransportExceptionNoStack;
import org.apache.pekko.remote.transport.netty.NettyTransportSettings;
import org.apache.pekko.remote.transport.netty.SSLEngineProvider;
import org.apache.pekko.remote.transport.netty.TcpClientHandler;
import org.apache.pekko.remote.transport.netty.TcpServerHandler;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import org.jboss.netty.bootstrap.Bootstrap;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.bootstrap.ConnectionlessBootstrap;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.DefaultChannelPipeline;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioWorkerPool;
import org.jboss.netty.channel.socket.nio.WorkerPool;
import org.jboss.netty.handler.codec.frame.LengthFieldBasedFrameDecoder;
import org.jboss.netty.handler.codec.frame.LengthFieldPrepender;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\r=rA\u0002\u001e<\u0011\u0003itI\u0002\u0004Jw!\u0005QH\u0013\u0005\u0006#\u0006!\ta\u0015\u0005\b)\u0006\u0011\r\u0011\"\u0001V\u0011\u0019I\u0016\u0001)A\u0005-\")!,\u0001C\u00017\"9!/\u0001b\u0001\n\u0003\u0019\bBB@\u0002A\u0003%A\u000fC\u0004\u0002\u0002\u0005!\t!a\u0001\t\u000f\u0005\u0005\u0011\u0001\"\u0001\u0002R\u0019)\u0011j\u000f\u0001\u0002\\!Q\u0011Q\r\u0006\u0003\u0006\u0004%\t!a\u001a\t\u0015\u0005=$B!A!\u0002\u0013\tI\u0007\u0003\u0006\u0002r)\u0011)\u0019!C\u0001\u0003gB!\"a\u001f\u000b\u0005\u0003\u0005\u000b\u0011BA;\u0011\u0019\t&\u0002\"\u0001\u0002~!1\u0011K\u0003C\u0001\u0003\u000bC\u0011\"!)\u000b\u0005\u0004%\u0019!a)\t\u000f\u0005\u0015&\u0002)A\u0005E\"I\u0011\u0011\u0006\u0006C\u0002\u0013\u0005\u0013q\u0015\u0005\t\u0003SS\u0001\u0015!\u0003\u0002,!1\u00111\u0016\u0006\u0005BUC1\"!,\u000b\u0001\u0004\u0005\r\u0011\"\u0003\u00020\"Y\u0011\u0011\u0017\u0006A\u0002\u0003\u0007I\u0011BAZ\u0011-\tIL\u0003a\u0001\u0002\u0003\u0006K!a\u0003\t\u0017\u0005\r'\u00021AA\u0002\u0013%\u0011Q\u0019\u0005\f\u0003\u000fT\u0001\u0019!a\u0001\n\u0013\tI\r\u0003\u0006\u0002N*\u0001\r\u0011!Q!\n)D\u0011\"!5\u000b\u0005\u0004%I!a5\t\u0011\u0005\u0005(\u0002)A\u0005\u0003+D!\"a9\u000b\u0005\u0004%)aOAs\u0011!\u0011YA\u0003Q\u0001\u000e\u0005\u001d\bb\u0002B\u0007\u0015\u0011%!q\u0002\u0005\n\u0005/Q!\u0019!C\u0001\u00053A\u0001Ba\n\u000bA\u0003%!1\u0004\u0005\n\u0005SQ!\u0019!C\u0005\u0005WA\u0001Ba\r\u000bA\u0003%!Q\u0006\u0005\n\u0005kQ!\u0019!C\u0005\u0005WA\u0001Ba\u000e\u000bA\u0003%!Q\u0006\u0005\b\u0005sQA\u0011\u0002B\u001e\u0011%\u0011\u0019E\u0003b\u0001\n\u0013\u0011)\u0005\u0003\u0005\u0003\\)\u0001\u000b\u0011\u0002B$\u0011%\u0011iF\u0003b\u0001\n\u0013\u0011y\u0006\u0003\u0005\u0003r)\u0001\u000b\u0011\u0002B1\u0011\u001d\u0011\u0019H\u0003C\u0005\u0005kB\u0011B!%\u000b\u0005\u0004%IAa%\t\u0011\tm%\u0002)A\u0005\u0005+CqA!(\u000b\t\u0013\u0011y\nC\u0004\u0003&*!IAa*\t\u0013\t5'B1A\u0005\n\t=\u0007\u0002\u0003Bi\u0015\u0001\u0006IAa/\t\u000f\tM'\u0002\"\u0003\u0003V\"9!q\u001c\u0006\u0005B\t\u0005\bb\u0002Bt\u0015\u0011\u0005!\u0011\u001e\u0005\b\u0005sTA\u0011\tB~\u0011!\u0019)A\u0003C\u0001\u0003\u0006=\u0006bBB\u0004\u0015\u0011\u00053\u0011\u0002\u0005\b\u0007+QA\u0011IB\f\u00039qU\r\u001e;z)J\fgn\u001d9peRT!\u0001P\u001f\u0002\u000b9,G\u000f^=\u000b\u0005yz\u0014!\u0003;sC:\u001c\bo\u001c:u\u0015\t\u0001\u0015)\u0001\u0004sK6|G/\u001a\u0006\u0003\u0005\u000e\u000bQ\u0001]3lW>T!\u0001R#\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0015aA8sOB\u0011\u0001*A\u0007\u0002w\tqa*\u001a;usR\u0013\u0018M\\:q_J$8CA\u0001L!\tau*D\u0001N\u0015\u0005q\u0015!B:dC2\f\u0017B\u0001)N\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\u001a\u0001\u0001F\u0001H\u0003Y1%/Y7f\u0019\u0016tw\r\u001e5GS\u0016dG\rT3oORDW#\u0001,\u0011\u00051;\u0016B\u0001-N\u0005\rIe\u000e^\u0001\u0018\rJ\fW.\u001a'f]\u001e$\bNR5fY\u0012dUM\\4uQ\u0002\nQb\u001a:bG\u00164W\u000f\\\"m_N,GC\u0001/i)\ti\u0006\r\u0005\u0002M=&\u0011q,\u0014\u0002\u0005+:LG\u000fC\u0003b\u000b\u0001\u000f!-\u0001\u0002fGB\u00111MZ\u0007\u0002I*\u0011Q-T\u0001\u000bG>t7-\u001e:sK:$\u0018BA4e\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH\u000fC\u0003j\u000b\u0001\u0007!.A\u0004dQ\u0006tg.\u001a7\u0011\u0005-\u0004X\"\u00017\u000b\u0005%l'B\u0001\u001fo\u0015\tyW)A\u0003kE>\u001c8/\u0003\u0002rY\n91\t[1o]\u0016d\u0017aD;oSF,X-\u00133D_VtG/\u001a:\u0016\u0003Q\u0004\"!^?\u000e\u0003YT!a\u001e=\u0002\r\u0005$x.\\5d\u0015\t)\u0017P\u0003\u0002{w\u0006!Q\u000f^5m\u0015\u0005a\u0018\u0001\u00026bm\u0006L!A <\u0003\u001b\u0005#x.\\5d\u0013:$XmZ3s\u0003A)h.[9vK&#7i\\;oi\u0016\u0014\b%\u0001\rbI\u0012\u0014Xm]:Ge>l7k\\2lKR\fE\r\u001a:fgN$B\"!\u0002\u0002\u0018\u0005\u001d\u0012\u0011IA#\u0003\u0017\u0002R\u0001TA\u0004\u0003\u0017I1!!\u0003N\u0005\u0019y\u0005\u000f^5p]B!\u0011QBA\n\u001b\t\tyAC\u0002\u0002\u0012\u0005\u000bQ!Y2u_JLA!!\u0006\u0002\u0010\t9\u0011\t\u001a3sKN\u001c\bbBA\r\u0011\u0001\u0007\u00111D\u0001\u0005C\u0012$'\u000f\u0005\u0003\u0002\u001e\u0005\rRBAA\u0010\u0015\r\t\tc_\u0001\u0004]\u0016$\u0018\u0002BA\u0013\u0003?\u0011QbU8dW\u0016$\u0018\t\u001a3sKN\u001c\bbBA\u0015\u0011\u0001\u0007\u00111F\u0001\u0011g\u000eDW-\\3JI\u0016tG/\u001b4jKJ\u0004B!!\f\u0002<9!\u0011qFA\u001c!\r\t\t$T\u0007\u0003\u0003gQ1!!\u000eS\u0003\u0019a$o\\8u}%\u0019\u0011\u0011H'\u0002\rA\u0013X\rZ3g\u0013\u0011\ti$a\u0010\u0003\rM#(/\u001b8h\u0015\r\tI$\u0014\u0005\b\u0003\u0007B\u0001\u0019AA\u0016\u0003)\u0019\u0018p\u001d;f[:\u000bW.\u001a\u0005\b\u0003\u000fB\u0001\u0019AA%\u0003!Awn\u001d;OC6,\u0007#\u0002'\u0002\b\u0005-\u0002bBA'\u0011\u0001\u0007\u0011qJ\u0001\u0005a>\u0014H\u000f\u0005\u0003M\u0003\u000f1FCCA\u0003\u0003'\n)&a\u0016\u0002Z!9\u0011\u0011D\u0005A\u0002\u0005m\u0001bBA\u0015\u0013\u0001\u0007\u00111\u0006\u0005\b\u0003\u0007J\u0001\u0019AA\u0016\u0011\u001d\t9%\u0003a\u0001\u0003\u0013\u001aBAC&\u0002^A!\u0011qLA1\u001b\u0005i\u0014bAA2{\tIAK]1ogB|'\u000f^\u0001\tg\u0016$H/\u001b8hgV\u0011\u0011\u0011\u000e\t\u0004\u0011\u0006-\u0014bAA7w\t1b*\u001a;usR\u0013\u0018M\\:q_J$8+\u001a;uS:<7/A\u0005tKR$\u0018N\\4tA\u000511/_:uK6,\"!!\u001e\u0011\t\u00055\u0011qO\u0005\u0005\u0003s\nyAA\nFqR,g\u000eZ3e\u0003\u000e$xN]*zgR,W.A\u0004tsN$X-\u001c\u0011\u0015\r\u0005}\u0014\u0011QAB!\tA%\u0002C\u0004\u0002f=\u0001\r!!\u001b\t\u000f\u0005Et\u00021\u0001\u0002vQ1\u0011qPAD\u0003\u0013Cq!!\u001d\u0011\u0001\u0004\t)\bC\u0004\u0002\fB\u0001\r!!$\u0002\t\r|gN\u001a\t\u0005\u0003\u001f\u000bi*\u0004\u0002\u0002\u0012*!\u00111SAK\u0003\u0019\u0019wN\u001c4jO*!\u0011qSAM\u0003!!\u0018\u0010]3tC\u001a,'BAAN\u0003\r\u0019w.\\\u0005\u0005\u0003?\u000b\tJ\u0001\u0004D_:4\u0017nZ\u0001\u0011Kb,7-\u001e;j_:\u001cuN\u001c;fqR,\u0012AY\u0001\u0012Kb,7-\u001e;j_:\u001cuN\u001c;fqR\u0004SCAA\u0016\u0003E\u00198\r[3nK&#WM\u001c;jM&,'\u000fI\u0001\u0014[\u0006D\u0018.\\;n!\u0006LHn\\1e\u0005f$Xm]\u0001\bE>,h\u000e\u001a+p+\t\tY!A\u0006c_VtG\rV8`I\u0015\fHcA/\u00026\"I\u0011qW\f\u0002\u0002\u0003\u0007\u00111B\u0001\u0004q\u0012\n\u0014\u0001\u00032pk:$Gk\u001c\u0011)\u0007a\ti\fE\u0002M\u0003\u007fK1!!1N\u0005!1x\u000e\\1uS2,\u0017!D:feZ,'o\u00115b]:,G.F\u0001k\u0003E\u0019XM\u001d<fe\u000eC\u0017M\u001c8fY~#S-\u001d\u000b\u0004;\u0006-\u0007\u0002CA\\5\u0005\u0005\t\u0019\u00016\u0002\u001dM,'O^3s\u0007\"\fgN\\3mA!\u001a1$!0\u0002\u00071|w-\u0006\u0002\u0002VB!\u0011q[Ao\u001b\t\tINC\u0002\u0002\\\u0006\u000bQ!\u001a<f]RLA!a8\u0002Z\n!R*\u0019:lKJdunZ4j]\u001e\fE-\u00199uKJ\fA\u0001\\8hA\u0005\u0011R\u000f\u001a9D_:tWm\u0019;j_:$\u0016M\u00197f+\t\t9\u000f\u0005\u0005\u0002j\u0006-\u00181DAx\u001b\u0005A\u0018bAAwq\n\t2i\u001c8dkJ\u0014XM\u001c;ICNDW*\u00199\u0011\t\u0005E(Q\u0001\b\u0005\u0003g\u0014\tA\u0004\u0003\u0002v\u0006}h\u0002BA|\u0003{tA!!?\u0002|6\t1)\u0003\u0002C\u0007&\u0011\u0001)Q\u0005\u0003}}J1Aa\u0001>\u0003E\t5o]8dS\u0006$\u0018n\u001c8IC:$G.Z\u0005\u0005\u0005\u000f\u0011IAA\nIC:$G.Z#wK:$H*[:uK:,'OC\u0002\u0003\u0004u\n1#\u001e3q\u0007>tg.Z2uS>tG+\u00192mK\u0002\nQc\u0019:fCR,W\t_3dkR|'oU3sm&\u001cW\r\u0006\u0002\u0003\u0012A!\u0011\u0011\u001eB\n\u0013\r\u0011)\u0002\u001f\u0002\t\u000bb,7-\u001e;pe\u0006a1\r[1o]\u0016dwI]8vaV\u0011!1\u0004\t\u0005\u0005;\u0011\u0019#\u0004\u0002\u0003 )\u0019!\u0011\u00057\u0002\u000b\u001d\u0014x.\u001e9\n\t\t\u0015\"q\u0004\u0002\u0014\t\u00164\u0017-\u001e7u\u0007\"\fgN\\3m\u000fJ|W\u000f]\u0001\u000eG\"\fgN\\3m\u000fJ|W\u000f\u001d\u0011\u0002)\rd\u0017.\u001a8u\u0007\"\fgN\\3m\r\u0006\u001cGo\u001c:z+\t\u0011i\u0003E\u0002l\u0005_I1A!\rm\u00059\u0019\u0005.\u00198oK24\u0015m\u0019;pef\fQc\u00197jK:$8\t[1o]\u0016dg)Y2u_JL\b%\u0001\u000btKJ4XM]\"iC:tW\r\u001c$bGR|'/_\u0001\u0016g\u0016\u0014h/\u001a:DQ\u0006tg.\u001a7GC\u000e$xN]=!\u0003-qWm\u001e)ja\u0016d\u0017N\\3\u0016\u0005\tu\u0002cA6\u0003@%\u0019!\u0011\t7\u0003-\u0011+g-Y;mi\u000eC\u0017M\u001c8fYBK\u0007/\u001a7j]\u0016\f!$Y:t_\u000eL\u0017\r^5p]2K7\u000f^3oKJ\u0004&o\\7jg\u0016,\"Aa\u0012\u0011\u000b\r\u0014IE!\u0014\n\u0007\t-CMA\u0004Qe>l\u0017n]3\u0011\t\t=#Q\u000b\b\u0005\u0003g\u0014\t&C\u0002\u0003Tu\n\u0011\u0002\u0016:b]N\u0004xN\u001d;\n\t\t]#\u0011\f\u0002\u0019\u0003N\u001cxnY5bi&|g.\u0012<f]Rd\u0015n\u001d;f]\u0016\u0014(b\u0001B*{\u0005Y\u0012m]:pG&\fG/[8o\u0019&\u001cH/\u001a8feB\u0013x.\\5tK\u0002\n\u0011c]:m\u000b:<\u0017N\\3Qe>4\u0018\u000eZ3s+\t\u0011\t\u0007\u0005\u0004\u0003d\t\u001d$1N\u0007\u0003\u0005KR!A_!\n\t\t%$Q\r\u0002\n\u001fB$\u0018n\u001c8WC2\u00042\u0001\u0013B7\u0013\r\u0011yg\u000f\u0002\u0012'NcUI\\4j]\u0016\u0004&o\u001c<jI\u0016\u0014\u0018AE:tY\u0016sw-\u001b8f!J|g/\u001b3fe\u0002\n!b]:m\u0011\u0006tG\r\\3s)\u0011\u00119Ha\"\u0011\t\te$1Q\u0007\u0003\u0005wRAA! \u0003\u0000\u0005\u00191o\u001d7\u000b\u0007\t\u0005U.A\u0004iC:$G.\u001a:\n\t\t\u0015%1\u0010\u0002\u000b'Nd\u0007*\u00198eY\u0016\u0014\bb\u0002BEY\u0001\u0007!1R\u0001\tSN\u001cE.[3oiB\u0019AJ!$\n\u0007\t=UJA\u0004C_>dW-\u00198\u0002+M,'O^3s!&\u0004X\r\\5oK\u001a\u000b7\r^8ssV\u0011!Q\u0013\t\u0004W\n]\u0015b\u0001BMY\n12\t[1o]\u0016d\u0007+\u001b9fY&tWMR1di>\u0014\u00180\u0001\ftKJ4XM\u001d)ja\u0016d\u0017N\\3GC\u000e$xN]=!\u0003U\u0019G.[3oiBK\u0007/\u001a7j]\u00164\u0015m\u0019;pef$BA!&\u0003\"\"9!1U\u0018A\u0002\u0005-\u0011!\u0004:f[>$X-\u00113ee\u0016\u001c8/\u0001\btKR,\bOQ8piN$(/\u00199\u0016\t\t%&q\u0016\u000b\u0007\u0005W\u00139M!3\u0011\t\t5&q\u0016\u0007\u0001\t\u001d\u0011\t\f\rb\u0001\u0005g\u0013\u0011AQ\t\u0005\u0005k\u0013Y\fE\u0002M\u0005oK1A!/N\u0005\u001dqu\u000e\u001e5j]\u001e\u0004BA!0\u0003D6\u0011!q\u0018\u0006\u0004\u0005\u0003l\u0017!\u00032p_R\u001cHO]1q\u0013\u0011\u0011)Ma0\u0003\u0013\t{w\u000e^:ue\u0006\u0004\bb\u0002Baa\u0001\u0007!1\u0016\u0005\b\u0005\u0017\u0004\u0004\u0019\u0001BK\u0003=\u0001\u0018\u000e]3mS:,g)Y2u_JL\u0018\u0001E5oE>,h\u000e\u001a\"p_R\u001cHO]1q+\t\u0011Y,A\tj]\n|WO\u001c3C_>$8\u000f\u001e:ba\u0002\n\u0011c\\;uE>,h\u000e\u001a\"p_R\u001cHO]1q)\u0011\u00119N!8\u0011\t\tu&\u0011\\\u0005\u0005\u00057\u0014yLA\bDY&,g\u000e\u001e\"p_R\u001cHO]1q\u0011\u001d\u0011\u0019k\ra\u0001\u0003\u0017\t\u0001#[:SKN\u0004xN\\:jE2,gi\u001c:\u0015\t\t-%1\u001d\u0005\b\u0005K$\u0004\u0019AA\u0006\u0003\u001d\tG\r\u001a:fgN\fa#\u00193ee\u0016\u001c8\u000fV8T_\u000e\\W\r^!eIJ,7o\u001d\u000b\u0005\u0005W\u00149\u0010E\u0003d\u0005[\u0014\t0C\u0002\u0003p\u0012\u0014aAR;ukJ,\u0007\u0003BA\u000f\u0005gLAA!>\u0002 \t\t\u0012J\\3u'>\u001c7.\u001a;BI\u0012\u0014Xm]:\t\u000f\u0005eQ\u00071\u0001\u0002\f\u00051A.[:uK:,\"A!@\u0011\u000b\r\u0014iOa@\u0011\u000f1\u001b\t!a\u0003\u0003H%\u001911A'\u0003\rQ+\b\u000f\\33\u00031\u0011w.\u001e8e\u0003\u0012$'/Z:t\u0003%\t7o]8dS\u0006$X\r\u0006\u0003\u0004\f\rM\u0001#B2\u0003n\u000e5\u0001\u0003BA0\u0007\u001fI1a!\u0005>\u0005E\t5o]8dS\u0006$\u0018n\u001c8IC:$G.\u001a\u0005\b\u0005GC\u0004\u0019AA\u0006\u0003!\u0019\b.\u001e;e_^tGCAB\r!\u0015\u0019'Q\u001eBFQ-Q1QDB\u0012\u0007K\u0019Ica\u000b\u0011\u00071\u001by\"C\u0002\u0004\"5\u0013!\u0002Z3qe\u0016\u001c\u0017\r^3e\u0003\u001diWm]:bO\u0016\f#aa\n\u0002U\rc\u0017m]:jG\u0002\u0012X-\\8uS:<\u0007%[:!I\u0016\u0004(/Z2bi\u0016$G\u0006I;tK\u0002\n%\u000f^3ss\u0006)1/\u001b8dK\u0006\u00121QF\u0001\u000b\u0003.\\\u0017\r\t\u001a/m9\u0002\u0004")
public class NettyTransport
implements Transport {
    private final NettyTransportSettings settings;
    private final ExtendedActorSystem system;
    private final ExecutionContext executionContext;
    private final String schemeIdentifier;
    private volatile Address boundTo;
    private volatile Channel serverChannel;
    private final MarkerLoggingAdapter org$apache$pekko$remote$transport$netty$NettyTransport$$log;
    private final ConcurrentHashMap<SocketAddress, AssociationHandle.HandleEventListener> udpConnectionTable;
    private final DefaultChannelGroup channelGroup;
    private final ChannelFactory clientChannelFactory;
    private final ChannelFactory serverChannelFactory;
    private final Promise<Transport.AssociationEventListener> org$apache$pekko$remote$transport$netty$NettyTransport$$associationListenerPromise;
    private final SSLEngineProvider sslEngineProvider;
    private final ChannelPipelineFactory serverPipelineFactory;
    private final Bootstrap inboundBootstrap;

    public static Option<Address> addressFromSocketAddress(SocketAddress addr, String schemeIdentifier, String systemName, Option<String> hostName) {
        return NettyTransport$.MODULE$.addressFromSocketAddress(addr, schemeIdentifier, systemName, hostName);
    }

    public static Option<Address> addressFromSocketAddress(SocketAddress addr, String schemeIdentifier, String systemName, Option<String> hostName, Option<Object> port) {
        return NettyTransport$.MODULE$.addressFromSocketAddress(addr, schemeIdentifier, systemName, hostName, port);
    }

    public static AtomicInteger uniqueIdCounter() {
        return NettyTransport$.MODULE$.uniqueIdCounter();
    }

    public static void gracefulClose(Channel channel, ExecutionContext ec) {
        NettyTransport$.MODULE$.gracefulClose(channel, ec);
    }

    public static int FrameLengthFieldLength() {
        return NettyTransport$.MODULE$.FrameLengthFieldLength();
    }

    @Override
    public Future<Object> managementCommand(Object cmd) {
        return Transport.managementCommand$(this, cmd);
    }

    public NettyTransportSettings settings() {
        return this.settings;
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    @Override
    public String schemeIdentifier() {
        return this.schemeIdentifier;
    }

    @Override
    public int maximumPayloadBytes() {
        return this.settings().MaxFrameSize();
    }

    private Address boundTo() {
        return this.boundTo;
    }

    private void boundTo_$eq(Address x$1) {
        this.boundTo = x$1;
    }

    private Channel serverChannel() {
        return this.serverChannel;
    }

    private void serverChannel_$eq(Channel x$1) {
        this.serverChannel = x$1;
    }

    public MarkerLoggingAdapter org$apache$pekko$remote$transport$netty$NettyTransport$$log() {
        return this.org$apache$pekko$remote$transport$netty$NettyTransport$$log;
    }

    public final ConcurrentHashMap<SocketAddress, AssociationHandle.HandleEventListener> udpConnectionTable() {
        return this.udpConnectionTable;
    }

    private Executor createExecutorService() {
        Dispatchers dispatchers = this.system().dispatchers();
        return (Executor)this.settings().UseDispatcherForIo().map((Function1 & Serializable)id -> dispatchers.lookup(id)).getOrElse((Function0 & Serializable)() -> Executors.newCachedThreadPool(this.system().threadFactory()));
    }

    public DefaultChannelGroup channelGroup() {
        return this.channelGroup;
    }

    private ChannelFactory clientChannelFactory() {
        return this.clientChannelFactory;
    }

    private ChannelFactory serverChannelFactory() {
        return this.serverChannelFactory;
    }

    public DefaultChannelPipeline org$apache$pekko$remote$transport$netty$NettyTransport$$newPipeline() {
        DefaultChannelPipeline pipeline = new DefaultChannelPipeline();
        pipeline.addLast("FrameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(this.maximumPayloadBytes(), 0, NettyTransport$.MODULE$.FrameLengthFieldLength(), 0, NettyTransport$.MODULE$.FrameLengthFieldLength(), true));
        pipeline.addLast("FrameEncoder", (ChannelHandler)new LengthFieldPrepender(NettyTransport$.MODULE$.FrameLengthFieldLength()));
        return pipeline;
    }

    public Promise<Transport.AssociationEventListener> org$apache$pekko$remote$transport$netty$NettyTransport$$associationListenerPromise() {
        return this.org$apache$pekko$remote$transport$netty$NettyTransport$$associationListenerPromise;
    }

    private SSLEngineProvider sslEngineProvider() {
        return this.sslEngineProvider;
    }

    public SslHandler org$apache$pekko$remote$transport$netty$NettyTransport$$sslHandler(boolean isClient) {
        SSLEngineProvider sSLEngineProvider = this.sslEngineProvider();
        SSLEngineProvider sSLEngineProvider2 = (SSLEngineProvider)OptionVal.Some$.MODULE$.unapply((Object)sSLEngineProvider);
        if (!OptionVal$.MODULE$.isEmpty$extension((Object)sSLEngineProvider2)) {
            SSLEngineProvider sslProvider = (SSLEngineProvider)OptionVal$.MODULE$.get$extension((Object)sSLEngineProvider2);
            SslHandler handler = NettySSLSupport$.MODULE$.apply(sslProvider, isClient);
            handler.setCloseOnSSLException(true);
            return handler;
        }
        throw new IllegalStateException("Expected enable-ssl=on");
    }

    private ChannelPipelineFactory serverPipelineFactory() {
        return this.serverPipelineFactory;
    }

    private ChannelPipelineFactory clientPipelineFactory(Address remoteAddress) {
        return new ChannelPipelineFactory(this, remoteAddress){
            private final /* synthetic */ NettyTransport $outer;
            private final Address remoteAddress$1;

            public ChannelPipeline getPipeline() {
                DefaultChannelPipeline pipeline = this.$outer.org$apache$pekko$remote$transport$netty$NettyTransport$$newPipeline();
                if (this.$outer.settings().EnableSsl()) {
                    pipeline.addFirst("SslHandler", (ChannelHandler)this.$outer.org$apache$pekko$remote$transport$netty$NettyTransport$$sslHandler(true));
                }
                TcpClientHandler handler = new TcpClientHandler(this.$outer, this.remoteAddress$1, (LoggingAdapter)this.$outer.org$apache$pekko$remote$transport$netty$NettyTransport$$log());
                pipeline.addLast("clienthandler", (ChannelHandler)handler);
                return pipeline;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.remoteAddress$1 = remoteAddress$1;
            }
        };
    }

    private <B extends Bootstrap> B setupBootstrap(B bootstrap, ChannelPipelineFactory pipelineFactory) {
        bootstrap.setPipelineFactory(pipelineFactory);
        bootstrap.setOption("backlog", (Object)BoxesRunTime.boxToInteger((int)this.settings().Backlog()));
        bootstrap.setOption("child.tcpNoDelay", (Object)BoxesRunTime.boxToBoolean((boolean)this.settings().TcpNodelay()));
        bootstrap.setOption("child.keepAlive", (Object)BoxesRunTime.boxToBoolean((boolean)this.settings().TcpKeepalive()));
        bootstrap.setOption("reuseAddress", (Object)BoxesRunTime.boxToBoolean((boolean)this.settings().TcpReuseAddr()));
        this.settings().ReceiveBufferSize().foreach((Function1)(JFunction1.mcVI.sp & Serializable)sz -> bootstrap.setOption("receiveBufferSize", (Object)BoxesRunTime.boxToInteger((int)sz)));
        this.settings().SendBufferSize().foreach((Function1)(JFunction1.mcVI.sp & Serializable)sz -> bootstrap.setOption("sendBufferSize", (Object)BoxesRunTime.boxToInteger((int)sz)));
        this.settings().WriteBufferHighWaterMark().foreach((Function1)(JFunction1.mcVI.sp & Serializable)sz -> bootstrap.setOption("writeBufferHighWaterMark", (Object)BoxesRunTime.boxToInteger((int)sz)));
        this.settings().WriteBufferLowWaterMark().foreach((Function1)(JFunction1.mcVI.sp & Serializable)sz -> bootstrap.setOption("writeBufferLowWaterMark", (Object)BoxesRunTime.boxToInteger((int)sz)));
        return bootstrap;
    }

    private Bootstrap inboundBootstrap() {
        return this.inboundBootstrap;
    }

    private ClientBootstrap outboundBootstrap(Address remoteAddress) {
        ClientBootstrap bootstrap = this.setupBootstrap(new ClientBootstrap(this.clientChannelFactory()), this.clientPipelineFactory(remoteAddress));
        bootstrap.setOption("connectTimeoutMillis", (Object)BoxesRunTime.boxToLong((long)this.settings().ConnectionTimeout().toMillis()));
        bootstrap.setOption("tcpNoDelay", (Object)BoxesRunTime.boxToBoolean((boolean)this.settings().TcpNodelay()));
        bootstrap.setOption("keepAlive", (Object)BoxesRunTime.boxToBoolean((boolean)this.settings().TcpKeepalive()));
        this.settings().ReceiveBufferSize().foreach((Function1)(JFunction1.mcVI.sp & Serializable)sz -> bootstrap.setOption("receiveBufferSize", (Object)BoxesRunTime.boxToInteger((int)sz)));
        this.settings().SendBufferSize().foreach((Function1)(JFunction1.mcVI.sp & Serializable)sz -> bootstrap.setOption("sendBufferSize", (Object)BoxesRunTime.boxToInteger((int)sz)));
        this.settings().WriteBufferHighWaterMark().foreach((Function1)(JFunction1.mcVI.sp & Serializable)sz -> bootstrap.setOption("writeBufferHighWaterMark", (Object)BoxesRunTime.boxToInteger((int)sz)));
        this.settings().WriteBufferLowWaterMark().foreach((Function1)(JFunction1.mcVI.sp & Serializable)sz -> bootstrap.setOption("writeBufferLowWaterMark", (Object)BoxesRunTime.boxToInteger((int)sz)));
        return bootstrap;
    }

    @Override
    public boolean isResponsibleFor(Address address) {
        return true;
    }

    public Future<InetSocketAddress> addressToSocketAddress(Address addr) {
        Address address = addr;
        if (address != null) {
            Option option = address.host();
            Option option2 = address.port();
            if (option instanceof Some) {
                Some some = (Some)option;
                String host = (String)some.value();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    int port = BoxesRunTime.unboxToInt((Object)some2.value());
                    return Future$.MODULE$.apply((Function0 & Serializable)() -> (InetSocketAddress)package$.MODULE$.blocking((Function0 & Serializable)() -> new InetSocketAddress(InetAddress.getByName(host), port)), this.executionContext());
                }
            }
        }
        return Future$.MODULE$.failed((Throwable)new IllegalArgumentException(new StringBuilder(53).append("Address [").append(addr).append("] does not contain host or port information.").toString()));
    }

    @Override
    public Future<Tuple2<Address, Promise<Transport.AssociationEventListener>>> listen() {
        int bindPort = this.settings().BindPortSelector();
        return this.addressToSocketAddress(Address$.MODULE$.apply("", "", this.settings().BindHostname(), bindPort)).map((Function1 & Serializable)address -> {
            Tuple2 tuple2;
            try {
                Address address2;
                Channel channel;
                Bootstrap bootstrap = this.inboundBootstrap();
                if (bootstrap instanceof ServerBootstrap) {
                    ServerBootstrap serverBootstrap = (ServerBootstrap)bootstrap;
                    channel = serverBootstrap.bind((SocketAddress)address);
                } else if (bootstrap instanceof ConnectionlessBootstrap) {
                    ConnectionlessBootstrap connectionlessBootstrap = (ConnectionlessBootstrap)bootstrap;
                    channel = connectionlessBootstrap.bind((SocketAddress)address);
                } else {
                    throw new IllegalStateException();
                }
                Channel newServerChannel = channel;
                newServerChannel.setReadable(false);
                this.channelGroup().add(newServerChannel);
                this.serverChannel_$eq(newServerChannel);
                None$ port = this.settings().PortSelector() == 0 ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)this.settings().PortSelector()));
                Option<Address> option = NettyTransport$.MODULE$.addressFromSocketAddress(newServerChannel.getLocalAddress(), this.schemeIdentifier(), this.system().name(), (Option<String>)new Some((Object)this.settings().Hostname()), (Option<Object>)port);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    address2 = (Address)some.value();
                    Option<Address> option2 = NettyTransport$.MODULE$.addressFromSocketAddress(newServerChannel.getLocalAddress(), this.schemeIdentifier(), this.system().name(), (Option<String>)None$.MODULE$, (Option<Object>)None$.MODULE$);
                    if (!(option2 instanceof Some)) {
                        if (None$.MODULE$.equals(option2)) {
                            throw new NettyTransportException(new StringBuilder(29).append("Unknown local address type [").append(newServerChannel.getLocalAddress().getClass().getName()).append("]").toString());
                        }
                        throw new MatchError(option2);
                    }
                    Some some2 = (Some)option2;
                    Address address3 = (Address)some2.value();
                    this.boundTo_$eq(address3);
                } else {
                    if (None$.MODULE$.equals(option)) {
                        throw new NettyTransportException(new StringBuilder(29).append("Unknown local address type [").append(newServerChannel.getLocalAddress().getClass().getName()).append("]").toString());
                    }
                    throw new MatchError(option);
                }
                this.org$apache$pekko$remote$transport$netty$NettyTransport$$associationListenerPromise().future().foreach((Function1 & Serializable)x$6 -> newServerChannel.setReadable(true), this.executionContext());
                tuple2 = new Tuple2((Object)address2, this.org$apache$pekko$remote$transport$netty$NettyTransport$$associationListenerPromise());
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (NonFatal$.MODULE$.apply(throwable2)) {
                    block15: {
                        BoxedUnit boxedUnit;
                        this.org$apache$pekko$remote$transport$netty$NettyTransport$$log().error("failed to bind to {}, shutting down Netty transport", address);
                        try {
                            boxedUnit = this.shutdown();
                        }
                        catch (Throwable throwable3) {
                            Option option;
                            Throwable throwable4 = throwable3;
                            if (throwable4 != null && !(option = NonFatal$.MODULE$.unapply(throwable4)).isEmpty()) {
                                boxedUnit = BoxedUnit.UNIT;
                                break block15;
                            }
                            throw throwable3;
                        }
                    }
                    throw throwable2;
                }
                throw throwable;
            }
            return tuple2;
        }, this.executionContext());
    }

    public Address boundAddress() {
        return this.boundTo();
    }

    @Override
    public Future<AssociationHandle> associate(Address remoteAddress) {
        if (!this.serverChannel().isBound()) {
            return Future$.MODULE$.failed((Throwable)new NettyTransportException("Transport is not bound"));
        }
        ClientBootstrap bootstrap = this.outboundBootstrap(remoteAddress);
        return this.addressToSocketAddress(remoteAddress).flatMap((Function1 & Serializable)socketAddress -> NettyFutureBridge$.MODULE$.apply(bootstrap.connect((SocketAddress)socketAddress)).map((Function1 & Serializable)channel -> {
            Object object = this.settings().EnableSsl() ? package$.MODULE$.blocking((Function0 & Serializable)() -> ((SslHandler)channel.getPipeline().get(SslHandler.class)).handshake().awaitUninterruptibly()) : BoxedUnit.UNIT;
            channel.setReadable(false);
            return channel;
        }, this.executionContext()).flatMap((Function1 & Serializable)readyChannel -> ((ClientHandler)readyChannel.getPipeline().get(ClientHandler.class)).statusFuture().map((Function1 & Serializable)handle -> handle, this.executionContext()), this.executionContext()), this.executionContext()).recover((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof CancellationException) {
                    throw new NettyTransportExceptionNoStack("Connection was cancelled");
                }
                if (NonFatal$.MODULE$.apply(A1)) {
                    String msg = A1.getCause() == null ? A1.getMessage() : (A1.getCause().getCause() == null ? new StringBuilder(13).append(A1.getMessage()).append(", caused by: ").append(A1.getCause()).toString() : new StringBuilder(26).append(A1.getMessage()).append(", caused by: ").append(A1.getCause()).append(", caused by: ").append(A1.getCause().getCause()).toString());
                    throw new NettyTransportExceptionNoStack(new StringBuilder(2).append(A1.getClass().getName()).append(": ").append(msg).toString(), A1.getCause());
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                if (throwable instanceof CancellationException) {
                    return true;
                }
                return NonFatal$.MODULE$.apply(throwable);
            }
        }, this.executionContext());
    }

    @Override
    public Future<Object> shutdown() {
        return this.always$2(this.channelGroup().unbind()).flatMap((Function1 & Serializable)unbindStatus -> NettyTransport.$anonfun$shutdown$2(this, BoxesRunTime.unboxToBoolean((Object)unbindStatus)), this.executionContext());
    }

    public static final /* synthetic */ boolean $anonfun$shutdown$1(ChannelGroup x$7) {
        return true;
    }

    private final Future always$2(ChannelGroupFuture c) {
        return NettyFutureBridge$.MODULE$.apply(c).map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)NettyTransport.$anonfun$shutdown$1(x$7)), this.executionContext()).recover((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                return (B1)BoxesRunTime.boxToBoolean((boolean)false);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return true;
            }
        }, this.executionContext());
    }

    public static final /* synthetic */ boolean $anonfun$shutdown$5(NettyTransport $this, boolean lastWriteStatus$1, boolean unbindStatus$1, boolean disconnectStatus$1, boolean closeStatus) {
        if ($this.settings().UseDispatcherForIo().isDefined()) {
            $this.clientChannelFactory().shutdown();
            $this.serverChannelFactory().shutdown();
        } else {
            $this.clientChannelFactory().releaseExternalResources();
            $this.serverChannelFactory().releaseExternalResources();
        }
        return lastWriteStatus$1 && unbindStatus$1 && disconnectStatus$1 && closeStatus;
    }

    public static final /* synthetic */ Future $anonfun$shutdown$4(NettyTransport $this, boolean lastWriteStatus$1, boolean unbindStatus$1, boolean disconnectStatus) {
        return $this.always$2($this.channelGroup().close()).map((Function1 & Serializable)closeStatus -> BoxesRunTime.boxToBoolean((boolean)NettyTransport.$anonfun$shutdown$5($this, lastWriteStatus$1, unbindStatus$1, disconnectStatus, BoxesRunTime.unboxToBoolean((Object)closeStatus))), $this.executionContext());
    }

    public static final /* synthetic */ Future $anonfun$shutdown$3(NettyTransport $this, boolean unbindStatus$1, boolean lastWriteStatus) {
        return $this.always$2($this.channelGroup().disconnect()).flatMap((Function1 & Serializable)disconnectStatus -> NettyTransport.$anonfun$shutdown$4($this, lastWriteStatus, unbindStatus$1, BoxesRunTime.unboxToBoolean((Object)disconnectStatus)), $this.executionContext());
    }

    public static final /* synthetic */ Future $anonfun$shutdown$2(NettyTransport $this, boolean unbindStatus) {
        return $this.always$2($this.channelGroup().write((Object)ChannelBuffers.buffer((int)0))).flatMap((Function1 & Serializable)lastWriteStatus -> NettyTransport.$anonfun$shutdown$3($this, unbindStatus, BoxesRunTime.unboxToBoolean((Object)lastWriteStatus)), $this.executionContext());
    }

    public NettyTransport(NettyTransportSettings settings, ExtendedActorSystem system) {
        SSLEngineProvider sSLEngineProvider;
        this.settings = settings;
        this.system = system;
        Transport.$init$(this);
        Dispatchers dispatchers = system.dispatchers();
        this.executionContext = (ExecutionContext)settings.UseDispatcherForIo().orElse((Function0 & Serializable)() -> {
            String string = ((RARP)RARP$.MODULE$.apply((ActorSystem)this.system())).provider().remoteSettings().Dispatcher();
            switch (string == null ? 0 : string.hashCode()) {
                case 0: {
                    if (!"".equals(string)) break;
                    return None$.MODULE$;
                }
            }
            return new Some((Object)string);
        }).map((Function1 & Serializable)id -> dispatchers.lookup(id)).getOrElse((Function0 & Serializable)() -> this.system().dispatcher());
        this.schemeIdentifier = new StringBuilder(3).append(settings.EnableSsl() ? "ssl." : "").append("tcp").toString();
        this.org$apache$pekko$remote$transport$netty$NettyTransport$$log = Logging$.MODULE$.withMarker((ActorSystem)system, NettyTransport.class, LogSource$.MODULE$.fromAnyClass());
        this.udpConnectionTable = new ConcurrentHashMap();
        this.channelGroup = new DefaultChannelGroup(new StringBuilder(42).append("pekko-netty-transport-driver-channelgroup-").append(NettyTransport$.MODULE$.uniqueIdCounter().getAndIncrement()).toString());
        Executor boss = this.createExecutorService();
        Executor worker = this.createExecutorService();
        this.clientChannelFactory = new NioClientSocketChannelFactory(boss, 1, (WorkerPool)new NioWorkerPool(worker, settings.ClientSocketWorkerPoolSize()), (Timer)new HashedWheelTimer(system.threadFactory()));
        Executor boss2 = this.createExecutorService();
        Executor worker2 = this.createExecutorService();
        this.serverChannelFactory = new NioServerSocketChannelFactory(boss2, worker2, settings.ServerSocketWorkerPoolSize());
        this.org$apache$pekko$remote$transport$netty$NettyTransport$$associationListenerPromise = Promise$.MODULE$.apply();
        if (settings.EnableSsl()) {
            sSLEngineProvider = (SSLEngineProvider)OptionVal.Some$.MODULE$.apply(system.dynamicAccess().createInstanceFor(settings.SSLEngineProviderClassName(), (Seq)new .colon.colon((Object)new Tuple2(ActorSystem.class, (Object)system), (List)Nil$.MODULE$), ClassTag$.MODULE$.apply(SSLEngineProvider.class)).recover((PartialFunction)new Serializable(this){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ NettyTransport $outer;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    throw new ConfigurationException(new StringBuilder(37).append("Could not create SSLEngineProvider [").append(this.$outer.settings().SSLEngineProviderClassName()).append("]").toString(), A1);
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    return true;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }).get());
        } else {
            OptionVal$.MODULE$.None();
            sSLEngineProvider = null;
        }
        this.sslEngineProvider = sSLEngineProvider;
        this.serverPipelineFactory = new ChannelPipelineFactory(this){
            private final /* synthetic */ NettyTransport $outer;

            public ChannelPipeline getPipeline() {
                DefaultChannelPipeline pipeline = this.$outer.org$apache$pekko$remote$transport$netty$NettyTransport$$newPipeline();
                if (this.$outer.settings().EnableSsl()) {
                    pipeline.addFirst("SslHandler", (ChannelHandler)this.$outer.org$apache$pekko$remote$transport$netty$NettyTransport$$sslHandler(false));
                }
                TcpServerHandler handler = new TcpServerHandler(this.$outer, (Future<Transport.AssociationEventListener>)this.$outer.org$apache$pekko$remote$transport$netty$NettyTransport$$associationListenerPromise().future(), (LoggingAdapter)this.$outer.org$apache$pekko$remote$transport$netty$NettyTransport$$log());
                pipeline.addLast("ServerHandler", (ChannelHandler)handler);
                return pipeline;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.inboundBootstrap = this.setupBootstrap(new ServerBootstrap(this.serverChannelFactory()), this.serverPipelineFactory());
    }

    public NettyTransport(ExtendedActorSystem system, Config conf) {
        this(new NettyTransportSettings(conf), system);
    }
}

