/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.List;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.function.FunctionKind;
import org.hibernate.query.sqm.produce.function.ArgumentTypesValidator;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.type.BasicType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.spi.TypeConfiguration;

public class EveryAnyEmulation
extends AbstractSqmSelfRenderingFunctionDescriptor {
    private final boolean every;
    private final QueryLiteral<Boolean> trueLiteral;
    private final QueryLiteral<Boolean> falseLiteral;

    public EveryAnyEmulation(TypeConfiguration typeConfiguration, boolean every, boolean supportsPredicateAsExpression) {
        super(every ? "every" : "any", FunctionKind.AGGREGATE, new ArgumentTypesValidator(StandardArgumentsValidators.exactly(1), FunctionParameterType.BOOLEAN), StandardFunctionReturnTypeResolvers.invariant(typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.BOOLEAN)), StandardFunctionArgumentTypeResolvers.invariant(typeConfiguration, FunctionParameterType.BOOLEAN));
        this.every = every;
        if (supportsPredicateAsExpression) {
            this.trueLiteral = null;
            this.falseLiteral = null;
        } else {
            BasicType<Boolean> booleanBasicType = typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.BOOLEAN);
            this.trueLiteral = new QueryLiteral<Boolean>(true, booleanBasicType);
            this.falseLiteral = new QueryLiteral<Boolean>(false, booleanBasicType);
        }
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, Predicate filter, SqlAstTranslator<?> walker) {
        if (this.trueLiteral != null) {
            sqlAppender.appendSql("case when ");
        }
        sqlAppender.appendSql("(sum(case when ");
        if (filter != null) {
            walker.getCurrentClauseStack().push(Clause.WHERE);
            filter.accept(walker);
            walker.getCurrentClauseStack().pop();
            sqlAppender.appendSql(" then case when ");
            sqlAstArguments.get(0).accept(walker);
            if (this.every) {
                sqlAppender.appendSql(" then 0 else 1 end else null end)=0)");
            } else {
                sqlAppender.appendSql(" then 1 else 0 end else null end)>0)");
            }
        } else {
            sqlAstArguments.get(0).accept(walker);
            if (this.every) {
                sqlAppender.appendSql(" then 0 else 1 end)=0)");
            } else {
                sqlAppender.appendSql(" then 1 else 0 end)>0)");
            }
        }
        if (this.trueLiteral != null) {
            sqlAppender.appendSql(" then ");
            walker.visitQueryLiteral(this.trueLiteral);
            sqlAppender.appendSql(" else ");
            walker.visitQueryLiteral(this.falseLiteral);
            sqlAppender.appendSql(" end");
        }
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, SqlAstTranslator<?> walker) {
        this.render(sqlAppender, sqlAstArguments, null, walker);
    }
}

