/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer.reactive;

import org.springframework.http.HttpMethod;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;

public class LoadBalancerRetryContext {
    private final ClientRequest request;
    private ClientResponse clientResponse;
    private Integer retriesSameServiceInstance = 0;
    private Integer retriesNextServiceInstance = 0;

    protected LoadBalancerRetryContext(ClientRequest request) {
        this.request = request;
    }

    protected ClientRequest getRequest() {
        return this.request;
    }

    protected ClientResponse getClientResponse() {
        return this.clientResponse;
    }

    protected void setClientResponse(ClientResponse clientResponse) {
        this.clientResponse = clientResponse;
    }

    protected Integer getRetriesSameServiceInstance() {
        return this.retriesSameServiceInstance;
    }

    protected void incrementRetriesSameServiceInstance() {
        Integer n = this.retriesSameServiceInstance;
        this.retriesSameServiceInstance = this.retriesSameServiceInstance + 1;
    }

    protected void resetRetriesSameServiceInstance() {
        this.retriesSameServiceInstance = 0;
    }

    protected Integer getRetriesNextServiceInstance() {
        return this.retriesNextServiceInstance;
    }

    protected void incrementRetriesNextServiceInstance() {
        Integer n = this.retriesNextServiceInstance;
        this.retriesNextServiceInstance = this.retriesNextServiceInstance + 1;
    }

    protected Integer getResponseStatusCode() {
        return this.clientResponse.statusCode().value();
    }

    protected HttpMethod getRequestMethod() {
        return this.request.method();
    }
}

