/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.mssmb2;

import java.util.Set;

public enum SMB2Dialect {
    UNKNOWN(0),
    SMB_2_0_2(514),
    SMB_2_1(528),
    SMB_2XX(767),
    SMB_3_0(768),
    SMB_3_0_2(770),
    SMB_3_1_1(785);

    private int value;

    private SMB2Dialect(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public boolean isSmb3x() {
        return this == SMB_3_0 || this == SMB_3_0_2 || this == SMB_3_1_1;
    }

    public static boolean supportsSmb3x(Set<SMB2Dialect> dialects) {
        for (SMB2Dialect dialect : dialects) {
            if (!dialect.isSmb3x()) continue;
            return true;
        }
        return false;
    }

    public static SMB2Dialect lookup(int v) {
        for (SMB2Dialect smb2Dialect : SMB2Dialect.values()) {
            if (smb2Dialect.getValue() != v) continue;
            return smb2Dialect;
        }
        throw new IllegalStateException("Unknown SMB2 Dialect: " + v);
    }
}

