/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import com.querydsl.core.NonUniqueResultException;
import com.querydsl.core.types.ConstantImpl;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.NullExpression;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.jpa.JPQLQuery;
import com.querydsl.jpa.impl.AbstractJPAQuery;
import jakarta.persistence.EntityManager;
import jakarta.persistence.LockModeType;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.data.domain.KeysetScrollPosition;
import org.springframework.data.domain.OffsetScrollPosition;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.KeysetScrollDelegate;
import org.springframework.data.jpa.repository.query.KeysetScrollSpecification;
import org.springframework.data.jpa.repository.support.CrudMethodMetadata;
import org.springframework.data.jpa.repository.support.DefaultQueryHints;
import org.springframework.data.jpa.repository.support.FetchableFluentQueryByPredicate;
import org.springframework.data.jpa.repository.support.FluentQuerySupport;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.JpaRepositoryConfigurationAware;
import org.springframework.data.jpa.repository.support.QueryHints;
import org.springframework.data.jpa.repository.support.Querydsl;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.data.querydsl.EntityPathResolver;
import org.springframework.data.querydsl.QSort;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.repository.query.FluentQuery;
import org.springframework.data.support.PageableExecutionUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class QuerydslJpaPredicateExecutor<T>
implements QuerydslPredicateExecutor<T>,
JpaRepositoryConfigurationAware {
    private final JpaEntityInformation<T, ?> entityInformation;
    private final EntityPath<T> path;
    private final Querydsl querydsl;
    private final QuerydslQueryStrategy scrollQueryAdapter;
    private final EntityManager entityManager;
    @Nullable
    private CrudMethodMetadata metadata;
    @Nullable
    private ProjectionFactory projectionFactory;

    public QuerydslJpaPredicateExecutor(JpaEntityInformation<T, ?> entityInformation, EntityManager entityManager, EntityPathResolver resolver, @Nullable CrudMethodMetadata metadata) {
        this.entityInformation = entityInformation;
        this.metadata = metadata;
        this.path = resolver.createPath(entityInformation.getJavaType());
        this.querydsl = new Querydsl(entityManager, new PathBuilder(this.path.getType(), this.path.getMetadata()));
        this.entityManager = entityManager;
        this.scrollQueryAdapter = new QuerydslQueryStrategy();
    }

    @Override
    public void setRepositoryMethodMetadata(CrudMethodMetadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public void setProjectionFactory(ProjectionFactory projectionFactory) {
        this.projectionFactory = projectionFactory;
    }

    public Optional<T> findOne(Predicate predicate) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null");
        try {
            return Optional.ofNullable(((JPQLQuery)this.createQuery(predicate).select(this.path).limit(2L)).fetchOne());
        }
        catch (NonUniqueResultException ex) {
            throw new IncorrectResultSizeDataAccessException(ex.getMessage(), 1, (Throwable)ex);
        }
    }

    public List<T> findAll(Predicate predicate) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null");
        return this.createQuery(predicate).select(this.path).fetch();
    }

    public List<T> findAll(Predicate predicate, OrderSpecifier<?> ... orders) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null");
        Assert.notNull(orders, (String)"Order specifiers must not be null");
        return this.executeSorted(this.createQuery(predicate).select(this.path), orders);
    }

    public List<T> findAll(Predicate predicate, Sort sort) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null");
        Assert.notNull((Object)sort, (String)"Sort must not be null");
        return this.executeSorted(this.createQuery(predicate).select(this.path), sort);
    }

    public List<T> findAll(OrderSpecifier<?> ... orders) {
        Assert.notNull(orders, (String)"Order specifiers must not be null");
        return this.executeSorted(this.createQuery(new Predicate[0]).select(this.path), orders);
    }

    public Page<T> findAll(Predicate predicate, Pageable pageable) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null");
        Assert.notNull((Object)pageable, (String)"Pageable must not be null");
        JPQLQuery<?> countQuery = this.createCountQuery(predicate);
        JPQLQuery query = this.querydsl.applyPagination(pageable, this.createQuery(predicate).select(this.path));
        return PageableExecutionUtils.getPage((List)query.fetch(), (Pageable)pageable, () -> countQuery.fetchCount());
    }

    public <S extends T, R> R findBy(Predicate predicate, Function<FluentQuery.FetchableFluentQuery<S>, R> queryFunction) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null");
        Assert.notNull(queryFunction, (String)"Query function must not be null");
        Function<Sort, AbstractJPAQuery<?, ?>> finder = sort -> {
            AbstractJPAQuery select = (AbstractJPAQuery)this.createQuery(predicate).select(this.path);
            if (sort != null) {
                select = (AbstractJPAQuery)this.querydsl.applySorting((Sort)sort, select);
            }
            return select;
        };
        FluentQuerySupport.ScrollQueryFactory scroll = (sort, scrollPosition) -> {
            OffsetScrollPosition offset;
            KeysetScrollPosition keyset;
            KeysetScrollDelegate delegate;
            BooleanExpression keysetPredicate;
            Predicate predicateToUse = predicate;
            if (scrollPosition instanceof KeysetScrollPosition && (keysetPredicate = (BooleanExpression)(delegate = KeysetScrollDelegate.of((keyset = (KeysetScrollPosition)scrollPosition).getDirection())).createPredicate(keyset, sort = KeysetScrollSpecification.createSort(keyset, sort, this.entityInformation), this.scrollQueryAdapter)) != null) {
                BooleanExpression booleanExpression;
                if (predicate instanceof BooleanExpression) {
                    BooleanExpression be = (BooleanExpression)predicate;
                    booleanExpression = be.and((Predicate)keysetPredicate);
                } else {
                    booleanExpression = keysetPredicate.and(predicate);
                }
                predicateToUse = booleanExpression;
            }
            AbstractJPAQuery select = (AbstractJPAQuery)this.createQuery(predicateToUse).select(this.path);
            select = (AbstractJPAQuery)this.querydsl.applySorting(sort, select);
            if (scrollPosition instanceof OffsetScrollPosition && !(offset = (OffsetScrollPosition)scrollPosition).isInitial()) {
                select.offset(offset.getOffset() + 1L);
            }
            return select.createQuery();
        };
        BiFunction<Sort, Pageable, AbstractJPAQuery<?, ?>> pagedFinder = (sort, pageable) -> {
            AbstractJPAQuery select = (AbstractJPAQuery)finder.apply((Sort)sort);
            if (pageable.isPaged()) {
                select = (AbstractJPAQuery)this.querydsl.applyPagination((Pageable)pageable, select);
            }
            return select;
        };
        FetchableFluentQueryByPredicate fluentQuery = new FetchableFluentQueryByPredicate(predicate, this.entityInformation.getJavaType(), finder, new FetchableFluentQueryByPredicate.PredicateScrollDelegate<T>(scroll, this.entityInformation), pagedFinder, this::count, this::exists, this.entityManager, this.getProjectionFactory());
        return queryFunction.apply(fluentQuery);
    }

    public long count(Predicate predicate) {
        return this.createQuery(predicate).fetchCount();
    }

    public boolean exists(Predicate predicate) {
        return this.createQuery(predicate).select((Expression)Expressions.ONE).fetchFirst() != null;
    }

    protected AbstractJPAQuery<?, ?> createQuery(Predicate ... predicate) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null");
        AbstractJPAQuery query = this.doCreateQuery(this.getQueryHints().withFetchGraphs(this.entityManager), predicate);
        CrudMethodMetadata metadata = this.getRepositoryMethodMetadata();
        if (metadata == null) {
            return query;
        }
        LockModeType type = metadata.getLockModeType();
        return type == null ? query : query.setLockMode(type);
    }

    protected JPQLQuery<?> createCountQuery(Predicate ... predicate) {
        return this.doCreateQuery(this.getQueryHintsForCount(), predicate);
    }

    @Nullable
    private CrudMethodMetadata getRepositoryMethodMetadata() {
        return this.metadata;
    }

    private QueryHints getQueryHints() {
        return this.metadata == null ? QueryHints.NoHints.INSTANCE : DefaultQueryHints.of(this.entityInformation, this.metadata);
    }

    private QueryHints getQueryHintsForCount() {
        return this.metadata == null ? QueryHints.NoHints.INSTANCE : DefaultQueryHints.of(this.entityInformation, this.metadata).forCounts();
    }

    private AbstractJPAQuery<?, ?> doCreateQuery(QueryHints hints, Predicate ... predicate) {
        AbstractJPAQuery query = this.querydsl.createQuery(this.path);
        if (predicate != null) {
            query = (AbstractJPAQuery)query.where(predicate);
        }
        hints.forEach((arg_0, arg_1) -> ((AbstractJPAQuery)query).setHint(arg_0, arg_1));
        return query;
    }

    private List<T> executeSorted(JPQLQuery<T> query, OrderSpecifier<?> ... orders) {
        return this.executeSorted(query, (Sort)new QSort(orders));
    }

    private List<T> executeSorted(JPQLQuery<T> query, Sort sort) {
        return this.querydsl.applySorting(sort, query).fetch();
    }

    private ProjectionFactory getProjectionFactory() {
        if (this.projectionFactory == null) {
            this.projectionFactory = new SpelAwareProxyProjectionFactory();
        }
        return this.projectionFactory;
    }

    class QuerydslQueryStrategy
    implements KeysetScrollDelegate.QueryStrategy<Expression<?>, BooleanExpression> {
        QuerydslQueryStrategy() {
        }

        @Override
        public Expression<?> createExpression(String property) {
            return QuerydslJpaPredicateExecutor.this.querydsl.createExpression(property);
        }

        @Override
        public BooleanExpression compare(Sort.Order order, Expression<?> propertyExpression, Object value) {
            return Expressions.booleanOperation((Operator)(order.isAscending() ? Ops.GT : Ops.LT), (Expression[])new Expression[]{propertyExpression, ConstantImpl.create((Object)value)});
        }

        @Override
        public BooleanExpression compare(Expression<?> propertyExpression, @Nullable Object value) {
            return Expressions.booleanOperation((Operator)Ops.EQ, (Expression[])new Expression[]{propertyExpression, value == null ? NullExpression.DEFAULT : ConstantImpl.create((Object)value)});
        }

        @Override
        public BooleanExpression and(List<BooleanExpression> intermediate) {
            return Expressions.allOf((BooleanExpression[])intermediate.toArray(new BooleanExpression[0]));
        }

        @Override
        public BooleanExpression or(List<BooleanExpression> intermediate) {
            return Expressions.anyOf((BooleanExpression[])intermediate.toArray(new BooleanExpression[0]));
        }
    }
}

