/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.util;

import java.io.Serializable;
import java.util.NoSuchElementException;
import org.apache.pekko.http.scaladsl.util.FastFuture;
import org.apache.pekko.http.scaladsl.util.FastFuture$EnhancedFuture$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.collection.BuildFrom;
import scala.collection.IterableOnce;
import scala.collection.mutable.Builder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

public final class FastFuture$ {
    public static final FastFuture$ MODULE$ = new FastFuture$();
    private static final Function1<Object, Future<Object>> _successful = (Function1 & Serializable)a -> new FastFuture.FulfilledFuture<Object>(a);
    private static final Function1<Throwable, Future<Nothing$>> failed = (Function1 & Serializable)error -> new FastFuture.ErrorFuture((Throwable)error);

    public <T> Future<T> apply(Try<T> value) {
        Try<T> try_ = value;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Object t = success.value();
            return new FastFuture.FulfilledFuture<Object>(t);
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            return new FastFuture.ErrorFuture(e);
        }
        throw new MatchError(try_);
    }

    public <T> Function1<T, Future<T>> successful() {
        return _successful;
    }

    public Function1<Throwable, Future<Nothing$>> failed() {
        return failed;
    }

    public <T> Future<T> EnhancedFuture(Future<T> future) {
        return future;
    }

    public <T, M extends IterableOnce<Object>> Future<M> sequence(M in, BuildFrom<M, T, M> cbf, ExecutionContext executor) {
        return this.map$extension(FastFuture$EnhancedFuture$.MODULE$.fast$extension(this.EnhancedFuture((Future)in.iterator().foldLeft(this.successful().apply((Object)cbf.newBuilder(in)), (Function2 & Serializable)(fr, fa) -> MODULE$.flatMap$extension(FastFuture$EnhancedFuture$.MODULE$.fast$extension(MODULE$.EnhancedFuture((Future)fr)), (Function1 & Serializable)r -> MODULE$.map$extension(FastFuture$EnhancedFuture$.MODULE$.fast$extension(MODULE$.EnhancedFuture((Future)fa)), (Function1 & Serializable)a -> (Builder)r.$plus$eq(a), executor), executor)))), (Function1 & Serializable)x$2 -> (IterableOnce)x$2.result(), executor);
    }

    public <A, B, M extends IterableOnce<Object>> Future<M> traverse(M in, Function1<A, Future<B>> fn, BuildFrom<M, B, M> cbf, ExecutionContext executor) {
        return this.map$extension(FastFuture$EnhancedFuture$.MODULE$.fast$extension(this.EnhancedFuture((Future)in.iterator().foldLeft(this.successful().apply((Object)cbf.newBuilder(in)), (Function2 & Serializable)(fr, a) -> {
            Future fb = (Future)fn.apply(a);
            return MODULE$.flatMap$extension(FastFuture$EnhancedFuture$.MODULE$.fast$extension(MODULE$.EnhancedFuture((Future)fr)), (Function1 & Serializable)r -> MODULE$.map$extension(FastFuture$EnhancedFuture$.MODULE$.fast$extension(MODULE$.EnhancedFuture(fb)), (Function1 & Serializable)b -> (Builder)r.$plus$eq(b), executor), executor);
        }))), (Function1 & Serializable)x$3 -> (IterableOnce)x$3.result(), executor);
    }

    public final <B, A> Future<B> map$extension(Future<A> $this, Function1<A, B> f, ExecutionContext ec) {
        return this.transformWith$extension($this, (Function1 & Serializable)a -> (Future)MODULE$.successful().apply(f.apply(a)), this.failed(), ec);
    }

    public final <B, A> Future<B> flatMap$extension(Future<A> $this, Function1<A, Future<B>> f, ExecutionContext ec) {
        return this.transformWith$extension($this, f, this.failed(), ec);
    }

    public final <A> Future<A> filter$extension(Future<A> $this, Function1<A, Object> pred, ExecutionContext executor) {
        return this.flatMap$extension($this, (Function1 & Serializable)r -> {
            if (BoxesRunTime.unboxToBoolean((Object)pred.apply(r))) {
                return $this;
            }
            throw new NoSuchElementException("Future.filter predicate is not satisfied");
        }, executor);
    }

    public final <A> void foreach$extension(Future<A> $this, Function1<A, BoxedUnit> f, ExecutionContext ec) {
        this.map$extension($this, f, ec);
    }

    public final <B, A> Future<B> transformWith$extension(Future<A> $this, Function1<Try<A>, Future<B>> f, ExecutionContext executor) {
        return this.transformWith$extension($this, (Function1 & Serializable)a -> (Future)f.apply((Object)new Success(a)), (Function1 & Serializable)e -> (Future)f.apply((Object)new Failure(e)), executor);
    }

    public final <B, A> Future<B> transformWith$extension(Future<A> $this, Function1<A, Future<B>> s2, Function1<Throwable, Future<B>> f, ExecutionContext executor) {
        Try try_;
        Future<A> future = $this;
        if (future instanceof FastFuture.FulfilledFuture) {
            FastFuture.FulfilledFuture fulfilledFuture = (FastFuture.FulfilledFuture)future;
            Object a = fulfilledFuture.a();
            return FastFuture$.strictTransform$1(a, s2);
        }
        if (future instanceof FastFuture.ErrorFuture) {
            FastFuture.ErrorFuture errorFuture = (FastFuture.ErrorFuture)future;
            Throwable e = errorFuture.error();
            return FastFuture$.strictTransform$1(e, f);
        }
        boolean bl = false;
        Some some = null;
        Option option = $this.value();
        if (None$.MODULE$.equals(option)) {
            Promise p = Promise$.MODULE$.apply();
            $this.onComplete((Function1 & Serializable)x0$1 -> {
                Try try_ = x0$1;
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    Object a = success.value();
                    return p.completeWith(FastFuture$.strictTransform$1(a, s2));
                }
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    return p.completeWith(FastFuture$.strictTransform$1(e, f));
                }
                throw new MatchError((Object)try_);
            }, executor);
            return p.future();
        }
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            Try try_2 = (Try)some.value();
            if (try_2 instanceof Success) {
                Success success = (Success)try_2;
                Object a = success.value();
                return FastFuture$.strictTransform$1(a, s2);
            }
        }
        if (bl && (try_ = (Try)some.value()) instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            return FastFuture$.strictTransform$1(e, f);
        }
        throw new MatchError((Object)option);
    }

    public final <B, A> Future<B> recover$extension(Future<A> $this, PartialFunction<Throwable, B> pf, ExecutionContext ec) {
        return this.transformWith$extension($this, this.successful(), (Function1 & Serializable)t -> {
            if (pf.isDefinedAt(t)) {
                return (Future)MODULE$.successful().apply(pf.apply(t));
            }
            return $this;
        }, ec);
    }

    public final <B, A> Future<B> recoverWith$extension(Future<A> $this, PartialFunction<Throwable, Future<B>> pf, ExecutionContext ec) {
        return this.transformWith$extension($this, this.successful(), (Function1 & Serializable)t -> (Future)pf.applyOrElse(t, (Function1 & Serializable)x$1 -> $this), ec);
    }

    public final <A> int hashCode$extension(Future<A> $this) {
        return $this.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final <A> boolean equals$extension(Future<A> $this, Object x$1) {
        Object object = x$1;
        if (!(object instanceof FastFuture)) return false;
        boolean bl = true;
        if (!bl) return false;
        Future future = x$1 == null ? null : ((FastFuture)x$1).future();
        Future<A> future2 = $this;
        Future future3 = future;
        if (future2 != null) {
            if (!future2.equals(future3)) return false;
            return true;
        }
        if (future3 == null) return true;
        return false;
    }

    private static final Future strictTransform$1(Object x, Function1 f) {
        Future future;
        try {
            future = (Future)f.apply(x);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                future = new FastFuture.ErrorFuture(e);
            }
            throw throwable;
        }
        return future;
    }

    private FastFuture$() {
    }
}

