/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.smbj.share;

import com.hierynomus.mssmb2.SMB2FileId;
import com.hierynomus.mssmb2.messages.SMB2WriteResponse;
import com.hierynomus.protocol.commons.concurrent.AFuture;
import com.hierynomus.protocol.commons.concurrent.Futures;
import com.hierynomus.smbj.ProgressListener;
import com.hierynomus.smbj.common.SMBRuntimeException;
import com.hierynomus.smbj.io.ArrayByteChunkProvider;
import com.hierynomus.smbj.io.ByteChunkProvider;
import com.hierynomus.smbj.share.FileOutputStream;
import com.hierynomus.smbj.share.Share;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMB2Writer {
    private static final Logger logger = LoggerFactory.getLogger(SMB2Writer.class);
    private Share share;
    private SMB2FileId fileId;
    private String entryName;

    public SMB2Writer(Share share, SMB2FileId fileId, String entryName) {
        this.share = share;
        this.fileId = fileId;
        this.entryName = entryName;
    }

    public long write(byte[] buffer, long fileOffset) {
        return this.write(buffer, fileOffset, 0, buffer.length);
    }

    public long write(byte[] buffer, long fileOffset, int offset, int length) {
        return this.write(new ArrayByteChunkProvider(buffer, offset, length, fileOffset), null);
    }

    public long write(ByteChunkProvider provider) {
        return this.write(provider, null);
    }

    public long write(ByteChunkProvider provider, ProgressListener progressListener) {
        int bytesWritten = 0;
        while (provider.isAvailable()) {
            logger.debug("Writing to {} from offset {}", (Object)this.entryName, (Object)provider.getOffset());
            SMB2WriteResponse wresp = this.share.write(this.fileId, provider);
            bytesWritten += wresp.getBytesWritten();
            if (progressListener == null) continue;
            progressListener.onProgressChanged(wresp.getBytesWritten(), provider.getOffset());
        }
        return bytesWritten;
    }

    public Future<Long> writeAsync(byte[] buffer, long fileOffset, int offset, int length) {
        return this.writeAsync(new ArrayByteChunkProvider(buffer, offset, length, fileOffset));
    }

    public Future<Long> writeAsync(ByteChunkProvider provider) {
        ArrayList wrespFutureList = new ArrayList();
        while (provider.isAvailable()) {
            logger.debug("Sending async write request to {} from offset {}", (Object)this.entryName, (Object)provider.getOffset());
            Future<SMB2WriteResponse> resp = this.share.writeAsync(this.fileId, provider);
            final long bytesWritten = provider.getLastWriteSize();
            wrespFutureList.add(Futures.transform(resp, new AFuture.Function<SMB2WriteResponse, Long>(){

                @Override
                public Long apply(SMB2WriteResponse t) {
                    long receivedBytes = t.getBytesWritten();
                    if (receivedBytes == bytesWritten) {
                        return bytesWritten;
                    }
                    throw new SMBRuntimeException("Possible remote file corruption detected, server wrote less bytes (" + receivedBytes + ") in async mode than we sent (" + bytesWritten + ").");
                }
            }));
        }
        return Futures.transform(Futures.sequence(wrespFutureList), new AFuture.Function<List<Long>, Long>(){

            @Override
            public Long apply(List<Long> a) {
                long sum = 0L;
                for (Long i : a) {
                    sum += i.longValue();
                }
                return sum;
            }
        });
    }

    public OutputStream getOutputStream() {
        return this.getOutputStream(null, 0L);
    }

    public OutputStream getOutputStream(ProgressListener listener, long offset) {
        return new FileOutputStream(this, this.share.getWriteBufferSize(), offset, listener);
    }
}

