/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.routing;

import java.util.concurrent.ThreadLocalRandom;
import org.apache.pekko.actor.ActorCell;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorRefWithCell;
import org.apache.pekko.actor.Cell;
import org.apache.pekko.routing.ActorRefRoutee;
import org.apache.pekko.routing.NoRoutee$;
import org.apache.pekko.routing.Routee;
import org.apache.pekko.routing.RoutingLogic;
import org.apache.pekko.routing.SmallestMailboxRoutingLogic$;
import scala.collection.immutable.IndexedSeq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005=q!B\t\u0013\u0011\u0003Yb!B\u000f\u0013\u0011\u0003q\u0002\"B\u0013\u0002\t\u00031\u0003\"B\u0014\u0002\t\u0003Ac\u0001B\u000f\u0013\u0001)BQ!\n\u0003\u0005\u0002!BQA\f\u0003\u0005B=BQA\u0011\u0003\u0005\n\rCqA\u0018\u0003\u0012\u0002\u0013%q\fC\u0004i\tE\u0005I\u0011B5\t\u000f-$\u0011\u0013!C\u0005Y\"9a\u000eBI\u0001\n\u0013y\u0007\"B9\u0005\t#\u0011\b\"B;\u0005\t#1\b\"\u0002=\u0005\t#I\b\"B>\u0005\t#a\b\"\u0002@\u0005\t#y\u0018aG*nC2dWm\u001d;NC&d'm\u001c=S_V$\u0018N\\4M_\u001eL7M\u0003\u0002\u0014)\u00059!o\\;uS:<'BA\u000b\u0017\u0003\u0015\u0001Xm[6p\u0015\t9\u0002$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00023\u0005\u0019qN]4\u0004\u0001A\u0011A$A\u0007\u0002%\tY2+\\1mY\u0016\u001cH/T1jY\n|\u0007PU8vi&tw\rT8hS\u000e\u001c\"!A\u0010\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0003\t\nQa]2bY\u0006L!\u0001J\u0011\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t1$A\u0003baBd\u0017\u0010F\u0001*!\taBaE\u0002\u0005?-\u0002\"\u0001\b\u0017\n\u00055\u0012\"\u0001\u0004*pkRLgn\u001a'pO&\u001c\u0017AB:fY\u0016\u001cG\u000fF\u00021ga\u0002\"\u0001H\u0019\n\u0005I\u0012\"A\u0002*pkR,W\rC\u00035\r\u0001\u0007Q'A\u0004nKN\u001c\u0018mZ3\u0011\u0005\u00012\u0014BA\u001c\"\u0005\r\te.\u001f\u0005\u0006s\u0019\u0001\rAO\u0001\be>,H/Z3t!\rY\u0004\tM\u0007\u0002y)\u0011QHP\u0001\nS6lW\u000f^1cY\u0016T!aP\u0011\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002By\tQ\u0011J\u001c3fq\u0016$7+Z9\u0002\u0015M,G.Z2u\u001d\u0016DH\u000f\u0006\u00041\t\u001aCUJ\u0015\u0005\u0006\u000b\u001e\u0001\rAO\u0001\bi\u0006\u0014x-\u001a;t\u0011\u001d9u\u0001%AA\u0002A\na\u0002\u001d:pa>\u001cX\r\u001a+be\u001e,G\u000fC\u0004J\u000fA\u0005\t\u0019\u0001&\u0002\u0019\r,(O]3oiN\u001bwN]3\u0011\u0005\u0001Z\u0015B\u0001'\"\u0005\u0011auN\\4\t\u000f9;\u0001\u0013!a\u0001\u001f\u0006\u0011\u0011\r\u001e\t\u0003AAK!!U\u0011\u0003\u0007%sG\u000fC\u0004T\u000fA\u0005\t\u0019\u0001+\u0002\t\u0011,W\r\u001d\t\u0003AUK!AV\u0011\u0003\u000f\t{w\u000e\\3b]\"\u0012q\u0001\u0017\t\u00033rk\u0011A\u0017\u0006\u00037\u0006\n!\"\u00198o_R\fG/[8o\u0013\ti&LA\u0004uC&d'/Z2\u0002)M,G.Z2u\u001d\u0016DH\u000f\n3fM\u0006,H\u000e\u001e\u00133+\u0005\u0001'F\u0001\u0019bW\u0005\u0011\u0007CA2g\u001b\u0005!'BA3[\u0003%)hn\u00195fG.,G-\u0003\u0002hI\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002)M,G.Z2u\u001d\u0016DH\u000f\n3fM\u0006,H\u000e\u001e\u00134+\u0005Q'F\u0001&b\u0003Q\u0019X\r\\3di:+\u0007\u0010\u001e\u0013eK\u001a\fW\u000f\u001c;%iU\tQN\u000b\u0002PC\u0006!2/\u001a7fGRtU\r\u001f;%I\u00164\u0017-\u001e7uIU*\u0012\u0001\u001d\u0016\u0003)\u0006\fA\"[:UKJl\u0017N\\1uK\u0012$\"\u0001V:\t\u000bQd\u0001\u0019\u0001\u0019\u0002\u0003\u0005\f1#[:Qe>\u001cWm]:j]\u001elUm]:bO\u0016$\"\u0001V<\t\u000bQl\u0001\u0019\u0001\u0019\u0002\u0017!\f7/T3tg\u0006<Wm\u001d\u000b\u0003)jDQ\u0001\u001e\bA\u0002A\n1\"[:TkN\u0004XM\u001c3fIR\u0011A+ \u0005\u0006i>\u0001\r\u0001M\u0001\u0011]Vl'-\u001a:PM6+7o]1hKN$2aTA\u0001\u0011\u0015!\b\u00031\u00011Q\u001d!\u0011QAA\u0006\u0003\u001b\u00012\u0001IA\u0004\u0013\r\tI!\t\u0002\u0011'\u0016\u0014\u0018.\u00197WKJ\u001c\u0018n\u001c8V\u0013\u0012\u000bQA^1mk\u0016t\u0012!\u0001")
public class SmallestMailboxRoutingLogic
implements RoutingLogic {
    private static final long serialVersionUID = 1L;

    public static SmallestMailboxRoutingLogic apply() {
        return SmallestMailboxRoutingLogic$.MODULE$.apply();
    }

    @Override
    public Routee select(Object message, IndexedSeq<Routee> routees) {
        if (routees.isEmpty()) {
            return NoRoutee$.MODULE$;
        }
        return this.selectNext(routees, this.selectNext$default$2(), this.selectNext$default$3(), this.selectNext$default$4(), this.selectNext$default$5());
    }

    private Routee selectNext(IndexedSeq<Routee> targets, Routee proposedTarget, long currentScore, int at, boolean deep) {
        while (!targets.isEmpty()) {
            long newScore;
            long l;
            if (at >= targets.size()) {
                if (deep) {
                    if (this.isTerminated(proposedTarget)) {
                        return (Routee)targets.apply(ThreadLocalRandom.current().nextInt(targets.size()));
                    }
                    return proposedTarget;
                }
                deep = true;
                at = 0;
                continue;
            }
            Routee target = (Routee)targets.apply(at);
            if (this.isSuspended(target)) {
                l = 0x7FFFFFFFFFFFFFFEL;
            } else {
                long l2;
                long l3 = this.isProcessingMessage(target) ? 1L : 0L;
                if (!this.hasMessages(target)) {
                    l2 = 0L;
                } else {
                    long noOfMsgs = deep ? (long)this.numberOfMessages(target) : 0L;
                    l2 = noOfMsgs > 0L ? noOfMsgs : 0x7FFFFFFFFFFFFFFCL;
                }
                l = newScore = l3 + l2;
            }
            if (newScore == 0L) {
                return target;
            }
            if (newScore < 0L || newScore >= currentScore) {
                ++at;
                continue;
            }
            ++at;
            currentScore = newScore;
            proposedTarget = target;
        }
        return NoRoutee$.MODULE$;
    }

    private Routee selectNext$default$2() {
        return NoRoutee$.MODULE$;
    }

    private long selectNext$default$3() {
        return Long.MAX_VALUE;
    }

    private int selectNext$default$4() {
        return 0;
    }

    private boolean selectNext$default$5() {
        return false;
    }

    public boolean isTerminated(Routee a) {
        Routee routee = a;
        if (routee instanceof ActorRefRoutee) {
            ActorRefRoutee actorRefRoutee = (ActorRefRoutee)routee;
            ActorRef ref = actorRefRoutee.ref();
            return ref.isTerminated();
        }
        return false;
    }

    public boolean isProcessingMessage(Routee a) {
        ActorRefRoutee actorRefRoutee;
        ActorRef x;
        Routee routee = a;
        if (routee instanceof ActorRefRoutee && (x = (actorRefRoutee = (ActorRefRoutee)routee).ref()) instanceof ActorRefWithCell) {
            ActorRefWithCell actorRefWithCell = (ActorRefWithCell)x;
            Cell cell = actorRefWithCell.underlying();
            if (cell instanceof ActorCell) {
                ActorCell actorCell = (ActorCell)cell;
                return actorCell.mailbox().isScheduled() && actorCell.currentMessage() != null;
            }
            return false;
        }
        return false;
    }

    public boolean hasMessages(Routee a) {
        ActorRefRoutee actorRefRoutee;
        ActorRef x;
        Routee routee = a;
        if (routee instanceof ActorRefRoutee && (x = (actorRefRoutee = (ActorRefRoutee)routee).ref()) instanceof ActorRefWithCell) {
            ActorRefWithCell actorRefWithCell = (ActorRefWithCell)x;
            return actorRefWithCell.underlying().hasMessages();
        }
        return false;
    }

    public boolean isSuspended(Routee a) {
        ActorRefRoutee actorRefRoutee;
        ActorRef x;
        Routee routee = a;
        if (routee instanceof ActorRefRoutee && (x = (actorRefRoutee = (ActorRefRoutee)routee).ref()) instanceof ActorRefWithCell) {
            ActorRefWithCell actorRefWithCell = (ActorRefWithCell)x;
            Cell cell = actorRefWithCell.underlying();
            if (cell instanceof ActorCell) {
                ActorCell actorCell = (ActorCell)cell;
                return actorCell.mailbox().isSuspended();
            }
            return true;
        }
        return false;
    }

    public int numberOfMessages(Routee a) {
        ActorRefRoutee actorRefRoutee;
        ActorRef x;
        Routee routee = a;
        if (routee instanceof ActorRefRoutee && (x = (actorRefRoutee = (ActorRefRoutee)routee).ref()) instanceof ActorRefWithCell) {
            ActorRefWithCell actorRefWithCell = (ActorRefWithCell)x;
            return actorRefWithCell.underlying().numberOfMessages();
        }
        return 0;
    }
}

